#!/bin/bash

# Set default values for optional parameters
bucket_name=""
develocity_drv_grafana_admin_group_ids=()
develocity_drv_grafana_admin_user_ids=()
aws_region=""
aws_profile=""
apply=false
destroy=false
prefix=""

# Parse the command line arguments
while [[ $# -gt 0 ]]; do
  case $1 in
    --prefix)
      prefix="$2-"
      shift # past argument
      shift # past value
      ;;
    --destroy)
      destroy=true
      shift # past argument
      ;;
    --apply)
      apply=true
      shift # past argument
      ;;
    --bucket-name)
      bucket_name=$2
      shift # past argument
      shift # past value
      ;;
    --develocity-drv-grafana-admin-group-ids)
      develocity_drv_grafana_admin_group_ids+=("\"$2\"")
      shift # past argument
      shift # past value
      ;;
    --develocity-drv-grafana-admin-user-ids)
      develocity_drv_grafana_admin_user_ids+=("\"$2\"")
      shift # past argument
      shift # past value
      ;;
    --aws-region)
      aws_region=$2
      shift # past argument
      shift # past value
      ;;
    --aws-profile)
      aws_profile=$2
      shift # past argument
      shift # past value
      ;;
    *)
      echo "Unknown argument: $1"
      exit 1
      ;;
  esac
done

# Check for required parameters
if [[ -z "$bucket_name" ]]; then
  echo "Error: --bucket-name is required"
  exit 1
fi

if [[ -z "$aws_region" ]]; then
  echo "Error: --aws-region is required"
  exit 1
fi

if [[ -z "$aws_profile" ]]; then
  echo "Error: --aws-profile is required"
  exit 1
fi

# Check that either group ids or user ids have a value
if [[ ${#develocity_drv_grafana_admin_group_ids[@]} -eq 0 && ${#develocity_drv_grafana_admin_user_ids[@]} -eq 0 ]]; then
  echo "Error: Either --develocity-drv-grafana-admin-group-ids or --develocity-drv-grafana-admin-user-ids must be specified"
  exit 1
fi

# Convert the arrays to comma-separated strings
develocity_drv_grafana_admin_group_ids="[$(echo ${develocity_drv_grafana_admin_group_ids[*]} | tr ' ' ',')]"
develocity_drv_grafana_admin_user_ids="[$(echo ${develocity_drv_grafana_admin_user_ids[*]} | tr ' ' ',')]"

terraform -chdir="stages/provision-aws-grafana" init

if [[ $destroy == true ]]; then
  # Call terraform with the variables
  terraform -chdir="stages/provision-aws-grafana" destroy \
    -var "bucket_name=$bucket_name" \
    -var "develocity_drv_grafana_admin_group_ids=$develocity_drv_grafana_admin_group_ids" \
    -var "develocity_drv_grafana_admin_user_ids=$develocity_drv_grafana_admin_user_ids" \
    -var "aws_region=$aws_region" \
    -var "aws_profile=$aws_profile" \
    -var "prefix=$prefix"
  exit 0
fi


if [[ $apply == true ]]; then
  # Call terraform with the variables
  terraform -chdir="stages/provision-aws-grafana" apply \
    -var "bucket_name=$bucket_name" \
    -var "develocity_drv_grafana_admin_group_ids=$develocity_drv_grafana_admin_group_ids" \
    -var "develocity_drv_grafana_admin_user_ids=$develocity_drv_grafana_admin_user_ids" \
    -var "aws_region=$aws_region" \
    -var "aws_profile=$aws_profile" \
    -var "prefix=$prefix"
else
  echo "Running terraform plan..."
  echo "If you want to apply the changes, run this script with the --apply flag"

  # Call terraform with the variables
  terraform -chdir="stages/provision-aws-grafana" plan \
    -var "bucket_name=$bucket_name" \
    -var "develocity_drv_grafana_admin_group_ids=$develocity_drv_grafana_admin_group_ids" \
    -var "develocity_drv_grafana_admin_user_ids=$develocity_drv_grafana_admin_user_ids" \
    -var "aws_region=$aws_region" \
    -var "aws_profile=$aws_profile" \
    -var "prefix=$prefix"
fi
