locals {
  expiration_seconds = 60 * 60
}

resource "time_rotating" "rotate" {
  rotation_minutes = 60
}

resource "time_static" "rotate" {
  rfc3339 = time_rotating.rotate.rfc3339
}

resource "aws_grafana_workspace_api_key" "datasource-setup-admin-key" {
  key_name        = "datasource-setup-admin-key"
  key_role        = "ADMIN"
  seconds_to_live = local.expiration_seconds
  workspace_id    = aws_grafana_workspace.develocity_drv_grafana.id

  lifecycle {
    replace_triggered_by = [
      time_static.rotate
    ]
  }
}
