CREATE OR REPLACE VIEW internal_dependency_summary AS
WITH view_base AS (
    SELECT COALESCE(mavenattributes.toplevelprojectname, gradleattributes.rootprojectname, npmattributes.packageName) projectname,
           COALESCE(gradleattributes.tags, mavenattributes.tags, npmattributes.tags)                                  tags,
           id                                                                                                         build_id,
           type                                                                                                       build_tool,
           COALESCE(gradleattributes.buildduration, mavenattributes.buildduration, npmattributes.buildduration)       build_duration_millis,
           COALESCE(gradleattributes."values", mavenattributes."values", npmattributes."values")                      custom_values,
           COALESCE(gradleDependencies.dependencies, mavenDependencies.dependencies, npmDependencies.dependencies)    dependencies,
           COALESCE(mavenattributes.buildstarttime, gradleattributes.buildstarttime, npmattributes.buildstarttime)    build_start_timestamp,
           build_start_date,
           build_start_time,
           drv_chunk_id
    FROM build
)
SELECT view_base.build_id                                                                                                           build_id,
       concat(dependency.scheme, ':', dependency.type, if(dependency.namespace is null, '', concat('/', dependency.namespace)), '/',
              dependency.name)                                                                                                      dependency_unversioned_id,
       concat(dependency.scheme, ':', dependency.type, if(dependency.namespace is null, '', concat('/', dependency.namespace)), '/', dependency.name,
              if(dependency.version is null, '', concat('@', dependency.version)))                                                  dependency_versioned_id,
       dependency.scheme                                                                                                            scheme,
       dependency.type                                                                                                              type,
       dependency.namespace                                                                                                         namespace,
       dependency.name                                                                                                              name,
       dependency.version                                                                                                           version,
       dependency.qualifiers                                                                                                        qualifiers,
       JSON_FORMAT(CAST(dependency.qualifiers as JSON))                                                                             qualifiers_json,
       dependency.subpath                                                                                                           subpath,
       dependency.purl                                                                                                              purl,
       dependency.repository                                                                                                        repository,
       view_base.build_duration_millis                                                                                              build_duration_millis,
       view_base.projectname                                                                                                        projectname,
       element_at(filter(view_base.custom_values, entry -> entry.name = 'Git repository'), 1).value                                 vcs_repo,
       view_base.build_tool                                                                                                         build_tool,
       (CASE WHEN (CONTAINS(view_base.tags, 'CI') = true) THEN 'CI' WHEN (CONTAINS(view_base.tags, 'CI') = false) THEN 'Local' END) environment,
       view_base.tags                                                                                                               tags,
       view_base.build_start_timestamp                                                                                              build_start_timestamp,
       build_start_date,
       build_start_time,
       drv_chunk_id
FROM view_base,
     unnest(dependencies) as t(dependency)
WHERE view_base.projectname IS NOT NULL
