CREATE EXTERNAL TABLE plugin_summary (
`build_id` string,
`plugin_id` string,
`group_artifact` string,
`version` string,
`modules` array<string>,
`projectname` string,
`build_tool` string,
`build_duration_millis` bigint,
`tags` array<string>,
`environment` string,
`build_start_timestamp` bigint COMMENT 'Use build_start_date instead',
`drv_chunk_row_number` bigint)
PARTITIONED BY ( `build_start_date` date COMMENT 'Partition field storing the start date as a DATE. Use this to speed up queries by including a timeframe.', `build_start_time` string, `drv_chunk_id` string)
ROW FORMAT SERDE 'org.apache.hadoop.hive.ql.io.orc.OrcSerde'
WITH
  serdeproperties ('orc.column.index.access'='false')
    STORED AS
       INPUTFORMAT 'org.apache.hadoop.hive.ql.io.orc.OrcInputFormat'
       OUTPUTFORMAT 'org.apache.hadoop.hive.ql.io.orc.OrcOutputFormat'
LOCATION '${s3.path}tables/plugin_summary/'
TBLPROPERTIES ('develocity.reporting.schemaversion'='${currentVersion}', 'develocity.reporting.partition.date.key'='build_start_date', 'develocity.reporting.population.order'='1', 'develocity.reporting.source'='internal_plugin_summary')
