CREATE EXTERNAL TABLE build(
   `type` string COMMENT 'Indicates the type of build tool used, such as Gradle, Maven, Bazel, npm, Python, or sbt. This classification helps in interpreting the build data according to the conventions and features of the specific build system.',
   `id` string COMMENT 'A unique identifier for the build, also known as buildId. This ID allows for precise referencing and retrieval of build data within the system.',
   `buildToolVersion` string COMMENT 'Specifies the version of the build tool used for the build. This information is important for understanding build behavior, compatibility, and potential issues related to specific versions of the build tool.',
   `buildAgentVersion` string COMMENT 'Indicates the version of the build agent or extension that collected and reported the build data. This helps in tracking the capabilities and features available during the build data collection process.',
   `modelVersion` struct<`patch`: int, `release`: int, `string`: string, `year`: int> COMMENT 'Denotes the version of Develocity that produced the build data model. This versioning is crucial for understanding what data models were available at the time of export.',
   `gradleAttributes` struct<`buildDuration`: bigint, `buildOptions`: struct<`buildCacheEnabled`: boolean, `configurationCacheEnabled`: boolean, `configurationOnDemandEnabled`: boolean, `continueOnFailureEnabled`: boolean, `continuousBuildEnabled`: boolean, `daemonEnabled`: boolean, `dryRunEnabled`: boolean, `excludedTasks`: array<string>, `fileSystemWatchingEnabled`: boolean, `isolatedProjectsEnabled`: boolean, `maxNumberOfGradleWorkers`: int, `offlineModeEnabled`: boolean, `parallelProjectExecutionEnabled`: boolean, `refreshDependenciesEnabled`: boolean, `rerunTasksEnabled`: boolean>, `buildStartTime`: bigint, `develocitySettings`: struct<`backgroundPublicationEnabled`: boolean, `buildOutputCapturingEnabled`: boolean, `fileFingerprintCapturingEnabled`: boolean, `resourceUsageCapturingEnabled`: boolean, `taskInputsFileCapturingEnabled`: boolean, `testOutputCapturingEnabled`: boolean>, `environment`: struct<`jreVersion`: string, `jvmCharset`: string, `jvmLocale`: string, `jvmMaxMemoryHeapSize`: bigint, `jvmVersion`: string, `localHostname`: string, `localIpAddresses`: array<string>, `numberOfCpuCores`: int, `operatingSystem`: string, `publicHostname`: string, `username`: string>, `gradleEnterpriseSettings`: struct<`backgroundPublicationEnabled`: boolean, `buildOutputCapturingEnabled`: boolean, `resourceUsageCapturingEnabled`: boolean, `taskInputsFileCapturingEnabled`: boolean, `testOutputCapturingEnabled`: boolean>, `gradleVersion`: string, `hasFailed`: boolean, `hasNonVerificationFailure`: boolean, `hasVerificationFailure`: boolean, `id`: string, `links`: array<struct<`label`: string, `url`: string>>, `pluginVersion`: string, `requestedTasks`: array<string>, `rootProjectName`: string, `tags`: array<string>, `values`: array<struct<`name`: string, `value`: string>>>
			COMMENT 'Provides essential metadata about a Gradle build execution, including its configuration, environment, and outcome. This information helps understand the context in which a build ran and enables analysis of build behavior patterns.',
   `mavenAttributes` struct<`buildDuration`: bigint, `buildOptions`: struct<`batchModeEnabled`: boolean, `daemonEnabled`: boolean, `debugEnabled`: boolean, `errorsEnabled`: boolean, `failAtEndEnabled`: boolean, `failFastEnabled`: boolean, `failNeverEnabled`: boolean, `laxChecksumsEnabled`: boolean, `maxNumberOfThreads`: int, `noSnapshotsUpdatesEnabled`: boolean, `nonRecursiveEnabled`: boolean, `offlineModeEnabled`: boolean, `quietEnabled`: boolean, `rerunGoals`: boolean, `rerunGoalsEnabled`: boolean, `resumeEnabled`: boolean, `strictChecksumsEnabled`: boolean, `updateSnapshotsEnabled`: boolean>, `buildStartTime`: bigint, `develocitySettings`: struct<`backgroundPublicationEnabled`: boolean, `buildOutputCapturingEnabled`: boolean, `fileFingerprintCapturingEnabled`: boolean, `goalInputsFileCapturingEnabled`: boolean, `resourceUsageCapturingEnabled`: boolean, `testOutputCapturingEnabled`: boolean>, `environment`: struct<`jreVersion`: string, `jvmCharset`: string, `jvmLocale`: string, `jvmMaxMemoryHeapSize`: bigint, `jvmVersion`: string, `localHostname`: string, `localIpAddresses`: array<string>, `numberOfCpuCores`: int, `operatingSystem`: string, `publicHostname`: string, `username`: string>, `extensionVersion`: string, `gradleEnterpriseSettings`: struct<`backgroundPublicationEnabled`: boolean, `buildOutputCapturingEnabled`: boolean, `goalInputsFileCapturingEnabled`: boolean, `resourceUsageCapturingEnabled`: boolean, `testOutputCapturingEnabled`: boolean>, `hasFailed`: boolean, `hasNonVerificationFailure`: boolean, `hasVerificationFailure`: boolean, `id`: string, `links`: array<struct<`label`: string, `url`: string>>, `mavenVersion`: string, `requestedGoals`: array<string>, `tags`: array<string>, `topLevelProjectName`: string, `values`: array<struct<`name`: string, `value`: string>>>
			COMMENT 'Provides essential metadata about a Maven build execution, including its goals, configuration, and outcome. This context enables understanding Maven-specific build behavior and patterns.',
   `bazelAttributes` struct<`bazelVersion`: string, `buildDuration`: bigint, `buildStartTime`: bigint, `command`: string, `exitCode`: int, `hasFailed`: boolean, `host`: string, `id`: string, `invocationId`: string, `links`: array<struct<`label`: string, `url`: string>>, `moduleName`: string, `tags`: array<string>, `targetPatterns`: array<string>, `user`: string, `values`: array<struct<`name`: string, `value`: string>>>
			COMMENT 'Provides essential metadata about a Bazel build execution. This context enables understanding Bazel-specific build characteristics and optimizing Bazel-based workflows.',
   `npmAttributes` struct<`buildDuration`: bigint, `buildStartTime`: bigint, `command`: struct<`arguments`: array<string>, `command`: string>, `exitCode`: int, `hasFailed`: boolean, `hasNonVerificationFailure`: boolean, `hasVerificationFailure`: boolean, `host`: string, `id`: string, `links`: array<struct<`label`: string, `url`: string>>, `nodejsVersion`: string, `npmAgentVersion`: string, `npmVersion`: string, `packageName`: string, `tags`: array<string>, `user`: string, `values`: array<struct<`name`: string, `value`: string>>>
			COMMENT 'Provides essential metadata about an npm build execution. This context enables understanding JavaScript/Node.js build behavior and characteristics.',
   `pythonAttributes` struct<`buildDuration`: bigint, `buildStartTime`: bigint, `command`: array<string>, `exception`: string, `exitCode`: int, `hasFailed`: boolean, `host`: string, `id`: string, `links`: array<struct<`label`: string, `url`: string>>, `projectName`: string, `pythonAgentVersion`: string, `pythonVersion`: string, `tags`: array<string>, `user`: string, `values`: array<struct<`name`: string, `value`: string>>>
			COMMENT 'Provides essential metadata about a Python build execution. This context enables understanding Python-specific build behavior and tooling usage.',
   `sbtAttributes` struct<`buildDuration`: bigint, `buildOptions`: struct<`interactiveModeEnabled`: boolean, `offlineModeEnabled`: boolean, `parallelExecutionEnabled`: boolean, `semanticDbScalacPluginEnabled`: boolean, `turboEnabled`: boolean, `useCoursierEnabled`: boolean>, `buildStartTime`: bigint, `develocitySettings`: struct<`backgroundPublicationEnabled`: boolean, `buildOutputCapturingEnabled`: boolean, `resourceUsageCapturingEnabled`: boolean>, `environment`: struct<`jreVersion`: string, `jvmCharset`: string, `jvmLocale`: string, `jvmMaxMemoryHeapSize`: bigint, `jvmVersion`: string, `localHostname`: string, `localIpAddresses`: array<string>, `numberOfCpuCores`: int, `operatingSystem`: string, `publicHostname`: string, `username`: string>, `hasFailed`: boolean, `hasNonVerificationFailure`: boolean, `hasVerificationFailure`: boolean, `id`: string, `links`: array<struct<`label`: string, `url`: string>>, `pluginVersion`: string, `requestedCommands`: array<string>, `rootProjectName`: string, `sbtVersion`: string, `tags`: array<string>, `values`: array<struct<`name`: string, `value`: string>>>
			COMMENT 'Provides essential metadata about an sbt build execution, including settings and build options. This information enables understanding Scala build behavior and sbt-specific optimizations.',
   `gradleTestPerformance` struct<`serialTestTasksExecutionTime`: bigint, `testAcceleration`: struct<`predictiveTestSelection`: struct<`simulation`: struct<`conservative`: struct<`avoidableTestClassesCount`: bigint, `serialTimeSavingsPotential`: bigint, `testClassesCountSelectedDueToInsufficientData`: bigint, `unavoidableTestClassesCount`: bigint, `wallClockSavingsPotential`: bigint, `workUnitFailuresMissedCount`: bigint, `workUnitFailuresPredictedCount`: bigint>, `fast`: struct<`avoidableTestClassesCount`: bigint, `serialTimeSavingsPotential`: bigint, `testClassesCountSelectedDueToInsufficientData`: bigint, `unavoidableTestClassesCount`: bigint, `wallClockSavingsPotential`: bigint, `workUnitFailuresMissedCount`: bigint, `workUnitFailuresPredictedCount`: bigint>, `standard`: struct<`avoidableTestClassesCount`: bigint, `serialTimeSavingsPotential`: bigint, `testClassesCountSelectedDueToInsufficientData`: bigint, `unavoidableTestClassesCount`: bigint, `wallClockSavingsPotential`: bigint, `workUnitFailuresMissedCount`: bigint, `workUnitFailuresPredictedCount`: bigint>>, `usage`: struct<`selectionMode`: string, `serialTimeSavings`: bigint, `status`: string, `wallClockSavings`: bigint>>, `testDistribution`: struct<`usageStatus`: string, `wallClockSavings`: bigint>, `wallClockSavings`: bigint>, `testTasks`: array<struct<`serialExecutionTime`: bigint, `taskPath`: string, `taskType`: string, `testAcceleration`: struct<`predictiveTestSelection`: struct<`simulation`: struct<`conservative`: struct<`avoidableTestClassesCount`: bigint, `failedTestClassesPredictedCount`: bigint, `serialTimeSavingsPotential`: bigint, `testClassesCountSelectedDueToInsufficientData`: bigint, `unavoidableTestClassesCount`: bigint, `wallClockSavingsPotential`: bigint>, `fast`: struct<`avoidableTestClassesCount`: bigint, `failedTestClassesPredictedCount`: bigint, `serialTimeSavingsPotential`: bigint, `testClassesCountSelectedDueToInsufficientData`: bigint, `unavoidableTestClassesCount`: bigint, `wallClockSavingsPotential`: bigint>, `standard`: struct<`avoidableTestClassesCount`: bigint, `failedTestClassesPredictedCount`: bigint, `serialTimeSavingsPotential`: bigint, `testClassesCountSelectedDueToInsufficientData`: bigint, `unavoidableTestClassesCount`: bigint, `wallClockSavingsPotential`: bigint>>, `usage`: struct<`nonSelectedTestClassesCount`: int, `selectionMode`: string, `serialTimeSavings`: bigint, `status`: string, `wallClockSavings`: bigint>>, `testDistribution`: struct<`remoteTestClassesCount`: int, `usageStatus`: string, `wallClockSavings`: bigint>, `wallClockSavings`: bigint>, `tests`: struct<`failedTestClassesCount`: int, `testClassesCount`: int>, `wallClockExecutionTime`: bigint>>, `tests`: struct<`testClassesCount`: int>>
			COMMENT 'Provides insights into test execution efficiency and distribution across the build. This data supports identifying slow tests, understanding test parallelization effectiveness, and optimizing overall test suite performance for Gradle builds.',
   `mavenTestPerformance` struct<`serialTestGoalsExecutionTime`: bigint, `testAcceleration`: struct<`predictiveTestSelection`: struct<`simulation`: struct<`conservative`: struct<`avoidableTestClassesCount`: bigint, `serialTimeSavingsPotential`: bigint, `testClassesCountSelectedDueToInsufficientData`: bigint, `unavoidableTestClassesCount`: bigint, `wallClockSavingsPotential`: bigint, `workUnitFailuresMissedCount`: bigint, `workUnitFailuresPredictedCount`: bigint>, `fast`: struct<`avoidableTestClassesCount`: bigint, `serialTimeSavingsPotential`: bigint, `testClassesCountSelectedDueToInsufficientData`: bigint, `unavoidableTestClassesCount`: bigint, `wallClockSavingsPotential`: bigint, `workUnitFailuresMissedCount`: bigint, `workUnitFailuresPredictedCount`: bigint>, `standard`: struct<`avoidableTestClassesCount`: bigint, `serialTimeSavingsPotential`: bigint, `testClassesCountSelectedDueToInsufficientData`: bigint, `unavoidableTestClassesCount`: bigint, `wallClockSavingsPotential`: bigint, `workUnitFailuresMissedCount`: bigint, `workUnitFailuresPredictedCount`: bigint>>, `usage`: struct<`selectionMode`: string, `serialTimeSavings`: bigint, `status`: string, `wallClockSavings`: bigint>>, `testDistribution`: struct<`usageStatus`: string, `wallClockSavings`: bigint>, `wallClockSavings`: bigint>, `testGoals`: array<struct<`goalPath`: string, `goalType`: string, `serialExecutionTime`: bigint, `testAcceleration`: struct<`predictiveTestSelection`: struct<`simulation`: struct<`conservative`: struct<`avoidableTestClassesCount`: bigint, `failedTestClassesPredictedCount`: bigint, `serialTimeSavingsPotential`: bigint, `testClassesCountSelectedDueToInsufficientData`: bigint, `unavoidableTestClassesCount`: bigint, `wallClockSavingsPotential`: bigint>, `fast`: struct<`avoidableTestClassesCount`: bigint, `failedTestClassesPredictedCount`: bigint, `serialTimeSavingsPotential`: bigint, `testClassesCountSelectedDueToInsufficientData`: bigint, `unavoidableTestClassesCount`: bigint, `wallClockSavingsPotential`: bigint>, `standard`: struct<`avoidableTestClassesCount`: bigint, `failedTestClassesPredictedCount`: bigint, `serialTimeSavingsPotential`: bigint, `testClassesCountSelectedDueToInsufficientData`: bigint, `unavoidableTestClassesCount`: bigint, `wallClockSavingsPotential`: bigint>>, `usage`: struct<`nonSelectedTestClassesCount`: int, `selectionMode`: string, `serialTimeSavings`: bigint, `status`: string, `wallClockSavings`: bigint>>, `testDistribution`: struct<`remoteTestClassesCount`: int, `usageStatus`: string, `wallClockSavings`: bigint>, `wallClockSavings`: bigint>, `tests`: struct<`failedTestClassesCount`: int, `testClassesCount`: int>, `wallClockExecutionTime`: bigint>>, `tests`: struct<`testClassesCount`: int>>
			COMMENT 'Provides insights into test execution efficiency and distribution across the build. This data supports identifying slow tests, understanding test parallelization effectiveness, and optimizing overall test suite performance for Maven builds.',
   `gradleBuildCachePerformance` struct<`avoidanceSavingsSummary`: struct<`localBuildCache`: bigint, `ratio`: double, `remoteBuildCache`: bigint, `total`: bigint, `upToDate`: bigint>, `buildCaches`: struct<`local`: struct<`directory`: string, `isDisabledDueToError`: boolean, `isEnabled`: boolean, `isPushEnabled`: boolean>, `overhead`: struct<`downloading`: bigint, `packing`: bigint, `unpacking`: bigint, `uploading`: bigint>, `remote`: struct<`className`: string, `isDisabledDueToError`: boolean, `isEnabled`: boolean, `isPushEnabled`: boolean, `type`: string, `url`: string>>, `buildTime`: bigint, `effectiveTaskExecutionTime`: bigint, `effectiveWorkUnitExecutionTime`: bigint, `id`: string, `serialTaskExecutionTime`: bigint, `serialWorkUnitExecutionTime`: bigint, `serializationFactor`: double, `taskAvoidanceSavingsSummary`: struct<`localBuildCache`: bigint, `ratio`: double, `remoteBuildCache`: bigint, `total`: bigint, `upToDate`: bigint>, `taskExecution`: array<struct<`avoidanceOutcome`: string, `avoidanceSavings`: bigint, `cacheArtifactRejectedReason`: string, `cacheArtifactSize`: bigint, `cacheKey`: string, `duration`: bigint, `fingerprintingDuration`: bigint, `hasFailed`: boolean, `nonCacheabilityCategory`: string, `nonCacheabilityReason`: string, `skipReasonMessage`: string, `taskPath`: string, `taskType`: string>>, `taskFingerprintingSummary`: struct<`count`: int, `serialDuration`: bigint>, `workUnitAvoidanceSavingsSummary`: struct<`localBuildCache`: bigint, `ratio`: double, `remoteBuildCache`: bigint, `total`: bigint, `upToDate`: bigint>, `workUnitFingerprintingSummary`: struct<`count`: int, `serialDuration`: bigint>>
			COMMENT 'Quantifies the effectiveness of build caching in reducing build time. This information helps assess cache configuration quality and measure the value delivered by caching infrastructure.',
   `mavenBuildCachePerformance` struct<`avoidanceSavingsSummary`: struct<`localBuildCache`: bigint, `ratio`: double, `remoteBuildCache`: bigint, `total`: bigint>, `buildCaches`: struct<`local`: struct<`directory`: string, `isDisabledDueToError`: boolean, `isEnabled`: boolean, `isPushEnabled`: boolean>, `overhead`: struct<`downloading`: bigint, `packing`: bigint, `unpacking`: bigint, `uploading`: bigint>, `remote`: struct<`isDisabledDueToError`: boolean, `isEnabled`: boolean, `isPushEnabled`: boolean, `url`: string>>, `buildTime`: bigint, `effectiveProjectExecutionTime`: bigint, `goalExecution`: array<struct<`avoidanceOutcome`: string, `avoidanceSavings`: bigint, `cacheArtifactRejectedReason`: string, `cacheArtifactSize`: bigint, `cacheKey`: string, `duration`: bigint, `fingerprintingDuration`: bigint, `goalExecutionId`: string, `goalName`: string, `goalProjectName`: string, `hasFailed`: boolean, `mojoType`: string, `nonCacheabilityCategory`: string, `nonCacheabilityReason`: string>>, `goalFingerprintingSummary`: struct<`count`: int, `serialDuration`: bigint>, `id`: string, `serialProjectExecutionTime`: bigint, `serializationFactor`: double>
			COMMENT 'Quantifies the effectiveness of build caching in reducing build time. This information helps assess cache configuration quality and measure the value delivered by caching infrastructure.',
   `gradleBuildProfileOverview` struct<`breakdown`: struct<`configuration`: bigint, `endOfBuild`: bigint, `execution`: bigint, `initialization`: bigint, `total`: bigint>, `memoryUsage`: struct<`memoryPools`: array<struct<`maxMemory`: bigint, `name`: string, `peakMemory`: bigint>>, `totalGarbageCollectionTime`: bigint>>
			COMMENT 'Provides a high-level performance breakdown of the Gradle build lifecycle. This summary enables quick identification of the most time-consuming builds for targeted optimization efforts.',
   `mavenBuildProfileOverview` struct<`breakdown`: struct<`execution`: struct<`endOfBuild`: bigint, `goalExecution`: bigint, `total`: bigint>, `initializationAndDiscovery`: struct<`other`: bigint, `projectDiscovery`: bigint, `settings`: bigint, `toolchains`: bigint, `total`: bigint>, `total`: bigint>, `memoryUsage`: struct<`memoryPools`: array<struct<`maxMemory`: bigint, `name`: string, `peakMemory`: bigint>>, `totalGarbageCollectionTime`: bigint>>
			COMMENT 'Provides a high-level performance breakdown of the Maven build lifecycle. This summary enables quick identification of the most time-consuming builds for targeted optimization efforts.',
   `gradleProjects` array<struct<`name`: string, `parent`: int, `path`: string>>
			COMMENT 'Maps the structure of a multi-project Gradle build. This structural information enables project-level analysis and helps understand dependencies and relationships between different parts of the build.',
   `mavenModules` array<struct<`artifactId`: string, `groupId`: string, `name`: string, `parent`: int, `version`: string>>
			COMMENT 'Maps the structure of a multi-module Maven build. This structural information enables module-level analysis and helps understand dependencies and relationships between different parts of the build.',
   `mavenDependencyResolution` struct<`fileDownloadCount`: bigint, `fileDownloadSize`: bigint, `methods`: map<string, struct<`fileDownloadCount`: bigint, `fileDownloadSize`: bigint, `networkRequestCount`: bigint, `serialNetworkRequestTime`: bigint, `wallClockNetworkRequestTime`: bigint>>, `networkRequestCount`: bigint, `repositories`: map<string, struct<`fileDownloadCount`: bigint, `fileDownloadSize`: bigint, `networkRequestCount`: bigint, `serialNetworkRequestTime`: bigint, `wallClockNetworkRequestTime`: bigint>>, `repositoryMethods`: map<string, struct<`fileDownloadCount`: bigint, `fileDownloadSize`: bigint, `networkRequestCount`: bigint, `serialNetworkRequestTime`: bigint, `wallClockNetworkRequestTime`: bigint>>, `serialDependencyResolutionTime`: bigint, `serialNetworkRequestTime`: bigint, `wallClockNetworkRequestTime`: bigint>
			COMMENT 'Tracks the time and network activity involved in resolving Maven dependencies. This data helps identify dependency resolution bottlenecks and optimize repository configuration.',
   `gradleNetworkActivity` struct<`fileDownloadCount`: bigint, `fileDownloadSize`: bigint, `methods`: map<string, struct<`fileDownloadCount`: bigint, `fileDownloadSize`: bigint, `networkRequestCount`: bigint, `serialNetworkRequestTime`: bigint, `wallClockNetworkRequestTime`: bigint>>, `networkRequestCount`: bigint, `repositories`: map<string, struct<`fileDownloadCount`: bigint, `fileDownloadSize`: bigint, `networkRequestCount`: bigint, `serialNetworkRequestTime`: bigint, `wallClockNetworkRequestTime`: bigint>>, `repositoryMethods`: map<string, struct<`fileDownloadCount`: bigint, `fileDownloadSize`: bigint, `networkRequestCount`: bigint, `serialNetworkRequestTime`: bigint, `wallClockNetworkRequestTime`: bigint>>, `serialNetworkRequestTime`: bigint, `wallClockNetworkRequestTime`: bigint>
			COMMENT 'Tracks dependency resolution network behavior to identify potential bottlenecks or inefficiencies. This data supports optimizing dependency management and reducing build times caused by network operations.',
   `npmNetworkActivity` struct<`fileDownloadCount`: bigint, `fileDownloadSize`: bigint, `methods`: map<string, struct<`fileDownloadCount`: bigint, `fileDownloadSize`: bigint, `networkRequestCount`: bigint, `serialNetworkRequestTime`: bigint, `wallClockNetworkRequestTime`: bigint>>, `networkRequestCount`: bigint, `registries`: map<string, struct<`fileDownloadCount`: bigint, `fileDownloadSize`: bigint, `networkRequestCount`: bigint, `serialNetworkRequestTime`: bigint, `wallClockNetworkRequestTime`: bigint>>, `registryMethods`: map<string, struct<`fileDownloadCount`: bigint, `fileDownloadSize`: bigint, `networkRequestCount`: bigint, `serialNetworkRequestTime`: bigint, `wallClockNetworkRequestTime`: bigint>>, `serialNetworkRequestTime`: bigint, `wallClockNetworkRequestTime`: bigint>
			COMMENT 'Tracks dependency resolution network behavior to identify potential bottlenecks or inefficiencies in downloading npm packages. This data supports optimizing dependency management and reducing build times caused by network operations.',
   `gradleArtifactTransformExecutions` struct<`artifactTransformExecutions`: array<struct<`artifactTransformExecutionName`: string, `avoidanceOutcome`: string, `avoidanceSavings`: bigint, `cacheArtifactRejectedReason`: string, `cacheArtifactSize`: bigint, `cacheKey`: string, `changedAttributes`: array<struct<`from`: string, `name`: string, `to`: string>>, `duration`: bigint, `fingerprintingDuration`: bigint, `inputArtifactName`: string, `nonCacheabilityCategory`: string, `nonCacheabilityReason`: string, `outcome`: string, `skipReasonMessage`: string, `transformActionType`: string>>>
			COMMENT 'Documents the execution of artifact transforms, which can significantly impact build performance. This information helps identify expensive transformations and opportunities for caching or parallelization improvements.',
   `gradleDeprecations` struct<`deprecations`: array<struct<`advice`: string, `documentationUrl`: string, `removalDetails`: string, `summary`: string, `usages`: array<struct<`contextualAdvice`: string, `owner`: struct<`location`: string, `type`: string>>>>>>
			COMMENT 'Lists deprecated features used in the build to support migration planning. This proactive information helps teams prepare for future Gradle versions and maintain build compatibility.',
   `gradlePlugins` struct<`plugins`: array<struct<`className`: string, `id`: string, `projects`: array<string>, `version`: string>>>
			COMMENT 'Catalogs the plugins applied across the build to understand its capabilities and potential sources of build time. This inventory supports auditing plugin usage and identifying upgrade or replacement opportunities.',
   `mavenPlugins` struct<`plugins`: array<struct<`artifactId`: string, `executedGoals`: array<string>, `goalPrefix`: string, `groupId`: string, `modules`: array<string>, `name`: string, `requiredMavenVersion`: string, `version`: string>>>
			COMMENT 'Lists the Maven plugins used across the build. This inventory supports understanding build capabilities, identifying unused plugins, and planning upgrades.',
   `mavenExtensions` struct<`extensions`: array<struct<`artifactId`: string, `groupId`: string, `type`: string, `version`: string>>>
			COMMENT 'Documents Maven extensions applied to the build. This information helps understand build customizations and their potential impact on build behavior.',
   `gradleResourceUsage` struct<`execution`: struct<`allProcessesCpu`: struct<`average`: bigint, `max`: bigint, `median`: bigint, `p25`: bigint, `p5`: bigint, `p75`: bigint, `p95`: bigint>, `allProcessesMemory`: struct<`average`: bigint, `max`: bigint, `median`: bigint, `p25`: bigint, `p5`: bigint, `p75`: bigint, `p95`: bigint>, `buildChildProcessesCpu`: struct<`average`: bigint, `max`: bigint, `median`: bigint, `p25`: bigint, `p5`: bigint, `p75`: bigint, `p95`: bigint>, `buildChildProcessesMemory`: struct<`average`: bigint, `max`: bigint, `median`: bigint, `p25`: bigint, `p5`: bigint, `p75`: bigint, `p95`: bigint>, `buildProcessCpu`: struct<`average`: bigint, `max`: bigint, `median`: bigint, `p25`: bigint, `p5`: bigint, `p75`: bigint, `p95`: bigint>, `buildProcessMemory`: struct<`average`: bigint, `max`: bigint, `median`: bigint, `p25`: bigint, `p5`: bigint, `p75`: bigint, `p95`: bigint>, `diskReadThroughput`: struct<`average`: bigint, `max`: bigint, `median`: bigint, `p25`: bigint, `p5`: bigint, `p75`: bigint, `p95`: bigint>, `diskWriteThroughput`: struct<`average`: bigint, `max`: bigint, `median`: bigint, `p25`: bigint, `p5`: bigint, `p75`: bigint, `p95`: bigint>, `networkDownloadThroughput`: struct<`average`: bigint, `max`: bigint, `median`: bigint, `p25`: bigint, `p5`: bigint, `p75`: bigint, `p95`: bigint>, `networkUploadThroughput`: struct<`average`: bigint, `max`: bigint, `median`: bigint, `p25`: bigint, `p5`: bigint, `p75`: bigint, `p95`: bigint>>, `nonExecution`: struct<`allProcessesCpu`: struct<`average`: bigint, `max`: bigint, `median`: bigint, `p25`: bigint, `p5`: bigint, `p75`: bigint, `p95`: bigint>, `allProcessesMemory`: struct<`average`: bigint, `max`: bigint, `median`: bigint, `p25`: bigint, `p5`: bigint, `p75`: bigint, `p95`: bigint>, `buildChildProcessesCpu`: struct<`average`: bigint, `max`: bigint, `median`: bigint, `p25`: bigint, `p5`: bigint, `p75`: bigint, `p95`: bigint>, `buildChildProcessesMemory`: struct<`average`: bigint, `max`: bigint, `median`: bigint, `p25`: bigint, `p5`: bigint, `p75`: bigint, `p95`: bigint>, `buildProcessCpu`: struct<`average`: bigint, `max`: bigint, `median`: bigint, `p25`: bigint, `p5`: bigint, `p75`: bigint, `p95`: bigint>, `buildProcessMemory`: struct<`average`: bigint, `max`: bigint, `median`: bigint, `p25`: bigint, `p5`: bigint, `p75`: bigint, `p95`: bigint>, `diskReadThroughput`: struct<`average`: bigint, `max`: bigint, `median`: bigint, `p25`: bigint, `p5`: bigint, `p75`: bigint, `p95`: bigint>, `diskWriteThroughput`: struct<`average`: bigint, `max`: bigint, `median`: bigint, `p25`: bigint, `p5`: bigint, `p75`: bigint, `p95`: bigint>, `networkDownloadThroughput`: struct<`average`: bigint, `max`: bigint, `median`: bigint, `p25`: bigint, `p5`: bigint, `p75`: bigint, `p95`: bigint>, `networkUploadThroughput`: struct<`average`: bigint, `max`: bigint, `median`: bigint, `p25`: bigint, `p5`: bigint, `p75`: bigint, `p95`: bigint>>, `total`: struct<`allProcessesCpu`: struct<`average`: bigint, `max`: bigint, `median`: bigint, `p25`: bigint, `p5`: bigint, `p75`: bigint, `p95`: bigint>, `allProcessesMemory`: struct<`average`: bigint, `max`: bigint, `median`: bigint, `p25`: bigint, `p5`: bigint, `p75`: bigint, `p95`: bigint>, `buildChildProcessesCpu`: struct<`average`: bigint, `max`: bigint, `median`: bigint, `p25`: bigint, `p5`: bigint, `p75`: bigint, `p95`: bigint>, `buildChildProcessesMemory`: struct<`average`: bigint, `max`: bigint, `median`: bigint, `p25`: bigint, `p5`: bigint, `p75`: bigint, `p95`: bigint>, `buildProcessCpu`: struct<`average`: bigint, `max`: bigint, `median`: bigint, `p25`: bigint, `p5`: bigint, `p75`: bigint, `p95`: bigint>, `buildProcessMemory`: struct<`average`: bigint, `max`: bigint, `median`: bigint, `p25`: bigint, `p5`: bigint, `p75`: bigint, `p95`: bigint>, `diskReadThroughput`: struct<`average`: bigint, `max`: bigint, `median`: bigint, `p25`: bigint, `p5`: bigint, `p75`: bigint, `p95`: bigint>, `diskWriteThroughput`: struct<`average`: bigint, `max`: bigint, `median`: bigint, `p25`: bigint, `p5`: bigint, `p75`: bigint, `p95`: bigint>, `networkDownloadThroughput`: struct<`average`: bigint, `max`: bigint, `median`: bigint, `p25`: bigint, `p5`: bigint, `p75`: bigint, `p95`: bigint>, `networkUploadThroughput`: struct<`average`: bigint, `max`: bigint, `median`: bigint, `p25`: bigint, `p5`: bigint, `p75`: bigint, `p95`: bigint>>, `totalMemory`: bigint>
			COMMENT 'Monitors system resource consumption during Gradle build execution. This data enables capacity planning, identifies resource bottlenecks, and helps optimize infrastructure utilization.',
   `mavenResourceUsage` struct<`execution`: struct<`allProcessesCpu`: struct<`average`: bigint, `max`: bigint, `median`: bigint, `p25`: bigint, `p5`: bigint, `p75`: bigint, `p95`: bigint>, `allProcessesMemory`: struct<`average`: bigint, `max`: bigint, `median`: bigint, `p25`: bigint, `p5`: bigint, `p75`: bigint, `p95`: bigint>, `buildChildProcessesCpu`: struct<`average`: bigint, `max`: bigint, `median`: bigint, `p25`: bigint, `p5`: bigint, `p75`: bigint, `p95`: bigint>, `buildChildProcessesMemory`: struct<`average`: bigint, `max`: bigint, `median`: bigint, `p25`: bigint, `p5`: bigint, `p75`: bigint, `p95`: bigint>, `buildProcessCpu`: struct<`average`: bigint, `max`: bigint, `median`: bigint, `p25`: bigint, `p5`: bigint, `p75`: bigint, `p95`: bigint>, `buildProcessMemory`: struct<`average`: bigint, `max`: bigint, `median`: bigint, `p25`: bigint, `p5`: bigint, `p75`: bigint, `p95`: bigint>, `diskReadThroughput`: struct<`average`: bigint, `max`: bigint, `median`: bigint, `p25`: bigint, `p5`: bigint, `p75`: bigint, `p95`: bigint>, `diskWriteThroughput`: struct<`average`: bigint, `max`: bigint, `median`: bigint, `p25`: bigint, `p5`: bigint, `p75`: bigint, `p95`: bigint>, `networkDownloadThroughput`: struct<`average`: bigint, `max`: bigint, `median`: bigint, `p25`: bigint, `p5`: bigint, `p75`: bigint, `p95`: bigint>, `networkUploadThroughput`: struct<`average`: bigint, `max`: bigint, `median`: bigint, `p25`: bigint, `p5`: bigint, `p75`: bigint, `p95`: bigint>>, `nonExecution`: struct<`allProcessesCpu`: struct<`average`: bigint, `max`: bigint, `median`: bigint, `p25`: bigint, `p5`: bigint, `p75`: bigint, `p95`: bigint>, `allProcessesMemory`: struct<`average`: bigint, `max`: bigint, `median`: bigint, `p25`: bigint, `p5`: bigint, `p75`: bigint, `p95`: bigint>, `buildChildProcessesCpu`: struct<`average`: bigint, `max`: bigint, `median`: bigint, `p25`: bigint, `p5`: bigint, `p75`: bigint, `p95`: bigint>, `buildChildProcessesMemory`: struct<`average`: bigint, `max`: bigint, `median`: bigint, `p25`: bigint, `p5`: bigint, `p75`: bigint, `p95`: bigint>, `buildProcessCpu`: struct<`average`: bigint, `max`: bigint, `median`: bigint, `p25`: bigint, `p5`: bigint, `p75`: bigint, `p95`: bigint>, `buildProcessMemory`: struct<`average`: bigint, `max`: bigint, `median`: bigint, `p25`: bigint, `p5`: bigint, `p75`: bigint, `p95`: bigint>, `diskReadThroughput`: struct<`average`: bigint, `max`: bigint, `median`: bigint, `p25`: bigint, `p5`: bigint, `p75`: bigint, `p95`: bigint>, `diskWriteThroughput`: struct<`average`: bigint, `max`: bigint, `median`: bigint, `p25`: bigint, `p5`: bigint, `p75`: bigint, `p95`: bigint>, `networkDownloadThroughput`: struct<`average`: bigint, `max`: bigint, `median`: bigint, `p25`: bigint, `p5`: bigint, `p75`: bigint, `p95`: bigint>, `networkUploadThroughput`: struct<`average`: bigint, `max`: bigint, `median`: bigint, `p25`: bigint, `p5`: bigint, `p75`: bigint, `p95`: bigint>>, `total`: struct<`allProcessesCpu`: struct<`average`: bigint, `max`: bigint, `median`: bigint, `p25`: bigint, `p5`: bigint, `p75`: bigint, `p95`: bigint>, `allProcessesMemory`: struct<`average`: bigint, `max`: bigint, `median`: bigint, `p25`: bigint, `p5`: bigint, `p75`: bigint, `p95`: bigint>, `buildChildProcessesCpu`: struct<`average`: bigint, `max`: bigint, `median`: bigint, `p25`: bigint, `p5`: bigint, `p75`: bigint, `p95`: bigint>, `buildChildProcessesMemory`: struct<`average`: bigint, `max`: bigint, `median`: bigint, `p25`: bigint, `p5`: bigint, `p75`: bigint, `p95`: bigint>, `buildProcessCpu`: struct<`average`: bigint, `max`: bigint, `median`: bigint, `p25`: bigint, `p5`: bigint, `p75`: bigint, `p95`: bigint>, `buildProcessMemory`: struct<`average`: bigint, `max`: bigint, `median`: bigint, `p25`: bigint, `p5`: bigint, `p75`: bigint, `p95`: bigint>, `diskReadThroughput`: struct<`average`: bigint, `max`: bigint, `median`: bigint, `p25`: bigint, `p5`: bigint, `p75`: bigint, `p95`: bigint>, `diskWriteThroughput`: struct<`average`: bigint, `max`: bigint, `median`: bigint, `p25`: bigint, `p5`: bigint, `p75`: bigint, `p95`: bigint>, `networkDownloadThroughput`: struct<`average`: bigint, `max`: bigint, `median`: bigint, `p25`: bigint, `p5`: bigint, `p75`: bigint, `p95`: bigint>, `networkUploadThroughput`: struct<`average`: bigint, `max`: bigint, `median`: bigint, `p25`: bigint, `p5`: bigint, `p75`: bigint, `p95`: bigint>>, `totalMemory`: bigint>
			COMMENT 'Monitors system resource consumption during Maven build execution. This data supports capacity planning and helps identify resource constraints specific to Maven builds.',
   `gradleConfigurationCache` struct<`result`: struct<`checkFingerprintDuration`: bigint, `dependencyResolutionDuration`: bigint, `entrySize`: bigint, `load`: struct<`duration`: bigint, `hasFailed`: boolean>, `missReasons`: array<string>, `outcome`: string, `store`: struct<`duration`: bigint, `hasFailed`: boolean>>>
			COMMENT 'Reports on configuration cache usage and effectiveness. This information helps teams understand the benefits they are getting from this performance feature and identify configuration issues.',
   `bazelCriticalPath` struct<`actions`: array<struct<`category`: string, `duration`: bigint, `name`: string>>>
			COMMENT 'Identifies the sequence of actions that determines the minimum possible build time. This critical information guides optimization efforts by highlighting the actions that have the most impact on overall build duration.',
   `gradleDependencies` struct<`dependencies`: array<struct<`name`: string, `namespace`: string, `purl`: string, `qualifiers`: map<string, string>, `repository`: struct<`resolutionSource`: string, `type`: string, `url`: string>, `scheme`: string, `subpath`: string, `type`: string, `version`: string>>>
			COMMENT 'Documents the resolved dependencies used by Gradle builds. This information supports security audits, license compliance, and dependency management decisions.',
   `mavenDependencies` struct<`dependencies`: array<struct<`name`: string, `namespace`: string, `purl`: string, `qualifiers`: map<string, string>, `repository`: struct<`resolutionSource`: string, `type`: string, `url`: string>, `scheme`: string, `subpath`: string, `type`: string, `version`: string>>>
			COMMENT 'Documents the resolved dependencies used by Maven builds. This information supports security audits, license compliance, and dependency management decisions.',
   `npmDependencies` struct<`dependencies`: array<struct<`name`: string, `namespace`: string, `purl`: string, `qualifiers`: map<string, string>, `repository`: struct<`resolutionSource`: string, `type`: string, `url`: string>, `scheme`: string, `subpath`: string, `type`: string, `version`: string>>>
			COMMENT 'Documents the npm packages used by the build. This information supports security audits, license compliance, and dependency management for JavaScript projects.',
   `drv_chunk_row_number` bigint COMMENT 'Internal use only not to be exposed publicly'
)
PARTITIONED BY ( `build_start_date` date COMMENT 'Partition field storing the start date as a DATE. Use this to speed up queries by including a timeframe.', `build_start_time` string COMMENT 'Partition field storing the start time as a STRING. Prefer using build_start_date over build_start_time', `drv_chunk_id` string COMMENT 'Internal do not use.')
ROW FORMAT SERDE "org.apache.hadoop.hive.ql.io.orc.OrcSerde"
WITH
  serdeproperties ('orc.column.index.access'='false')
    STORED AS
       INPUTFORMAT "org.apache.hadoop.hive.ql.io.orc.OrcInputFormat"
       OUTPUTFORMAT "org.apache.hadoop.hive.ql.io.orc.OrcOutputFormat"
LOCATION '${s3.path}tables/build/'
TBLPROPERTIES ('develocity.reporting.schemaversion'='${currentVersion}', 'develocity.reporting.population.order'='0', 'develocity.reporting.source'='internal_build', 'develocity.reporting.source.needs.partition.management'='true')
