locals {
  bucket_name                     = "grafana-athena-query-results-${var.prefix}${var.bucket_name}"
  truncated_bucket_name           = substr(local.bucket_name, 0, 63)
  truncated_bucket_name_no_hyphen = replace(local.truncated_bucket_name, "-$", "")
}


resource "aws_s3_bucket" "develocity_drv_grafana_athena_results" {
  bucket = local.truncated_bucket_name_no_hyphen

  force_destroy = true

  tags = {
    develocity-drv = "true"
  }
}

resource "aws_athena_workgroup" "develocity_drv_grafana_athena_workgroup" {
  name        = "${var.prefix}develocity-drv-grafana-athena-workgroup"
  description = "Develocity DRV Grafana Athena Workgroup"
  state       = "ENABLED"
  tags = {
    develocity-drv    = "true"
    GrafanaDataSource = "true"
  }
  force_destroy = true
  configuration {
    result_configuration {
      output_location = "s3://${aws_s3_bucket.develocity_drv_grafana_athena_results.bucket}/athena-results/"
    }
  }
}

resource "aws_s3_bucket_lifecycle_configuration" "develocity_drv_grafana_athena_results_lifecycle" {
  bucket = aws_s3_bucket.develocity_drv_grafana_athena_results.id

  rule {
    id     = "${var.prefix}cleanup-athena-results"
    status = "Enabled"

    expiration {
      days = 7
    }

    abort_incomplete_multipart_upload {
      days_after_initiation = 7
    }
  }
}
