CREATE EXTERNAL TABLE build_summary (
`projectname` string COMMENT 'Top-level project/workspace/package name (Gradle root project, Maven top-level project, Bazel workspace/module, npm package, Python project, sbt root project).',
`requested_goals_or_tasks` string COMMENT 'Requested tasks/goals/commands/target patterns joined as a single space-delimited string.',
`username` string COMMENT 'Operating system username of the user that ran the build (if captured).',
`build_duration_millis` bigint COMMENT 'The duration of the build, as milliseconds.',
`has_failed` boolean COMMENT 'True when the build fails, false otherwise.',
`has_non_verification_failure` boolean COMMENT 'True (only if build failed) when at least one failure is classified as Non-verification (configuration/dependency/infrastructure), false otherwise.',
`has_verification_failure` boolean COMMENT 'True (only if build failed) when at least one failure is classified as Verification (expected code/test issues), false otherwise.',
`hostname` string COMMENT 'Public/network hostname or reported host of the build machine (if captured).',
`operatingsystem` string COMMENT 'Operating system of the build machine.',
`build_cache_enabled` boolean COMMENT 'Indicates whether build caching was enabled for the build.',
`local_build_cache_avoidance_millis` bigint COMMENT 'Estimated reduction in serial execution time due to reuse from the local build cache (milliseconds).',
`remote_build_cache_avoidance_millis` bigint COMMENT 'Estimated reduction in serial execution time due to reuse from the remote build cache (milliseconds).',
`local_build_cache_enabled` boolean COMMENT 'Indicates whether the local build cache is enabled.',
`local_build_cache_push_enabled` boolean COMMENT 'Whether pushing to the local build cache was enabled (null if cache disabled).',
`local_build_cache_disabled_due_to_error` boolean COMMENT 'Local build cache disabled during build due to an error (null if cache disabled).',
`remote_build_cache_enabled` boolean COMMENT 'Indicates whether the remote build cache is enabled.',
`remote_build_cache_push_enabled` boolean COMMENT 'Whether pushing to the remote build cache was enabled (null if cache disabled).',
`remote_build_cache_disabled_due_to_error` boolean COMMENT 'Remote build cache disabled during build due to an error (null if cache disabled).',
`parallel_enabled` boolean COMMENT 'Parallel project/thread/task execution enabled.',
`config_cache_enabled` boolean COMMENT 'Gradle configuration cache enabled flag.',
`config_cache_used` boolean COMMENT 'True when configuration cache was used, false otherwise.',
`rerun_tasks_enabled` boolean COMMENT 'Build forced to rerun all tasks/goals ignoring up-to-date/cache checks.',
`refresh_dependencies_enabled` boolean COMMENT 'Dependency refresh / update snapshots flag.',
`background_upload_enabled` boolean COMMENT 'Background Build Scan publication enabled.',
`input_file_capturing_enabled` boolean COMMENT 'Task/goal input file snapshot capturing enabled (deprecated, use mavenAttributes.develocitySettings.fileFingerprintCapturingEnabled/gradleAttributes.develocitySettings.fileFingerprintCapturingEnabled on the build table).',
`module_count` bigint COMMENT 'Number of Gradle projects or Maven modules included in the build.',
`serialization_factor` double COMMENT 'Quantifies the effect of work unit parallelization. 1 means that no parallelization occurred. Greater than 1 means that work units are executed faster due to parallelization.',
`build_id` string COMMENT 'Unique build identifier (buildId).',
`build_tool` string COMMENT 'Build tool type (Gradle, Maven, Bazel, npm, Python, sbt).',
`build_tool_version_full` string COMMENT 'Full build tool version string.',
`build_tool_version_major_minor` string COMMENT 'Derived major.minor build tool version (suffix .x).',
`build_tool_version_major` string COMMENT 'Derived major build tool version (suffix .x).',
`jvm_version_full_vendored` string COMMENT 'Full JVM vendor and version string. Examples: "Eclipse OpenJDK 17.0.8", "Azul OpenJDK 11.0.20", "Oracle Java HotSpot 1.8.0_392".',
`jvm_version_vendor` string COMMENT 'JVM vendor name. Examples: "Eclipse Adoptium", "Oracle", "Azul", "Amazon Corretto".',
`jvm_version_full` string COMMENT 'JVM version number (without vendor). Examples: "17.0.8", "11.0.20", "1.8.0_392".',
`jvm_version_major` string COMMENT 'JVM major version (suffix .x). Examples: "17.x", "11.x", "8.x".',
`jvm_version_major_minor` string COMMENT 'JVM major.minor version (suffix .x). Examples: "17.0.x", "11.0.x", "8.0.x".',
`environment` string COMMENT 'Environment classification derived from tags (CI or Local).',
`tags` array<string> COMMENT 'List of Build Scan tags.',
`custom_values` array<struct<name:string,value:string>> COMMENT 'List of Build Scan custom values (name/value pairs).',
`network_request_count` bigint COMMENT 'Total count of dependency/network requests during resolution.',
`serial_network_request_time_millis` bigint COMMENT 'Sum of individual network request durations (serial aggregate, milliseconds).',
`wall_clock_network_request_time_millis` bigint COMMENT 'Estimated wall clock time spent on network requests (milliseconds).',
`file_download_size` bigint COMMENT 'Total bytes of dependency files downloaded (artifacts/metadata).',
`file_download_count` bigint COMMENT 'Total number of successfully downloaded dependency files.',
`file_download_repositories` map<string,struct<file_download_count:bigint,file_download_size:bigint,network_request_count:bigint,serial_network_request_time_millis:bigint,wall_clock_network_request_time_millis:bigint>> COMMENT 'Per repository/registry dependency download metrics.',
`file_download_methods` map<string,struct<file_download_count:bigint,file_download_size:bigint,network_request_count:bigint,serial_network_request_time_millis:bigint,wall_clock_network_request_time_millis:bigint>> COMMENT 'Per HTTP method dependency download metrics.',
`file_download_repository_methods` map<string,struct<file_download_count:bigint,file_download_size:bigint,network_request_count:bigint,serial_network_request_time_millis:bigint,wall_clock_network_request_time_millis:bigint>> COMMENT 'Per repository + method dependency download metrics.',
`number_of_cores` int COMMENT 'Number of CPU cores available to the build JVM.',
`number_of_workers` int COMMENT 'Maximum configured Gradle workers or Maven threads.',
`resource_usage_total_system_memory` bigint COMMENT 'Total system memory (bytes) captured (if resource usage capturing enabled).',
`resource_usage_total_all_processes_cpu_median` bigint COMMENT 'Median CPU usage across all processes during build.',
`resource_usage_total_build_process_cpu_median` bigint COMMENT 'Median CPU usage of main build process.',
`resource_usage_total_build_child_processes_cpu_median` bigint COMMENT 'Median CPU usage of build child processes.',
`resource_usage_execution_all_processes_cpu_p75` bigint COMMENT '75th percentile CPU usage across all processes (execution phase).',
`resource_usage_total_all_processes_memory_max` bigint COMMENT 'Max memory usage across all processes.',
`resource_usage_total_build_process_memory_p95` bigint COMMENT '95th percentile memory usage of main build process.',
`resource_usage_total_build_child_processes_memory_p95` bigint COMMENT '95th percentile memory usage of build child processes.',
`executing_goals_or_tasks_duration_millis` bigint COMMENT 'Elapsed execution phase time (tasks/goals) in milliseconds.',
`gradle_deprecations` array<struct<advice:string,documentationurl:string,removaldetails:string,summary:string,usages:array<struct<contextualadvice:string,owner:struct<location:string,type:string>>>>> COMMENT 'List of Gradle deprecations with summary, removal details, advice, docs and usage contexts.',
`daemon_enabled` boolean COMMENT 'Build ran with build tool daemon (Gradle or Maven Daemon).',
`gradle_configuration_duration_millis` bigint COMMENT 'Gradle configuration phase elapsed time (milliseconds).',
`gradle_configuration_cache_outcome` string COMMENT 'Outcome of Gradle configuration cache attempt.',
`gradle_configuration_cache_miss_reasons` array<string> COMMENT 'Gradle configuration cache miss reasons.',
`tests_test_classes_count` int COMMENT 'Number of test classes in the build.',
`serial_test_work_units_execution_time` bigint COMMENT 'Sum of serial execution times of test tasks/goals (milliseconds).',
`test_acceleration_pts_usage_status` string COMMENT 'Predictive Test Selection usage status (unavailable/disabled/enabled).',
`test_acceleration_pts_usage_wall_clock_savings_millis` bigint COMMENT 'Wall-clock savings from Predictive Test Selection (can be negative).',
`test_acceleration_pts_usage_serial_time_savings_millis` bigint COMMENT 'Serial time savings from Predictive Test Selection (milliseconds).',
`test_acceleration_pts_simulation_conservative_wall_clock_savings_potential` bigint COMMENT 'Conservative PTS simulation wall-clock savings potential (ms).',
`test_acceleration_pts_simulation_conservative_serial_time_savings_potential` bigint COMMENT 'Conservative PTS simulation serial time savings potential (ms).',
`test_acceleration_pts_simulation_conservative_work_unit_failures_predicted_count` bigint COMMENT 'Conservative simulation predicted failing work units count.',
`test_acceleration_pts_simulation_conservative_work_unit_failures_missed_count` bigint COMMENT 'Conservative simulation missed failing work units count.',
`test_acceleration_pts_simulation_conservative_avoidable_test_classes_count` bigint COMMENT 'Conservative simulation avoidable test classes count.',
`test_acceleration_pts_simulation_conservative_unavoidable_test_classes_count` bigint COMMENT 'Conservative simulation unavoidable test classes count.',
`test_acceleration_pts_simulation_conservative_test_classes_count_selected_due_to_insufficient_data` bigint COMMENT 'Conservative simulation test classes selected due to insufficient data.',
`test_acceleration_pts_simulation_standard_wall_clock_savings_potential` bigint COMMENT 'Standard PTS simulation wall-clock savings potential (ms).',
`test_acceleration_pts_simulation_standard_serial_time_savings_potential` bigint COMMENT 'Standard PTS simulation serial time savings potential (ms).',
`test_acceleration_pts_simulation_standard_work_unit_failures_predicted_count` bigint COMMENT 'Standard simulation predicted failing work units count.',
`test_acceleration_pts_simulation_standard_work_unit_failures_missed_count` bigint COMMENT 'Standard simulation missed failing work units count.',
`test_acceleration_pts_simulation_standard_avoidable_test_classes_count` bigint COMMENT 'Standard simulation avoidable test classes count.',
`test_acceleration_pts_simulation_standard_unavoidable_test_classes_count` bigint COMMENT 'Standard simulation unavoidable test classes count.',
`test_acceleration_pts_simulation_standard_test_classes_count_selected_due_to_insufficient_data` bigint COMMENT 'Standard simulation test classes selected due to insufficient data.',
`test_acceleration_pts_simulation_fast_wall_clock_savings_potential` bigint COMMENT 'Fast PTS simulation wall-clock savings potential (ms).',
`test_acceleration_pts_simulation_fast_serial_time_savings_potential` bigint COMMENT 'Fast PTS simulation serial time savings potential (ms).',
`test_acceleration_pts_simulation_fast_work_unit_failures_predicted_count` bigint COMMENT 'Fast simulation predicted failing work units count.',
`test_acceleration_pts_simulation_fast_work_unit_failures_missed_count` bigint COMMENT 'Fast simulation missed failing work units count.',
`test_acceleration_pts_simulation_fast_avoidable_test_classes_count` bigint COMMENT 'Fast simulation avoidable test classes count.',
`test_acceleration_pts_simulation_fast_unavoidable_test_classes_count` bigint COMMENT 'Fast simulation unavoidable test classes count.',
`test_acceleration_pts_simulation_fast_test_classes_count_selected_due_to_insufficient_data` bigint COMMENT 'Fast simulation test classes selected due to insufficient data.',
`test_acceleration_td_usage_status` string COMMENT 'Test Distribution usage status (unavailable/disabled/enabled).',
`test_acceleration_td_wall_clock_savings_millis` bigint COMMENT 'Wall-clock savings from Test Distribution (can be negative).',
`test_acceleration_wall_clock_savings_combined_millis` bigint COMMENT 'Combined wall-clock savings from test acceleration features (can be negative).',
`release_year` int COMMENT 'Model version release year (from Develocity modelVersion).',
`release_number` int COMMENT 'Model version release number (from Develocity modelVersion).',
`maven_fail_never_enabled` boolean COMMENT 'Maven fail-never flag enabled.',
`maven_resume_enabled` boolean COMMENT 'Maven resume-from-last-failed flag enabled.',
`build_start_timestamp` bigint COMMENT 'Build start time in milliseconds since epoch (prefer partition build_start_date for filtering).',
`drv_chunk_row_number` bigint COMMENT 'Internal only, do not use')
PARTITIONED BY ( `build_start_date` date  COMMENT 'Partition field storing the start date as a DATE. Use this to speed up queries by including a timeframe.', `build_start_time` string, `drv_chunk_id` string)
ROW FORMAT SERDE 'org.apache.hadoop.hive.ql.io.orc.OrcSerde'
WITH
  serdeproperties ('orc.column.index.access'='false')
    STORED AS
       INPUTFORMAT 'org.apache.hadoop.hive.ql.io.orc.OrcInputFormat'
       OUTPUTFORMAT 'org.apache.hadoop.hive.ql.io.orc.OrcOutputFormat'
LOCATION '${s3.path}tables/build_summary/'
TBLPROPERTIES ('develocity.reporting.schemaversion'='${currentVersion}', 'develocity.reporting.partition.date.key'='build_start_date', 'develocity.reporting.population.order'='1', 'develocity.reporting.source'='internal_build_summary')
