CREATE OR REPLACE VIEW plugin_summary AS
SELECT build.id                                                                          build_id,
       COALESCE(plugins.id, plugins.classname)                                           plugin_id,
       (CASE WHEN(plugins.id IS NULL) THEN NULL
                    ELSE (CONCAT(plugins.id, ':', plugins.id, '.gradle.plugin')) END)    group_artifact,
       plugins.version                                                                   version,
       plugins.projects                                                                  modules,
       gradleattributes.rootprojectname                                                  projectname,
       type                                                                              build_tool,
       gradleattributes.buildduration                                                    build_duration_millis,
       gradleattributes.tags                                                             tags,
       (CASE
            WHEN (CONTAINS(build.gradleattributes.tags, 'CI') = true) THEN 'CI'
            WHEN (CONTAINS(build.gradleattributes.tags, 'CI') = false) THEN 'Local' END) environment,
       startdate                                                                         build_start_date,
       gradleattributes.buildstarttime                                                   build_start_timestamp
FROM build,
     unnest(gradleplugins.plugins) t (plugins)
WHERE (gradleattributes.rootprojectname IS NOT NULL)
UNION ALL
SELECT build.id                                                                         build_id,
       plugins.name                                                                     plugin_id,
       CONCAT(plugins.groupId, ':', plugins.artifactid)                                 group_artifact,
       plugins.version                                                                  version,
       plugins.modules                                                                  modules,
       mavenattributes.toplevelprojectname                                              projectname,
       type                                                                             build_tool,
       mavenattributes.buildduration                                                    build_duration_millis,
       mavenattributes.tags                                                             tags,
       (CASE
            WHEN (CONTAINS(build.mavenattributes.tags, 'CI') = true) THEN 'CI'
            WHEN (CONTAINS(build.mavenattributes.tags, 'CI') = false) THEN 'Local' END) environment,
       startdate                                                                        build_start_date,
       mavenattributes.buildstarttime                                                   build_start_timestamp
FROM build,
     unnest(mavenplugins.plugins) t (plugins)
WHERE (mavenattributes.toplevelprojectname IS NOT NULL)
