#!/bin/bash

# Set default values for optional parameters
data_catalog_name="AwsDataCatalog"
db_name=""
apply=false
destroy=false
grafana_url=$(terraform -chdir="stages/provision-aws-grafana" output grafana_url)
grafana_token=$(terraform -chdir="stages/provision-aws-grafana" output grafana_token)
workgroup=$(terraform -chdir="stages/provision-aws-grafana" output workgroup_name)
aws_region=$(terraform -chdir="stages/provision-aws-grafana" output aws_region)

# Parse the command line arguments
while [[ $# -gt 0 ]]; do
  case $1 in
    --destroy)
      destroy=true
      shift # past argument
      ;;
    --apply)
      apply=true
      shift # past argument
      ;;
    --data-catalog-name)
      data_catalog_name=$2
      shift # past argument
      shift # past value
      ;;
    --db-name)
      db_name=$2
      shift # past argument
      shift # past value
      ;;
    --grafana-url)
      grafana_url=$2
      shift # past argument
      shift # past value
      ;;
    --grafana-token)
      grafana_token=$2
      shift # past argument
      shift # past value
      ;;
    --workgroup)
      workgroup=$2
      shift # past argument
      shift # past value
      ;;
    --aws-region)
      aws_region=$2
      shift # past argument
      shift # past value
      ;;
    *)
      echo "Unknown argument: $1"
      exit 1
      ;;
  esac
done

# Check for required parameters
if [[ -z "$db_name" ]]; then
  echo "Error: --db-name is required"
  exit 1
fi

if [[ -z "$data_catalog_name" ]]; then
  echo "Error: --data-catalog-name is required"
  exit 1
fi


if [[ -z "$grafana_token" ]]; then
  echo "Error: --grafana-token is required, this is normally provided by the terraform output of the preceding stage"
  exit 1
fi

if [[ -z "$workgroup" ]]; then
  echo "Error: --workgroup is required, this is normally provided by the terraform output of the preceding stage"
  exit 1
fi

if [[ -z "$aws_region" ]]; then
  echo "Error: --aws-region is required, this is normally provided by the terraform output of the preceding stage"
  exit 1
fi

terraform -chdir="stages/provision-aws-grafana-datasource" init

if [[ $destroy == true ]]; then
  echo "This stage does not support destroy, please destroy the previous stage, that will subsequently destroy this stage"
fi


if [[ $apply == true ]]; then
  # Call terraform with the variables
  terraform -chdir="stages/provision-aws-grafana-datasource" apply \
    -var "db_name=$db_name" \
    -var "data_catalog_name=$data_catalog_name" \
    -var "grafana_url=$grafana_url" \
    -var "grafana_token=$grafana_token" \
    -var "workgroup=$workgroup" \
    -var "aws_region=$aws_region"
else
  echo "Running terraform plan..."
  echo "If you want to apply the changes, run this script with the --apply flag"

  # Call terraform with the variables
  terraform -chdir="stages/provision-aws-grafana-datasource" plan \
    -var "db_name=$db_name" \
    -var "data_catalog_name=$data_catalog_name" \
    -var "grafana_url=$grafana_url" \
    -var "grafana_token=$grafana_token" \
    -var "workgroup=$workgroup" \
    -var "aws_region=$aws_region"
fi
