resource "null_resource" "grafana_plugin_install" {

  provisioner "local-exec" {
    when    = create
    command = <<EOT
      status_code=$(curl -s -o /dev/null -w "%%{http_code}" -X POST ${"https://${trim(var.grafana_url, "\"")}/api/plugins/grafana-athena-datasource/install"} -H 'content-type: application/json' -H "Authorization: Bearer ${trim(var.grafana_token, "\"")}" ) && [ $status_code -eq 200 ] || { echo "API call failed with status code $status_code"; exit 1; }
    EOT

    interpreter = ["bash", "-c"]
  }

  count = 1 - length([for d in jsondecode(data.http.check_plugins.response_body) : d.id if d.id == "grafana-athena-datasource"])

  triggers = {
    instancenumbers = length([for d in jsondecode(data.http.check_plugins.response_body) : d.id if d.id == "grafana-athena-datasource"]) == 0 ? uuid() : "1"
  }

  provisioner "local-exec" {
    when    = destroy
    command = "echo \"The plugins are not uninstalled automatically, please follow the documentation if you want to uninstall the plugin\""
  }
}


data "http" "check_plugins" {
  url = "https://${trim(var.grafana_url, "\"")}/api/plugins"
  request_headers = {
    "Authorization" = "Bearer ${trim(var.grafana_token, "\"")}"
  }

  lifecycle {
    postcondition {
      condition     = self.status_code != 401
      error_message = "Grafana returned 401 - Unauthorized, the most likely cause is that the token is expired, please apply the previous stage again, to generate a new token"
    }
    postcondition {
      condition     = self.status_code == 200
      error_message = "Status code invalid"
    }
  }
}
