locals {
  datasource_payload = {
    "name" : "develocity_drv_athena_datasource",
    "type" : "grafana-athena-datasource",
    "access" : "proxy",
    "isDefault" : false,
    "jsonData" : {
      "authType" : "ec2_iam_role", "catalog" : trim(var.data_catalog_name, "\""), "database" : trim(var.db_name, "\""), "defaultRegion" : trim(var.aws_region, "\""), "workgroup" : trim(var.workgroup, "\""),
    }
  }
}

resource "null_resource" "grafana_datasource_create" {

  provisioner "local-exec" {
    when    = create
    command = <<EOT
      status_code=$(curl -s -o /dev/null -w "%%{http_code}" -X POST ${"https://${trim(var.grafana_url, "\"")}/api/datasources"} -d '${jsonencode(local.datasource_payload)}' -H 'content-type: application/json' -H "Authorization: Bearer ${trim(var.grafana_token, "\"")}" ) && [ $status_code -eq 200 ] || { echo "API call failed with status code $status_code"; exit 1; }
    EOT

    interpreter = ["bash", "-c"]
  }

  count = 1 - length([for d in jsondecode(data.http.check_datasource.response_body) : d.uid if d.name == "develocity_drv_athena_datasource"])

  triggers = {
    instancenumbers = length([for d in jsondecode(data.http.check_datasource.response_body) : d.uid if d.name == "develocity_drv_athena_datasource"]) == 0 ? uuid() : "1"
  }

  provisioner "local-exec" {
    when    = destroy
    command = "echo \"The datasources are not removed automatically, please follow the documentation if you want to uninstall the plugin\""
  }
}

data "http" "data_source_id" {
  url = "https://${trim(var.grafana_url, "\"")}/api/datasources/name/${local.datasource_payload["name"]}"
  request_headers = {
    "Authorization" = "Bearer ${trim(var.grafana_token, "\"")}"
  }

  lifecycle {
    postcondition {
      condition     = self.status_code != 401
      error_message = "Grafana returned 401 - Unauthorized, the most likely cause is that the token is expired, please apply the previous stage again, to generate a new token"
    }
    postcondition {
      condition     = self.status_code == 200
      error_message = "Status code invalid"
    }
  }
  depends_on = [null_resource.grafana_datasource_create]

}

data "http" "check_datasource" {
  url = "https://${trim(var.grafana_url, "\"")}/api/datasources"
  request_headers = {
    "Authorization" = "Bearer ${trim(var.grafana_token, "\"")}"
  }

  lifecycle {
    postcondition {
      condition     = self.status_code != 401
      error_message = "Grafana returned 401 - Unauthorized, the most likely cause is that the token is expired, please apply the previous stage again, to generate a new token"
    }
    postcondition {
      condition     = self.status_code == 200
      error_message = "Status code invalid"
    }
  }
}
