CREATE OR REPLACE VIEW internal_build_summary AS
WITH view_base AS(
    SELECT COALESCE(mavenattributes.toplevelprojectname, gradleattributes.rootprojectname, bazelattributes.modulename, npmattributes.packagename,
                    pythonattributes.projectname, sbtattributes.rootprojectname)                                                                          projectname
         , array_join(COALESCE(mavenattributes.requestedgoals, gradleattributes.requestedtasks, if(bazelattributes.command IS NULL, NULL,
                                                                                                   ARRAY[CONCAT(bazelattributes.command, ' ', array_join(bazelattributes.targetpatterns, ' '))]),
                               IF(npmattributes.command.command IS NULL, NULL,
                                  ARRAY[CONCAT(npmattributes.command.command, ' ', array_join(npmattributes.command.arguments, ' '))]),
                               sbtattributes.requestedcommands, pythonattributes.command), ' ')                                                           requested_goals_or_tasks
         , COALESCE(mavenattributes.environment.username, gradleattributes.environment.username, bazelattributes.user, npmattributes.user, pythonattributes.user,
                    sbtattributes.environment.username)                                                                                                   username
         , COALESCE(mavenattributes.buildduration, gradleattributes.buildduration, bazelattributes.buildduration, npmattributes.buildduration,
                    pythonattributes.buildduration, sbtattributes.buildduration)                                                                          build_duration_millis
         , COALESCE(mavenattributes.tags, gradleattributes.tags, bazelattributes.tags, npmattributes.tags, pythonattributes.tags, sbtattributes.tags)     tags
         , COALESCE(mavenattributes.hasfailed, gradleattributes.hasfailed, bazelattributes.hasfailed, npmattributes.hasfailed, pythonattributes.hasfailed,
                    sbtattributes.hasfailed)                                                                                                              has_failed
         , COALESCE(mavenattributes.hasnonverificationfailure, gradleattributes.hasnonverificationfailure,
                    sbtattributes.hasnonverificationfailure)                                                                                              has_non_verification_failure
         , COALESCE(mavenattributes.hasverificationfailure, gradleattributes.hasverificationfailure, sbtattributes.hasverificationfailure)                has_verification_failure
         , COALESCE("mavenattributes"."environment".publichostname, "gradleattributes"."environment".publichostname, bazelattributes.host, npmattributes.host,
                    pythonattributes.host, "sbtattributes"."environment".publichostname)                                                                  hostname
         , COALESCE("mavenattributes"."environment".operatingsystem, "gradleattributes"."environment".operatingsystem,
                    "sbtattributes"."environment".operatingsystem)                                                                                        operatingsystem
         , COALESCE(gradlebuildcacheperformance.avoidancesavingssummary.localbuildcache,
                    mavenbuildcacheperformance.avoidancesavingssummary.localbuildcache)                                                                   local_build_cache_avoidance_millis
         , COALESCE(gradlebuildcacheperformance.avoidancesavingssummary.remotebuildcache,
                    mavenbuildcacheperformance.avoidancesavingssummary.remotebuildcache)                                                                  remote_build_cache_avoidance_millis
         , COALESCE("gradlebuildcacheperformance"."buildcaches"."local"."isenabled",
                    "mavenbuildcacheperformance"."buildcaches"."local"."isenabled")                                                                       local_build_cache_enabled
         , COALESCE("gradlebuildcacheperformance"."buildcaches"."local"."ispushenabled",
                    "mavenbuildcacheperformance"."buildcaches"."local"."ispushenabled")                                                                   local_build_cache_push_enabled
         , COALESCE("gradlebuildcacheperformance"."buildcaches"."local"."isdisabledduetoerror",
                    "mavenbuildcacheperformance"."buildcaches"."local"."isdisabledduetoerror")                                                            local_build_cache_disabled_due_to_error
         , COALESCE("gradlebuildcacheperformance"."buildcaches"."remote"."isenabled",
                    "mavenbuildcacheperformance"."buildcaches"."remote"."isenabled")                                                                      remote_build_cache_enabled
         , COALESCE("gradlebuildcacheperformance"."buildcaches"."remote"."ispushenabled",
                    "mavenbuildcacheperformance"."buildcaches"."remote"."ispushenabled")                                                                  remote_build_cache_push_enabled
         , COALESCE("gradlebuildcacheperformance"."buildcaches"."remote"."isdisabledduetoerror",
                    "mavenbuildcacheperformance"."buildcaches"."remote"."isdisabledduetoerror")                                                           remote_build_cache_disabled_due_to_error
         , REGEXP_REPLACE(COALESCE(mavenattributes.environment.jvmversion, gradleattributes.environment.jvmversion, sbtattributes.environment.jvmversion),
                          '^([0-9a-zA-Z_\-.]+).*(OpenJDK|Java HotSpot).*VM.*?([\d\.?]+).*', '$1 $2 $3')                                                   jvm_version
         , COALESCE(gradleattributes.buildoptions.parallelprojectexecutionenabled, (mavenattributes.buildoptions.maxnumberofthreads > 1),
                    sbtattributes.buildoptions.parallelExecutionEnabled)                                                                                  parallel_enabled
         , COALESCE(gradleattributes.buildoptions.buildcacheenabled,
                    (mavenbuildcacheperformance.buildcaches.local.isenabled OR mavenbuildcacheperformance.buildcaches.remote.isenabled))                  build_cache_enabled
         , COALESCE(gradleattributes.buildoptions.configurationcacheenabled, false)                                                                       config_cache_enabled
         , COALESCE(gradleconfigurationcache.result is not null, false)                                                                                   config_cache_used
         , COALESCE(gradleattributes.buildoptions.reruntasksenabled, mavenattributes.buildoptions.rerungoals)                                             rerun_tasks_enabled
         , COALESCE(gradleattributes.buildoptions.refreshdependenciesenabled, mavenattributes.buildoptions.updatesnapshotsenabled)                        refresh_dependencies_enabled
         , COALESCE(gradleattributes.develocitysettings.backgroundpublicationenabled, mavenattributes.develocitysettings.backgroundpublicationenabled,
                    sbtattributes.develocitysettings.backgroundpublicationenabled)                                                                        background_upload_enabled
         , COALESCE(gradleattributes.develocitysettings.taskinputsfilecapturingenabled,
                    mavenattributes.develocitysettings.goalinputsfilecapturingenabled)                                                                    input_file_capturing_enabled
         , COALESCE(cardinality(gradleprojects), cardinality(mavenmodules))                                                                               module_count
         , GREATEST(COALESCE(COALESCE(mavenbuildcacheperformance.serializationfactor, gradlebuildcacheperformance.serializationfactor), 1), 1)            serialization_factor
         , id                                                                                                                                             build_id
         , type                                                                                                                                           build_tool
         , buildtoolversion                                                                                                                               build_tool_version_full
         , COALESCE("mavenattributes"."environment".numberOfCpuCores, "gradleattributes"."environment".numberOfCpuCores,
                    "sbtattributes"."environment".numberOfCpuCores)                                                                                       number_of_cores
         , COALESCE(gradleattributes.buildoptions.maxNumberOfGradleWorkers, mavenattributes.buildoptions.maxNumberOfThreads)                              number_of_workers
         , COALESCE(gradleattributes."values", mavenattributes."values", bazelattributes."values", npmattributes."values", pythonattributes."values",
                    sbtattributes."values")                                                                                                               custom_values
         , COALESCE(gradlenetworkactivity.networkrequestcount, mavendependencyresolution.networkrequestcount)                                             network_request_count
         , COALESCE(gradleNetworkActivity.serialnetworkrequesttime, mavendependencyresolution.serialnetworkrequesttime)                                   serial_network_request_time_millis
         , COALESCE(gradleNetworkActivity.wallclocknetworkrequesttime, mavendependencyresolution.wallclocknetworkrequesttime)                             wall_clock_network_request_time_millis
         , COALESCE(gradleNetworkActivity.filedownloadsize, mavendependencyresolution.filedownloadsize)                                                   file_download_size
         , COALESCE(gradleNetworkActivity.filedownloadcount, mavendependencyresolution.filedownloadcount)                                                 file_download_count
         , COALESCE(mavenresourceusage.totalmemory, gradleresourceusage.totalmemory)                                                                      resource_usage_total_system_memory
         , COALESCE(mavenresourceusage.total.allprocessescpu.median, gradleresourceusage.total.allprocessescpu.median)                                    resource_usage_total_all_processes_cpu_median
         , COALESCE(mavenresourceusage.total.buildprocesscpu.median, gradleresourceusage.total.buildprocesscpu.median)                                    resource_usage_total_build_process_cpu_median
         , COALESCE(mavenresourceusage.total.buildchildprocessescpu.median,
                    gradleresourceusage.total.buildchildprocessescpu.median)                                                                              resource_usage_total_build_child_processes_cpu_median
         , COALESCE(mavenresourceusage.total.allprocessesmemory.max, gradleresourceusage.total.allprocessesmemory.max)                                    resource_usage_total_all_processes_memory_max
         , COALESCE(mavenresourceusage.total.buildprocessmemory.p95, gradleresourceusage.total.buildprocessmemory.p95)                                    resource_usage_total_build_process_memory_p95
         , COALESCE(mavenresourceusage.total.buildchildprocessesmemory.p95,
                    gradleresourceusage.total.buildchildprocessesmemory.p95)                                                                              resource_usage_total_build_child_processes_memory_p95
         , COALESCE(mavenresourceusage.execution.allprocessescpu.p75,
                    gradleresourceusage.execution.allprocessescpu.p75)                                                                                    resource_usage_execution_all_processes_cpu_p75
         , COALESCE(mavenBuildProfileOverview.breakdown.execution.goalExecution,
                    gradleBuildProfileOverview.breakdown.execution)                                                                                       executing_goals_or_tasks_duration_millis
         , gradledeprecations.deprecations                                                                                                                gradle_deprecations
         , COALESCE(gradleattributes.buildoptions.daemonenabled, mavenattributes.buildoptions.daemonenabled)                                              daemon_enabled
         , COALESCE(gradleBuildProfileOverview.breakdown.configuration, 0)                                                                                gradle_configuration_duration_millis
         , COALESCE(gradleconfigurationcache.result.outcome, '')                                                                                          gradle_configuration_cache_outcome
         , gradleconfigurationcache.result.missReasons                                                                                                    gradle_configuration_cache_miss_reasons
         , COALESCE(maventestperformance.tests.testClassesCount, gradletestperformance.tests.testClassesCount)                                            tests_test_classes_count
         , COALESCE(maventestperformance.serialTestGoalsExecutionTime, gradletestperformance.serialTestTasksExecutionTime)                                serial_test_work_units_execution_time
         , COALESCE(maventestperformance.testAcceleration.predictiveTestSelection.usage.status,
                    gradletestperformance.testAcceleration.predictiveTestSelection.usage.status)                                                          test_acceleration_pts_usage_status
         , COALESCE(maventestperformance.testAcceleration.predictiveTestSelection.usage.wallClockSavings,
                    gradletestperformance.testAcceleration.predictiveTestSelection.usage.wallClockSavings)                                                test_acceleration_pts_usage_wall_clock_savings_millis
         , COALESCE(maventestperformance.testAcceleration.predictiveTestSelection.usage.serialTimeSavings,
                    gradletestperformance.testAcceleration.predictiveTestSelection.usage.serialTimeSavings)                                               test_acceleration_pts_usage_serial_time_savings_millis
         , COALESCE(maventestperformance.testAcceleration.predictiveTestSelection.simulation.conservative.wallClockSavingsPotential,
                    gradletestperformance.testAcceleration.predictiveTestSelection.simulation.conservative.wallClockSavingsPotential)                     test_acceleration_pts_simulation_conservative_wall_clock_savings_potential
         , COALESCE(maventestperformance.testAcceleration.predictiveTestSelection.simulation.conservative.serialTimeSavingsPotential,
                    gradletestperformance.testAcceleration.predictiveTestSelection.simulation.conservative.serialTimeSavingsPotential)                    test_acceleration_pts_simulation_conservative_serial_time_savings_potential
         , COALESCE(maventestperformance.testAcceleration.predictiveTestSelection.simulation.conservative.workUnitFailuresPredictedCount,
                    gradletestperformance.testAcceleration.predictiveTestSelection.simulation.conservative.workUnitFailuresPredictedCount)                test_acceleration_pts_simulation_conservative_work_unit_failures_predicted_count
         , COALESCE(maventestperformance.testAcceleration.predictiveTestSelection.simulation.conservative.workUnitFailuresMissedCount,
                    gradletestperformance.testAcceleration.predictiveTestSelection.simulation.conservative.workUnitFailuresMissedCount)                   test_acceleration_pts_simulation_conservative_work_unit_failures_missed_count
         , COALESCE(maventestperformance.testAcceleration.predictiveTestSelection.simulation.conservative.avoidableTestClassesCount,
                    gradletestperformance.testAcceleration.predictiveTestSelection.simulation.conservative.avoidableTestClassesCount)                     test_acceleration_pts_simulation_conservative_avoidable_test_classes_count
         , COALESCE(maventestperformance.testAcceleration.predictiveTestSelection.simulation.conservative.unavoidableTestClassesCount,
                    gradletestperformance.testAcceleration.predictiveTestSelection.simulation.conservative.unavoidableTestClassesCount)                   test_acceleration_pts_simulation_conservative_unavoidable_test_classes_count
         , COALESCE(maventestperformance.testAcceleration.predictiveTestSelection.simulation.conservative.testClassesCountSelectedDueToInsufficientData,
                    gradletestperformance.testAcceleration.predictiveTestSelection.simulation.conservative.testClassesCountSelectedDueToInsufficientData) test_acceleration_pts_simulation_conservative_test_classes_count_selected_due_to_insufficient_data
         , COALESCE(maventestperformance.testAcceleration.predictiveTestSelection.simulation.standard.wallClockSavingsPotential,
                    gradletestperformance.testAcceleration.predictiveTestSelection.simulation.standard.wallClockSavingsPotential)                         test_acceleration_pts_simulation_standard_wall_clock_savings_potential
         , COALESCE(maventestperformance.testAcceleration.predictiveTestSelection.simulation.standard.serialTimeSavingsPotential,
                    gradletestperformance.testAcceleration.predictiveTestSelection.simulation.standard.serialTimeSavingsPotential)                        test_acceleration_pts_simulation_standard_serial_time_savings_potential
         , COALESCE(maventestperformance.testAcceleration.predictiveTestSelection.simulation.standard.workUnitFailuresPredictedCount,
                    gradletestperformance.testAcceleration.predictiveTestSelection.simulation.standard.workUnitFailuresPredictedCount)                    test_acceleration_pts_simulation_standard_work_unit_failures_predicted_count
         , COALESCE(maventestperformance.testAcceleration.predictiveTestSelection.simulation.standard.workUnitFailuresMissedCount,
                    gradletestperformance.testAcceleration.predictiveTestSelection.simulation.standard.workUnitFailuresMissedCount)                       test_acceleration_pts_simulation_standard_work_unit_failures_missed_count
         , COALESCE(maventestperformance.testAcceleration.predictiveTestSelection.simulation.standard.avoidableTestClassesCount,
                    gradletestperformance.testAcceleration.predictiveTestSelection.simulation.standard.avoidableTestClassesCount)                         test_acceleration_pts_simulation_standard_avoidable_test_classes_count
         , COALESCE(maventestperformance.testAcceleration.predictiveTestSelection.simulation.standard.unavoidableTestClassesCount,
                    gradletestperformance.testAcceleration.predictiveTestSelection.simulation.standard.unavoidableTestClassesCount)                       test_acceleration_pts_simulation_standard_unavoidable_test_classes_count
         , COALESCE(maventestperformance.testAcceleration.predictiveTestSelection.simulation.standard.testClassesCountSelectedDueToInsufficientData,
                    gradletestperformance.testAcceleration.predictiveTestSelection.simulation.standard.testClassesCountSelectedDueToInsufficientData)     test_acceleration_pts_simulation_standard_test_classes_count_selected_due_to_insufficient_data
         , COALESCE(maventestperformance.testAcceleration.predictiveTestSelection.simulation.fast.wallClockSavingsPotential,
                    gradletestperformance.testAcceleration.predictiveTestSelection.simulation.fast.wallClockSavingsPotential)                             test_acceleration_pts_simulation_fast_wall_clock_savings_potential
         , COALESCE(maventestperformance.testAcceleration.predictiveTestSelection.simulation.fast.serialTimeSavingsPotential,
                    gradletestperformance.testAcceleration.predictiveTestSelection.simulation.fast.serialTimeSavingsPotential)                            test_acceleration_pts_simulation_fast_serial_time_savings_potential
         , COALESCE(maventestperformance.testAcceleration.predictiveTestSelection.simulation.fast.workUnitFailuresPredictedCount,
                    gradletestperformance.testAcceleration.predictiveTestSelection.simulation.fast.workUnitFailuresPredictedCount)                        test_acceleration_pts_simulation_fast_work_unit_failures_predicted_count
         , COALESCE(maventestperformance.testAcceleration.predictiveTestSelection.simulation.fast.workUnitFailuresMissedCount,
                    gradletestperformance.testAcceleration.predictiveTestSelection.simulation.fast.workUnitFailuresMissedCount)                           test_acceleration_pts_simulation_fast_work_unit_failures_missed_count
         , COALESCE(maventestperformance.testAcceleration.predictiveTestSelection.simulation.fast.avoidableTestClassesCount,
                    gradletestperformance.testAcceleration.predictiveTestSelection.simulation.fast.avoidableTestClassesCount)                             test_acceleration_pts_simulation_fast_avoidable_test_classes_count
         , COALESCE(maventestperformance.testAcceleration.predictiveTestSelection.simulation.fast.unavoidableTestClassesCount,
                    gradletestperformance.testAcceleration.predictiveTestSelection.simulation.fast.unavoidableTestClassesCount)                           test_acceleration_pts_simulation_fast_unavoidable_test_classes_count
         , COALESCE(maventestperformance.testAcceleration.predictiveTestSelection.simulation.fast.testClassesCountSelectedDueToInsufficientData,
                    gradletestperformance.testAcceleration.predictiveTestSelection.simulation.fast.testClassesCountSelectedDueToInsufficientData)         test_acceleration_pts_simulation_fast_test_classes_count_selected_due_to_insufficient_data
         , COALESCE(maventestperformance.testAcceleration.testDistribution.usageStatus,
                    gradletestperformance.testAcceleration.testDistribution.usageStatus)                                                                  test_acceleration_td_usage_status
         , COALESCE(maventestperformance.testAcceleration.testDistribution.wallClockSavings,
                    gradletestperformance.testAcceleration.testDistribution.wallClockSavings)                                                             test_acceleration_td_wall_clock_savings_millis
         , COALESCE(maventestperformance.testAcceleration.wallClockSavings,
                    gradletestperformance.testAcceleration.wallClockSavings)                                                                              test_acceleration_wall_clock_savings_combined_millis
         , modelversion.year                                                                                                                              release_year
         , modelversion.release                                                                                                                           release_number
         , mavenattributes.buildoptions.failNeverEnabled                                                                                                  maven_fail_never_enabled
         , mavenattributes.buildoptions.resumeEnabled                                                                                                     maven_resume_enabled
         , COALESCE(gradleattributes.buildstarttime, mavenattributes.buildstarttime, bazelattributes.buildstarttime,
                    npmattributes.buildstarttime, pythonattributes.buildstarttime, sbtattributes.buildstarttime)                                          build_start_timestamp
         , build_start_date
         , build_start_time
         , drv_chunk_id
    FROM build
)
SELECT projectname,
       requested_goals_or_tasks,
       username,
       build_duration_millis,
       has_failed,
       has_non_verification_failure,
       has_verification_failure,
       hostname,
       operatingsystem,
       build_cache_enabled,
       local_build_cache_avoidance_millis,
       remote_build_cache_avoidance_millis,
       local_build_cache_enabled,
       local_build_cache_push_enabled,
       local_build_cache_disabled_due_to_error,
       remote_build_cache_enabled,
       remote_build_cache_push_enabled,
       remote_build_cache_disabled_due_to_error,
       parallel_enabled,
       config_cache_enabled,
       config_cache_used,
       rerun_tasks_enabled,
       refresh_dependencies_enabled,
       background_upload_enabled,
       input_file_capturing_enabled,
       module_count,
       serialization_factor,
       build_id,
       build_tool,
       build_tool_version_full,
       REGEXP_REPLACE(build_tool_version_full, '^(\d+\.\d+).*', '$1.x')                                         build_tool_version_major_minor,
       REGEXP_REPLACE(build_tool_version_full, '^(\d+).*', '$1.x')                                              build_tool_version_major,
       jvm_version                                                                                              jvm_version_full_vendored,
       REGEXP_REPLACE(jvm_version, '^([A-Za-z\s]+)\s[\d\.]+.*$', '$1')                                          jvm_version_vendor,
       REGEXP_REPLACE(jvm_version, '^[A-Za-z\s]+\s([\d\.]+).*$', '$1')                                          jvm_version_full,
       REGEXP_REPLACE(jvm_version, '^[A-Za-z\s]+\s([\d]+)\.?[\d\.]?.*$', '$1.x')                                jvm_version_major,
       (CASE
            WHEN REGEXP_LIKE(REGEXP_REPLACE(jvm_version, '^[A-Za-z\s]+\s(\d+\.?\d+)\.?\d*.*', '$1.x'), '\d+\.\d+')
                THEN REGEXP_REPLACE(jvm_version, '^[A-Za-z\s]+\s(\d+\.?\d+)\.?\d*.*', '$1.x')
            ELSE CONCAT(REGEXP_REPLACE(jvm_version, '^[A-Za-z\s]+\s(\d+\.?\d+)\.?\d*.*', '$1'), '.0.x') END)    jvm_version_major_minor,
       (CASE
            WHEN (contains(tags, 'CI') = true) THEN 'CI'
            WHEN (COALESCE(CONTAINS(tags, 'CI'), false) = false) THEN 'Local' END) environment,
       tags,
       custom_values,
       network_request_count,
       serial_network_request_time_millis,
       wall_clock_network_request_time_millis,
       file_download_size,
       file_download_count,
       number_of_cores,
       number_of_workers,
       resource_usage_total_all_processes_cpu_median,
       resource_usage_total_build_process_cpu_median,
       resource_usage_total_build_child_processes_cpu_median,
       resource_usage_execution_all_processes_cpu_p75,
       resource_usage_total_system_memory,
       resource_usage_total_all_processes_memory_max,
       resource_usage_total_build_process_memory_p95,
       resource_usage_total_build_child_processes_memory_p95,
       executing_goals_or_tasks_duration_millis,
       gradle_deprecations,
       daemon_enabled,
       gradle_configuration_duration_millis,
       gradle_configuration_cache_outcome,
       gradle_configuration_cache_miss_reasons,
       tests_test_classes_count,
       serial_test_work_units_execution_time,
       test_acceleration_pts_usage_status,
       test_acceleration_pts_usage_wall_clock_savings_millis,
       test_acceleration_pts_usage_serial_time_savings_millis,
       test_acceleration_pts_simulation_conservative_wall_clock_savings_potential,
       test_acceleration_pts_simulation_conservative_serial_time_savings_potential,
       test_acceleration_pts_simulation_conservative_work_unit_failures_predicted_count,
       test_acceleration_pts_simulation_conservative_work_unit_failures_missed_count,
       test_acceleration_pts_simulation_conservative_avoidable_test_classes_count,
       test_acceleration_pts_simulation_conservative_unavoidable_test_classes_count,
       test_acceleration_pts_simulation_conservative_test_classes_count_selected_due_to_insufficient_data,
       test_acceleration_pts_simulation_standard_wall_clock_savings_potential,
       test_acceleration_pts_simulation_standard_serial_time_savings_potential,
       test_acceleration_pts_simulation_standard_work_unit_failures_predicted_count,
       test_acceleration_pts_simulation_standard_work_unit_failures_missed_count,
       test_acceleration_pts_simulation_standard_avoidable_test_classes_count,
       test_acceleration_pts_simulation_standard_unavoidable_test_classes_count,
       test_acceleration_pts_simulation_standard_test_classes_count_selected_due_to_insufficient_data,
       test_acceleration_pts_simulation_fast_wall_clock_savings_potential,
       test_acceleration_pts_simulation_fast_serial_time_savings_potential,
       test_acceleration_pts_simulation_fast_work_unit_failures_predicted_count,
       test_acceleration_pts_simulation_fast_work_unit_failures_missed_count,
       test_acceleration_pts_simulation_fast_avoidable_test_classes_count,
       test_acceleration_pts_simulation_fast_unavoidable_test_classes_count,
       test_acceleration_pts_simulation_fast_test_classes_count_selected_due_to_insufficient_data,
       test_acceleration_td_usage_status,
       test_acceleration_td_wall_clock_savings_millis,
       test_acceleration_wall_clock_savings_combined_millis,
       release_year,
       release_number,
       maven_fail_never_enabled,
       maven_resume_enabled,
       build_start_timestamp,
       build_start_date,
       build_start_time,
       drv_chunk_id
FROM view_base
WHERE (projectname IS NOT NULL)
