CREATE OR REPLACE VIEW internal_maven_goal_summary AS
  WITH
    maven_goals AS (SELECT mavenattributes.toplevelprojectname                                projectname
                         , mavenbuildcacheperformance.buildcaches.remote.isenabled            remote_build_cache_enabled
                         , mavenbuildcacheperformance.buildcaches.remote.ispushenabled        remote_build_cache_push_enabled
                         , mavenbuildcacheperformance.buildcaches.remote.isdisabledduetoerror remote_build_cache_disabled_due_to_error
                         , mavenbuildcacheperformance.buildcaches.local.isenabled             local_build_cache_enabled
                         , mavenbuildcacheperformance.buildcaches.local.ispushenabled         local_build_cache_push_enabled
                         , mavenbuildcacheperformance.buildcaches.local.isdisabledduetoerror  local_build_cache_disabled_due_to_error
                         , (mavenbuildcacheperformance.buildcaches.local.isenabled OR
                            mavenbuildcacheperformance.buildcaches.remote.isenabled)          build_cache_enabled
                         , id                                                                 build_id
                         , array_join(mavenattributes.requestedgoals, ' ')                    requested_goals
                         , mavenbuildcacheperformance.goalexecution                           goals
                         , startdate                                                          build_start_date
                         , mavenattributes.tags                                               tags
                         , mavenattributes.hasfailed                                          has_failed
                         , COALESCE(mavenbuildcacheperformance.serializationfactor, 1)        serialization_factor
                         , mavenattributes.buildduration                                      build_duration_millis
                         , type                                                               build_tool
                         , mavenattributes.buildstarttime                                     build_start_timestamp
    FROM build
    WHERE (type = 'maven'))
  SELECT build_id
       , build_tool
       , build_start_date
       , build_start_timestamp
       , remote_build_cache_enabled
       , remote_build_cache_push_enabled
       , remote_build_cache_disabled_due_to_error
       , local_build_cache_enabled
       , local_build_cache_push_enabled
       , local_build_cache_disabled_due_to_error
       , build_cache_enabled
       , requested_goals
       , projectname
       , has_failed
       , build_duration_millis
       , tags
       , (CASE
            WHEN (contains(tags, 'CI') = true) THEN 'CI'
            WHEN (COALESCE(contains(tags, 'CI'), false) = false) THEN 'Local' END)             environment
       , goalexecution.mojotype                                                                goal_mojo_type
       , goalexecution.duration                                                                goal_duration_millis
       , goalexecution.avoidanceoutcome                                                        avoidance_outcome
       , goalexecution.avoidancesavings                                                        avoidance_savings_millis
       , goalexecution.cacheartifactsize                                                       cache_artifact_size
       , goalexecution.fingerprintingduration                                                  fingerprinting_duration_millis
       , serialization_factor
       , goalexecution.noncacheabilitycategory                                                 non_cacheability_category
       , goalexecution.cachekey                                                                goal_cachekey
       , goalexecution.goalname                                                                goal_path
       , COALESCE(t.category, 'other')                                                         goal_category
       , (CASE
            WHEN (goalexecution.noncacheabilitycategory = 'build_cache_disabled_by_user') THEN 'potentially_avoidable'
            WHEN (goalexecution.noncacheabilitycategory = 'no_gradle_enterprise_server_configured')
              THEN 'potentially_avoidable'
            WHEN (goalexecution.noncacheabilitycategory = 'no_develocity_server_configured')
              THEN 'potentially_avoidable'
            WHEN (goalexecution.noncacheabilitycategory = 'non_clean_build') THEN 'potentially_avoidable'
            WHEN (goalexecution.noncacheabilitycategory = 'goal_execution_marked_non_cacheable') THEN 'unavoidable'
            WHEN (goalexecution.noncacheabilitycategory = 'goal_not_supported') THEN 'unavoidable'
            WHEN (goalexecution.noncacheabilitycategory = 'cache-if_condition_not_matched') THEN 'unavoidable'
            WHEN (goalexecution.noncacheabilitycategory = 'disabled_to_ensure_correctness') THEN 'unavoidable'
            WHEN (goalexecution.noncacheabilitycategory = 'not_entitled') THEN 'unknown'
            WHEN (goalexecution.noncacheabilitycategory = 'unknown') THEN 'unknown'
            WHEN (goalexecution.noncacheabilitycategory = 'unknown_entitlements') THEN 'unknown'
            WHEN (goalexecution.noncacheabilitycategory = 'offline_build') THEN 'unknown' END) category
  FROM ((maven_goals
    CROSS JOIN UNNEST(goals) t (goalexecution))
    LEFT JOIN internal_task_mapping t ON ((goalexecution.mojotype LIKE t.typematch) OR (goalexecution.mojotype = t.typename)))
  WHERE ((projectname IS NOT NULL) AND (serialization_factor <> 0) AND (goalexecution.cachekey IS NOT NULL))
