CREATE EXTERNAL TABLE build(
   `type` string,
   `id` string,
   `buildToolVersion` string,
   `buildAgentVersion` string,
   `modelVersion` struct<`patch`: int, `release`: int, `string`: string, `year`: int>,
   `gradleAttributes` struct<`buildDuration`: bigint, `buildOptions`: struct<`buildCacheEnabled`: boolean, `configurationCacheEnabled`: boolean, `configurationOnDemandEnabled`: boolean, `continueOnFailureEnabled`: boolean, `continuousBuildEnabled`: boolean, `daemonEnabled`: boolean, `dryRunEnabled`: boolean, `excludedTasks`: array<string>, `fileSystemWatchingEnabled`: boolean, `isolatedProjectsEnabled`: boolean, `maxNumberOfGradleWorkers`: int, `offlineModeEnabled`: boolean, `parallelProjectExecutionEnabled`: boolean, `refreshDependenciesEnabled`: boolean, `rerunTasksEnabled`: boolean>, `buildStartTime`: bigint, `develocitySettings`: struct<`backgroundPublicationEnabled`: boolean, `buildOutputCapturingEnabled`: boolean, `fileFingerprintCapturingEnabled`: boolean, `resourceUsageCapturingEnabled`: boolean, `taskInputsFileCapturingEnabled`: boolean, `testOutputCapturingEnabled`: boolean>, `environment`: struct<`jreVersion`: string, `jvmCharset`: string, `jvmLocale`: string, `jvmMaxMemoryHeapSize`: bigint, `jvmVersion`: string, `localHostname`: string, `localIpAddresses`: array<string>, `numberOfCpuCores`: int, `operatingSystem`: string, `publicHostname`: string, `username`: string>, `gradleEnterpriseSettings`: struct<`backgroundPublicationEnabled`: boolean, `buildOutputCapturingEnabled`: boolean, `resourceUsageCapturingEnabled`: boolean, `taskInputsFileCapturingEnabled`: boolean, `testOutputCapturingEnabled`: boolean>, `gradleVersion`: string, `hasFailed`: boolean, `hasNonVerificationFailure`: boolean, `hasVerificationFailure`: boolean, `id`: string, `links`: array<struct<`label`: string, `url`: string>>, `pluginVersion`: string, `requestedTasks`: array<string>, `rootProjectName`: string, `tags`: array<string>, `values`: array<struct<`name`: string, `value`: string>>>,
   `mavenAttributes` struct<`buildDuration`: bigint, `buildOptions`: struct<`batchModeEnabled`: boolean, `daemonEnabled`: boolean, `debugEnabled`: boolean, `errorsEnabled`: boolean, `failAtEndEnabled`: boolean, `failFastEnabled`: boolean, `failNeverEnabled`: boolean, `laxChecksumsEnabled`: boolean, `maxNumberOfThreads`: int, `noSnapshotsUpdatesEnabled`: boolean, `nonRecursiveEnabled`: boolean, `offlineModeEnabled`: boolean, `quietEnabled`: boolean, `rerunGoals`: boolean, `rerunGoalsEnabled`: boolean, `resumeEnabled`: boolean, `strictChecksumsEnabled`: boolean, `updateSnapshotsEnabled`: boolean>, `buildStartTime`: bigint, `develocitySettings`: struct<`backgroundPublicationEnabled`: boolean, `buildOutputCapturingEnabled`: boolean, `fileFingerprintCapturingEnabled`: boolean, `goalInputsFileCapturingEnabled`: boolean, `resourceUsageCapturingEnabled`: boolean, `testOutputCapturingEnabled`: boolean>, `environment`: struct<`jreVersion`: string, `jvmCharset`: string, `jvmLocale`: string, `jvmMaxMemoryHeapSize`: bigint, `jvmVersion`: string, `localHostname`: string, `localIpAddresses`: array<string>, `numberOfCpuCores`: int, `operatingSystem`: string, `publicHostname`: string, `username`: string>, `extensionVersion`: string, `gradleEnterpriseSettings`: struct<`backgroundPublicationEnabled`: boolean, `buildOutputCapturingEnabled`: boolean, `goalInputsFileCapturingEnabled`: boolean, `resourceUsageCapturingEnabled`: boolean, `testOutputCapturingEnabled`: boolean>, `hasFailed`: boolean, `hasNonVerificationFailure`: boolean, `hasVerificationFailure`: boolean, `id`: string, `links`: array<struct<`label`: string, `url`: string>>, `mavenVersion`: string, `requestedGoals`: array<string>, `tags`: array<string>, `topLevelProjectName`: string, `values`: array<struct<`name`: string, `value`: string>>>,
   `bazelAttributes` struct<`bazelVersion`: string, `buildDuration`: bigint, `buildStartTime`: bigint, `command`: string, `exitCode`: int, `hasFailed`: boolean, `host`: string, `id`: string, `invocationId`: string, `links`: array<struct<`label`: string, `url`: string>>, `moduleName`: string, `tags`: array<string>, `targetPatterns`: array<string>, `user`: string, `values`: array<struct<`name`: string, `value`: string>>>,
   `npmAttributes` struct<`buildDuration`: bigint, `buildStartTime`: bigint, `command`: struct<`arguments`: array<string>, `command`: string>, `exitCode`: int, `hasFailed`: boolean, `host`: string, `id`: string, `links`: array<struct<`label`: string, `url`: string>>, `nodejsVersion`: string, `npmAgentVersion`: string, `npmVersion`: string, `packageName`: string, `tags`: array<string>, `user`: string, `values`: array<struct<`name`: string, `value`: string>>>,
   `pythonAttributes` struct<`buildDuration`: bigint, `buildStartTime`: bigint, `command`: array<string>, `exception`: string, `exitCode`: int, `hasFailed`: boolean, `host`: string, `id`: string, `links`: array<struct<`label`: string, `url`: string>>, `projectName`: string, `pythonAgentVersion`: string, `pythonVersion`: string, `tags`: array<string>, `user`: string, `values`: array<struct<`name`: string, `value`: string>>>,
   `sbtAttributes` struct<`buildDuration`: bigint, `buildOptions`: struct<`interactiveModeEnabled`: boolean, `offlineModeEnabled`: boolean, `parallelExecutionEnabled`: boolean, `semanticDbScalacPluginEnabled`: boolean, `turboEnabled`: boolean, `useCoursierEnabled`: boolean>, `buildStartTime`: bigint, `develocitySettings`: struct<`backgroundPublicationEnabled`: boolean, `buildOutputCapturingEnabled`: boolean, `resourceUsageCapturingEnabled`: boolean>, `environment`: struct<`jreVersion`: string, `jvmCharset`: string, `jvmLocale`: string, `jvmMaxMemoryHeapSize`: bigint, `jvmVersion`: string, `localHostname`: string, `localIpAddresses`: array<string>, `numberOfCpuCores`: int, `operatingSystem`: string, `publicHostname`: string, `username`: string>, `hasFailed`: boolean, `hasNonVerificationFailure`: boolean, `hasVerificationFailure`: boolean, `id`: string, `links`: array<struct<`label`: string, `url`: string>>, `pluginVersion`: string, `requestedCommands`: array<string>, `rootProjectName`: string, `sbtVersion`: string, `tags`: array<string>, `values`: array<struct<`name`: string, `value`: string>>>,
   `gradleTestPerformance` struct<`serialTestTasksExecutionTime`: bigint, `testAcceleration`: struct<`predictiveTestSelection`: struct<`simulation`: struct<`conservative`: struct<`avoidableTestClassesCount`: bigint, `serialTimeSavingsPotential`: bigint, `testClassesCountSelectedDueToInsufficientData`: bigint, `unavoidableTestClassesCount`: bigint, `wallClockSavingsPotential`: bigint, `workUnitFailuresMissedCount`: bigint, `workUnitFailuresPredictedCount`: bigint>, `fast`: struct<`avoidableTestClassesCount`: bigint, `serialTimeSavingsPotential`: bigint, `testClassesCountSelectedDueToInsufficientData`: bigint, `unavoidableTestClassesCount`: bigint, `wallClockSavingsPotential`: bigint, `workUnitFailuresMissedCount`: bigint, `workUnitFailuresPredictedCount`: bigint>, `standard`: struct<`avoidableTestClassesCount`: bigint, `serialTimeSavingsPotential`: bigint, `testClassesCountSelectedDueToInsufficientData`: bigint, `unavoidableTestClassesCount`: bigint, `wallClockSavingsPotential`: bigint, `workUnitFailuresMissedCount`: bigint, `workUnitFailuresPredictedCount`: bigint>>, `usage`: struct<`selectionMode`: string, `serialTimeSavings`: bigint, `status`: string, `wallClockSavings`: bigint>>, `testDistribution`: struct<`usageStatus`: string, `wallClockSavings`: bigint>, `wallClockSavings`: bigint>, `testTasks`: array<struct<`serialExecutionTime`: bigint, `taskPath`: string, `taskType`: string, `testAcceleration`: struct<`predictiveTestSelection`: struct<`simulation`: struct<`conservative`: struct<`avoidableTestClassesCount`: bigint, `failedTestClassesPredictedCount`: bigint, `serialTimeSavingsPotential`: bigint, `testClassesCountSelectedDueToInsufficientData`: bigint, `unavoidableTestClassesCount`: bigint, `wallClockSavingsPotential`: bigint>, `fast`: struct<`avoidableTestClassesCount`: bigint, `failedTestClassesPredictedCount`: bigint, `serialTimeSavingsPotential`: bigint, `testClassesCountSelectedDueToInsufficientData`: bigint, `unavoidableTestClassesCount`: bigint, `wallClockSavingsPotential`: bigint>, `standard`: struct<`avoidableTestClassesCount`: bigint, `failedTestClassesPredictedCount`: bigint, `serialTimeSavingsPotential`: bigint, `testClassesCountSelectedDueToInsufficientData`: bigint, `unavoidableTestClassesCount`: bigint, `wallClockSavingsPotential`: bigint>>, `usage`: struct<`nonSelectedTestClassesCount`: int, `selectionMode`: string, `serialTimeSavings`: bigint, `status`: string, `wallClockSavings`: bigint>>, `testDistribution`: struct<`remoteTestClassesCount`: int, `usageStatus`: string, `wallClockSavings`: bigint>, `wallClockSavings`: bigint>, `tests`: struct<`failedTestClassesCount`: int, `testClassesCount`: int>, `wallClockExecutionTime`: bigint>>, `tests`: struct<`testClassesCount`: int>>,
   `mavenTestPerformance` struct<`serialTestGoalsExecutionTime`: bigint, `testAcceleration`: struct<`predictiveTestSelection`: struct<`simulation`: struct<`conservative`: struct<`avoidableTestClassesCount`: bigint, `serialTimeSavingsPotential`: bigint, `testClassesCountSelectedDueToInsufficientData`: bigint, `unavoidableTestClassesCount`: bigint, `wallClockSavingsPotential`: bigint, `workUnitFailuresMissedCount`: bigint, `workUnitFailuresPredictedCount`: bigint>, `fast`: struct<`avoidableTestClassesCount`: bigint, `serialTimeSavingsPotential`: bigint, `testClassesCountSelectedDueToInsufficientData`: bigint, `unavoidableTestClassesCount`: bigint, `wallClockSavingsPotential`: bigint, `workUnitFailuresMissedCount`: bigint, `workUnitFailuresPredictedCount`: bigint>, `standard`: struct<`avoidableTestClassesCount`: bigint, `serialTimeSavingsPotential`: bigint, `testClassesCountSelectedDueToInsufficientData`: bigint, `unavoidableTestClassesCount`: bigint, `wallClockSavingsPotential`: bigint, `workUnitFailuresMissedCount`: bigint, `workUnitFailuresPredictedCount`: bigint>>, `usage`: struct<`selectionMode`: string, `serialTimeSavings`: bigint, `status`: string, `wallClockSavings`: bigint>>, `testDistribution`: struct<`usageStatus`: string, `wallClockSavings`: bigint>, `wallClockSavings`: bigint>, `testGoals`: array<struct<`goalPath`: string, `goalType`: string, `serialExecutionTime`: bigint, `testAcceleration`: struct<`predictiveTestSelection`: struct<`simulation`: struct<`conservative`: struct<`avoidableTestClassesCount`: bigint, `failedTestClassesPredictedCount`: bigint, `serialTimeSavingsPotential`: bigint, `testClassesCountSelectedDueToInsufficientData`: bigint, `unavoidableTestClassesCount`: bigint, `wallClockSavingsPotential`: bigint>, `fast`: struct<`avoidableTestClassesCount`: bigint, `failedTestClassesPredictedCount`: bigint, `serialTimeSavingsPotential`: bigint, `testClassesCountSelectedDueToInsufficientData`: bigint, `unavoidableTestClassesCount`: bigint, `wallClockSavingsPotential`: bigint>, `standard`: struct<`avoidableTestClassesCount`: bigint, `failedTestClassesPredictedCount`: bigint, `serialTimeSavingsPotential`: bigint, `testClassesCountSelectedDueToInsufficientData`: bigint, `unavoidableTestClassesCount`: bigint, `wallClockSavingsPotential`: bigint>>, `usage`: struct<`nonSelectedTestClassesCount`: int, `selectionMode`: string, `serialTimeSavings`: bigint, `status`: string, `wallClockSavings`: bigint>>, `testDistribution`: struct<`remoteTestClassesCount`: int, `usageStatus`: string, `wallClockSavings`: bigint>, `wallClockSavings`: bigint>, `tests`: struct<`failedTestClassesCount`: int, `testClassesCount`: int>, `wallClockExecutionTime`: bigint>>, `tests`: struct<`testClassesCount`: int>>,
   `gradleBuildCachePerformance` struct<`avoidanceSavingsSummary`: struct<`localBuildCache`: bigint, `ratio`: double, `remoteBuildCache`: bigint, `total`: bigint, `upToDate`: bigint>, `buildCaches`: struct<`local`: struct<`directory`: string, `isDisabledDueToError`: boolean, `isEnabled`: boolean, `isPushEnabled`: boolean>, `overhead`: struct<`downloading`: bigint, `packing`: bigint, `unpacking`: bigint, `uploading`: bigint>, `remote`: struct<`className`: string, `isDisabledDueToError`: boolean, `isEnabled`: boolean, `isPushEnabled`: boolean, `type`: string, `url`: string>>, `buildTime`: bigint, `effectiveTaskExecutionTime`: bigint, `effectiveWorkUnitExecutionTime`: bigint, `id`: string, `serialTaskExecutionTime`: bigint, `serialWorkUnitExecutionTime`: bigint, `serializationFactor`: double, `taskAvoidanceSavingsSummary`: struct<`localBuildCache`: bigint, `ratio`: double, `remoteBuildCache`: bigint, `total`: bigint, `upToDate`: bigint>, `taskExecution`: array<struct<`avoidanceOutcome`: string, `avoidanceSavings`: bigint, `cacheArtifactRejectedReason`: string, `cacheArtifactSize`: bigint, `cacheKey`: string, `duration`: bigint, `fingerprintingDuration`: bigint, `hasFailed`: boolean, `nonCacheabilityCategory`: string, `nonCacheabilityReason`: string, `skipReasonMessage`: string, `taskPath`: string, `taskType`: string>>, `taskFingerprintingSummary`: struct<`count`: int, `serialDuration`: bigint>, `workUnitAvoidanceSavingsSummary`: struct<`localBuildCache`: bigint, `ratio`: double, `remoteBuildCache`: bigint, `total`: bigint, `upToDate`: bigint>, `workUnitFingerprintingSummary`: struct<`count`: int, `serialDuration`: bigint>>,
   `mavenBuildCachePerformance` struct<`avoidanceSavingsSummary`: struct<`localBuildCache`: bigint, `ratio`: double, `remoteBuildCache`: bigint, `total`: bigint>, `buildCaches`: struct<`local`: struct<`directory`: string, `isDisabledDueToError`: boolean, `isEnabled`: boolean, `isPushEnabled`: boolean>, `overhead`: struct<`downloading`: bigint, `packing`: bigint, `unpacking`: bigint, `uploading`: bigint>, `remote`: struct<`isDisabledDueToError`: boolean, `isEnabled`: boolean, `isPushEnabled`: boolean, `url`: string>>, `buildTime`: bigint, `effectiveProjectExecutionTime`: bigint, `goalExecution`: array<struct<`avoidanceOutcome`: string, `avoidanceSavings`: bigint, `cacheArtifactRejectedReason`: string, `cacheArtifactSize`: bigint, `cacheKey`: string, `duration`: bigint, `fingerprintingDuration`: bigint, `goalExecutionId`: string, `goalName`: string, `goalProjectName`: string, `hasFailed`: boolean, `mojoType`: string, `nonCacheabilityCategory`: string, `nonCacheabilityReason`: string>>, `goalFingerprintingSummary`: struct<`count`: int, `serialDuration`: bigint>, `id`: string, `serialProjectExecutionTime`: bigint, `serializationFactor`: double>,
   `gradleBuildProfileOverview` struct<`breakdown`: struct<`configuration`: bigint, `endOfBuild`: bigint, `execution`: bigint, `initialization`: bigint, `total`: bigint>, `memoryUsage`: struct<`memoryPools`: array<struct<`maxMemory`: bigint, `name`: string, `peakMemory`: bigint>>, `totalGarbageCollectionTime`: bigint>>,
   `mavenBuildProfileOverview` struct<`breakdown`: struct<`execution`: struct<`endOfBuild`: bigint, `goalExecution`: bigint, `total`: bigint>, `initializationAndDiscovery`: struct<`other`: bigint, `projectDiscovery`: bigint, `settings`: bigint, `toolchains`: bigint, `total`: bigint>, `total`: bigint>, `memoryUsage`: struct<`memoryPools`: array<struct<`maxMemory`: bigint, `name`: string, `peakMemory`: bigint>>, `totalGarbageCollectionTime`: bigint>>,
   `gradleProjects` array<struct<`name`: string, `parent`: int, `path`: string>>,
   `mavenModules` array<struct<`artifactId`: string, `groupId`: string, `name`: string, `parent`: int, `version`: string>>,
   `mavenDependencyResolution` struct<`fileDownloadCount`: bigint, `fileDownloadSize`: bigint, `networkRequestCount`: bigint, `serialDependencyResolutionTime`: bigint, `serialNetworkRequestTime`: bigint, `wallClockNetworkRequestTime`: bigint>,
   `gradleNetworkActivity` struct<`fileDownloadCount`: bigint, `fileDownloadSize`: bigint, `networkRequestCount`: bigint, `serialNetworkRequestTime`: bigint, `wallClockNetworkRequestTime`: bigint>,
   `gradleArtifactTransformExecutions` struct<`artifactTransformExecutions`: array<struct<`artifactTransformExecutionName`: string, `avoidanceOutcome`: string, `avoidanceSavings`: bigint, `cacheArtifactRejectedReason`: string, `cacheArtifactSize`: bigint, `cacheKey`: string, `changedAttributes`: array<struct<`from`: string, `name`: string, `to`: string>>, `duration`: bigint, `fingerprintingDuration`: bigint, `inputArtifactName`: string, `nonCacheabilityCategory`: string, `nonCacheabilityReason`: string, `outcome`: string, `skipReasonMessage`: string, `transformActionType`: string>>>,
   `gradleDeprecations` struct<`deprecations`: array<struct<`advice`: string, `documentationUrl`: string, `removalDetails`: string, `summary`: string, `usages`: array<struct<`contextualAdvice`: string, `owner`: struct<`location`: string, `type`: string>>>>>>,
   `gradlePlugins` struct<`plugins`: array<struct<`className`: string, `id`: string, `projects`: array<string>, `version`: string>>>,
   `mavenPlugins` struct<`plugins`: array<struct<`artifactId`: string, `executedGoals`: array<string>, `goalPrefix`: string, `groupId`: string, `modules`: array<string>, `name`: string, `requiredMavenVersion`: string, `version`: string>>>,
   `mavenExtensions` struct<`extensions`: array<struct<`artifactId`: string, `groupId`: string, `type`: string, `version`: string>>>,
   `gradleResourceUsage` struct<`execution`: struct<`allProcessesCpu`: struct<`average`: bigint, `max`: bigint, `median`: bigint, `p25`: bigint, `p5`: bigint, `p75`: bigint, `p95`: bigint>, `allProcessesMemory`: struct<`average`: bigint, `max`: bigint, `median`: bigint, `p25`: bigint, `p5`: bigint, `p75`: bigint, `p95`: bigint>, `buildChildProcessesCpu`: struct<`average`: bigint, `max`: bigint, `median`: bigint, `p25`: bigint, `p5`: bigint, `p75`: bigint, `p95`: bigint>, `buildChildProcessesMemory`: struct<`average`: bigint, `max`: bigint, `median`: bigint, `p25`: bigint, `p5`: bigint, `p75`: bigint, `p95`: bigint>, `buildProcessCpu`: struct<`average`: bigint, `max`: bigint, `median`: bigint, `p25`: bigint, `p5`: bigint, `p75`: bigint, `p95`: bigint>, `buildProcessMemory`: struct<`average`: bigint, `max`: bigint, `median`: bigint, `p25`: bigint, `p5`: bigint, `p75`: bigint, `p95`: bigint>, `diskReadThroughput`: struct<`average`: bigint, `max`: bigint, `median`: bigint, `p25`: bigint, `p5`: bigint, `p75`: bigint, `p95`: bigint>, `diskWriteThroughput`: struct<`average`: bigint, `max`: bigint, `median`: bigint, `p25`: bigint, `p5`: bigint, `p75`: bigint, `p95`: bigint>, `networkDownloadThroughput`: struct<`average`: bigint, `max`: bigint, `median`: bigint, `p25`: bigint, `p5`: bigint, `p75`: bigint, `p95`: bigint>, `networkUploadThroughput`: struct<`average`: bigint, `max`: bigint, `median`: bigint, `p25`: bigint, `p5`: bigint, `p75`: bigint, `p95`: bigint>>, `nonExecution`: struct<`allProcessesCpu`: struct<`average`: bigint, `max`: bigint, `median`: bigint, `p25`: bigint, `p5`: bigint, `p75`: bigint, `p95`: bigint>, `allProcessesMemory`: struct<`average`: bigint, `max`: bigint, `median`: bigint, `p25`: bigint, `p5`: bigint, `p75`: bigint, `p95`: bigint>, `buildChildProcessesCpu`: struct<`average`: bigint, `max`: bigint, `median`: bigint, `p25`: bigint, `p5`: bigint, `p75`: bigint, `p95`: bigint>, `buildChildProcessesMemory`: struct<`average`: bigint, `max`: bigint, `median`: bigint, `p25`: bigint, `p5`: bigint, `p75`: bigint, `p95`: bigint>, `buildProcessCpu`: struct<`average`: bigint, `max`: bigint, `median`: bigint, `p25`: bigint, `p5`: bigint, `p75`: bigint, `p95`: bigint>, `buildProcessMemory`: struct<`average`: bigint, `max`: bigint, `median`: bigint, `p25`: bigint, `p5`: bigint, `p75`: bigint, `p95`: bigint>, `diskReadThroughput`: struct<`average`: bigint, `max`: bigint, `median`: bigint, `p25`: bigint, `p5`: bigint, `p75`: bigint, `p95`: bigint>, `diskWriteThroughput`: struct<`average`: bigint, `max`: bigint, `median`: bigint, `p25`: bigint, `p5`: bigint, `p75`: bigint, `p95`: bigint>, `networkDownloadThroughput`: struct<`average`: bigint, `max`: bigint, `median`: bigint, `p25`: bigint, `p5`: bigint, `p75`: bigint, `p95`: bigint>, `networkUploadThroughput`: struct<`average`: bigint, `max`: bigint, `median`: bigint, `p25`: bigint, `p5`: bigint, `p75`: bigint, `p95`: bigint>>, `total`: struct<`allProcessesCpu`: struct<`average`: bigint, `max`: bigint, `median`: bigint, `p25`: bigint, `p5`: bigint, `p75`: bigint, `p95`: bigint>, `allProcessesMemory`: struct<`average`: bigint, `max`: bigint, `median`: bigint, `p25`: bigint, `p5`: bigint, `p75`: bigint, `p95`: bigint>, `buildChildProcessesCpu`: struct<`average`: bigint, `max`: bigint, `median`: bigint, `p25`: bigint, `p5`: bigint, `p75`: bigint, `p95`: bigint>, `buildChildProcessesMemory`: struct<`average`: bigint, `max`: bigint, `median`: bigint, `p25`: bigint, `p5`: bigint, `p75`: bigint, `p95`: bigint>, `buildProcessCpu`: struct<`average`: bigint, `max`: bigint, `median`: bigint, `p25`: bigint, `p5`: bigint, `p75`: bigint, `p95`: bigint>, `buildProcessMemory`: struct<`average`: bigint, `max`: bigint, `median`: bigint, `p25`: bigint, `p5`: bigint, `p75`: bigint, `p95`: bigint>, `diskReadThroughput`: struct<`average`: bigint, `max`: bigint, `median`: bigint, `p25`: bigint, `p5`: bigint, `p75`: bigint, `p95`: bigint>, `diskWriteThroughput`: struct<`average`: bigint, `max`: bigint, `median`: bigint, `p25`: bigint, `p5`: bigint, `p75`: bigint, `p95`: bigint>, `networkDownloadThroughput`: struct<`average`: bigint, `max`: bigint, `median`: bigint, `p25`: bigint, `p5`: bigint, `p75`: bigint, `p95`: bigint>, `networkUploadThroughput`: struct<`average`: bigint, `max`: bigint, `median`: bigint, `p25`: bigint, `p5`: bigint, `p75`: bigint, `p95`: bigint>>, `totalMemory`: bigint>,
   `mavenResourceUsage` struct<`execution`: struct<`allProcessesCpu`: struct<`average`: bigint, `max`: bigint, `median`: bigint, `p25`: bigint, `p5`: bigint, `p75`: bigint, `p95`: bigint>, `allProcessesMemory`: struct<`average`: bigint, `max`: bigint, `median`: bigint, `p25`: bigint, `p5`: bigint, `p75`: bigint, `p95`: bigint>, `buildChildProcessesCpu`: struct<`average`: bigint, `max`: bigint, `median`: bigint, `p25`: bigint, `p5`: bigint, `p75`: bigint, `p95`: bigint>, `buildChildProcessesMemory`: struct<`average`: bigint, `max`: bigint, `median`: bigint, `p25`: bigint, `p5`: bigint, `p75`: bigint, `p95`: bigint>, `buildProcessCpu`: struct<`average`: bigint, `max`: bigint, `median`: bigint, `p25`: bigint, `p5`: bigint, `p75`: bigint, `p95`: bigint>, `buildProcessMemory`: struct<`average`: bigint, `max`: bigint, `median`: bigint, `p25`: bigint, `p5`: bigint, `p75`: bigint, `p95`: bigint>, `diskReadThroughput`: struct<`average`: bigint, `max`: bigint, `median`: bigint, `p25`: bigint, `p5`: bigint, `p75`: bigint, `p95`: bigint>, `diskWriteThroughput`: struct<`average`: bigint, `max`: bigint, `median`: bigint, `p25`: bigint, `p5`: bigint, `p75`: bigint, `p95`: bigint>, `networkDownloadThroughput`: struct<`average`: bigint, `max`: bigint, `median`: bigint, `p25`: bigint, `p5`: bigint, `p75`: bigint, `p95`: bigint>, `networkUploadThroughput`: struct<`average`: bigint, `max`: bigint, `median`: bigint, `p25`: bigint, `p5`: bigint, `p75`: bigint, `p95`: bigint>>, `nonExecution`: struct<`allProcessesCpu`: struct<`average`: bigint, `max`: bigint, `median`: bigint, `p25`: bigint, `p5`: bigint, `p75`: bigint, `p95`: bigint>, `allProcessesMemory`: struct<`average`: bigint, `max`: bigint, `median`: bigint, `p25`: bigint, `p5`: bigint, `p75`: bigint, `p95`: bigint>, `buildChildProcessesCpu`: struct<`average`: bigint, `max`: bigint, `median`: bigint, `p25`: bigint, `p5`: bigint, `p75`: bigint, `p95`: bigint>, `buildChildProcessesMemory`: struct<`average`: bigint, `max`: bigint, `median`: bigint, `p25`: bigint, `p5`: bigint, `p75`: bigint, `p95`: bigint>, `buildProcessCpu`: struct<`average`: bigint, `max`: bigint, `median`: bigint, `p25`: bigint, `p5`: bigint, `p75`: bigint, `p95`: bigint>, `buildProcessMemory`: struct<`average`: bigint, `max`: bigint, `median`: bigint, `p25`: bigint, `p5`: bigint, `p75`: bigint, `p95`: bigint>, `diskReadThroughput`: struct<`average`: bigint, `max`: bigint, `median`: bigint, `p25`: bigint, `p5`: bigint, `p75`: bigint, `p95`: bigint>, `diskWriteThroughput`: struct<`average`: bigint, `max`: bigint, `median`: bigint, `p25`: bigint, `p5`: bigint, `p75`: bigint, `p95`: bigint>, `networkDownloadThroughput`: struct<`average`: bigint, `max`: bigint, `median`: bigint, `p25`: bigint, `p5`: bigint, `p75`: bigint, `p95`: bigint>, `networkUploadThroughput`: struct<`average`: bigint, `max`: bigint, `median`: bigint, `p25`: bigint, `p5`: bigint, `p75`: bigint, `p95`: bigint>>, `total`: struct<`allProcessesCpu`: struct<`average`: bigint, `max`: bigint, `median`: bigint, `p25`: bigint, `p5`: bigint, `p75`: bigint, `p95`: bigint>, `allProcessesMemory`: struct<`average`: bigint, `max`: bigint, `median`: bigint, `p25`: bigint, `p5`: bigint, `p75`: bigint, `p95`: bigint>, `buildChildProcessesCpu`: struct<`average`: bigint, `max`: bigint, `median`: bigint, `p25`: bigint, `p5`: bigint, `p75`: bigint, `p95`: bigint>, `buildChildProcessesMemory`: struct<`average`: bigint, `max`: bigint, `median`: bigint, `p25`: bigint, `p5`: bigint, `p75`: bigint, `p95`: bigint>, `buildProcessCpu`: struct<`average`: bigint, `max`: bigint, `median`: bigint, `p25`: bigint, `p5`: bigint, `p75`: bigint, `p95`: bigint>, `buildProcessMemory`: struct<`average`: bigint, `max`: bigint, `median`: bigint, `p25`: bigint, `p5`: bigint, `p75`: bigint, `p95`: bigint>, `diskReadThroughput`: struct<`average`: bigint, `max`: bigint, `median`: bigint, `p25`: bigint, `p5`: bigint, `p75`: bigint, `p95`: bigint>, `diskWriteThroughput`: struct<`average`: bigint, `max`: bigint, `median`: bigint, `p25`: bigint, `p5`: bigint, `p75`: bigint, `p95`: bigint>, `networkDownloadThroughput`: struct<`average`: bigint, `max`: bigint, `median`: bigint, `p25`: bigint, `p5`: bigint, `p75`: bigint, `p95`: bigint>, `networkUploadThroughput`: struct<`average`: bigint, `max`: bigint, `median`: bigint, `p25`: bigint, `p5`: bigint, `p75`: bigint, `p95`: bigint>>, `totalMemory`: bigint>,
   `gradleConfigurationCache` struct<`result`: struct<`checkFingerprintDuration`: bigint, `dependencyResolutionDuration`: bigint, `entrySize`: bigint, `load`: struct<`duration`: bigint, `hasFailed`: boolean>, `missReasons`: array<string>, `outcome`: string, `store`: struct<`duration`: bigint, `hasFailed`: boolean>>>,
   `bazelCriticalPath` struct<`actions`: array<struct<`category`: string, `duration`: bigint, `name`: string>>>,
   `gradleDependencies` struct<`dependencies`: array<struct<`name`: string, `namespace`: string, `purl`: string, `qualifiers`: map<string, string>, `repository`: struct<`resolutionSource`: string, `type`: string, `url`: string>, `scheme`: string, `subpath`: string, `type`: string, `version`: string>>>,
   `mavenDependencies` struct<`dependencies`: array<struct<`name`: string, `namespace`: string, `purl`: string, `qualifiers`: map<string, string>, `repository`: struct<`resolutionSource`: string, `type`: string, `url`: string>, `scheme`: string, `subpath`: string, `type`: string, `version`: string>>>,
   `npmDependencies` struct<`dependencies`: array<struct<`name`: string, `namespace`: string, `purl`: string, `qualifiers`: map<string, string>, `repository`: struct<`resolutionSource`: string, `type`: string, `url`: string>, `scheme`: string, `subpath`: string, `type`: string, `version`: string>>>
)
PARTITIONED BY(
  `startdate` date COMMENT ''
)
ROW FORMAT SERDE
  'org.openx.data.jsonserde.JsonSerDe'
WITH SERDEPROPERTIES(
  'ignore.malformed.json'='true'
) STORED AS INPUTFORMAT
  'org.apache.hadoop.mapred.TextInputFormat'
OUTPUTFORMAT
  'org.apache.hadoop.hive.ql.io.HiveIgnoreKeyTextOutputFormat'
LOCATION
  '${s3.path}/build-models'
TBLPROPERTIES(
  'projection.startdate.type'='date',
  'projection.startdate.range'='2020-01-01,NOW',
  'projection.enabled'='true',
  'projection.startdate.format'='yyyy-MM-dd',
  'storage.location.template'='${s3.path}/build-models/startdate=${startdate}/'
)
