CREATE EXTERNAL TABLE test_performance_summary (
    `build_id` string,
    `build_start_timestamp` bigint,
    `build_duration_millis` bigint,
    `build_tool` string,
    `build_test_classes_count` int,
    `build_serial_test_work_units_execution_time` bigint,
    `build_test_acceleration_pts_usage_status` string,
    `build_test_acceleration_pts_usage_wall_clock_savings_millis` bigint,
    `build_test_acceleration_pts_usage_serial_time_savings_millis` bigint,
    `build_test_acceleration_pts_simulation_conservative_wall_clock_savings_potential_millis` bigint,
    `build_test_acceleration_pts_simulation_conservative_serial_time_savings_potential_millis` bigint,
    `build_test_acceleration_pts_simulation_conservative_work_unit_failures_predicted_count` bigint,
    `build_test_acceleration_pts_simulation_conservative_work_unit_failures_missed_count` bigint,
    `build_test_acceleration_pts_simulation_conservative_avoidable_test_classes_count` bigint,
    `build_test_acceleration_pts_simulation_conservative_unavoidable_test_classes_count` bigint,
    `build_test_acceleration_pts_simulation_conservative_test_classes_count_selected_due_to_insufficient_data` bigint,
    `build_test_acceleration_pts_simulation_standard_wall_clock_savings_potential_millis` bigint,
    `build_test_acceleration_pts_simulation_standard_serial_time_savings_potential_millis` bigint,
    `build_test_acceleration_pts_simulation_standard_work_unit_failures_predicted_count` bigint,
    `build_test_acceleration_pts_simulation_standard_work_unit_failures_missed_count` bigint,
    `build_test_acceleration_pts_simulation_standard_avoidable_test_classes_count` bigint,
    `build_test_acceleration_pts_simulation_standard_unavoidable_test_classes_count` bigint,
    `build_test_acceleration_pts_simulation_standard_test_classes_count_selected_due_to_insufficient_data` bigint,
    `build_test_acceleration_pts_simulation_fast_wall_clock_savings_potential_millis` bigint,
    `build_test_acceleration_pts_simulation_fast_serial_time_savings_potential_millis` bigint,
    `build_test_acceleration_pts_simulation_fast_work_unit_failures_predicted_count` bigint,
    `build_test_acceleration_pts_simulation_fast_work_unit_failures_missed_count` bigint,
    `build_test_acceleration_pts_simulation_fast_avoidable_test_classes_count` bigint,
    `build_test_acceleration_pts_simulation_fast_unavoidable_test_classes_count` bigint,
    `build_test_acceleration_pts_simulation_fast_test_classes_count_selected_due_to_insufficient_data` bigint,
    `build_test_acceleration_td_usage_status` string,
    `build_test_acceleration_td_wall_clock_savings_millis` bigint,
    `build_test_acceleration_wall_clock_savings_combined_millis` bigint,
    `projectname` string,
    `tags` array<string>,
    `environment` string,
    `work_unit_path` string,
    `work_unit_wall_clock_execution_time` bigint,
    `work_unit_type` string,
    `work_unit_serial_execution_time` bigint,
    `work_unit_failed_test_classes_count` int,
    `work_unit_test_classes_count` int,
    `work_unit_test_acceleration_pts_usage_status` string,
    `work_unit_test_acceleration_pts_usage_wall_clock_savings_millis` bigint,
    `work_unit_test_acceleration_pts_usage_serial_time_savings_millis` bigint,
    `work_unit_test_acceleration_pts_usage_non_selected_test_classes_count` int,
    `work_unit_test_acceleration_pts_simulation_conservative_wall_clock_savings_potential_millis` bigint,
    `work_unit_test_acceleration_pts_simulation_conservative_serial_time_savings_potential_millis` bigint,
    `work_unit_test_acceleration_pts_simulation_conservative_avoidable_test_classes_count` bigint,
    `work_unit_test_acceleration_pts_simulation_conservative_unavoidable_test_classes_count` bigint,
    `work_unit_test_acceleration_pts_simulation_conservative_test_classes_count_selected_due_to_insufficient_data` bigint,
    `work_unit_test_acceleration_pts_simulation_conservative_failed_test_classes_predicted_count` bigint,
    `work_unit_test_acceleration_pts_simulation_standard_wall_clock_savings_potential_millis` bigint,
    `work_unit_test_acceleration_pts_simulation_standard_serial_time_savings_potential_millis` bigint,
    `work_unit_test_acceleration_pts_simulation_standard_avoidable_test_classes_count` bigint,
    `work_unit_test_acceleration_pts_simulation_standard_unavoidable_test_classes_count` bigint,
    `work_unit_test_acceleration_pts_simulation_standard_test_classes_count_selected_due_to_insufficient_data` bigint,
    `work_unit_test_acceleration_pts_simulation_standard_failed_test_classes_predicted_count` bigint,
    `work_unit_test_acceleration_pts_simulation_fast_wall_clock_savings_potential_millis` bigint,
    `work_unit_test_acceleration_pts_simulation_fast_serial_time_savings_potential_millis` bigint,
    `work_unit_test_acceleration_pts_simulation_fast_avoidable_test_classes_count` bigint,
    `work_unit_test_acceleration_pts_simulation_fast_unavoidable_test_classes_count` bigint,
    `work_unit_test_acceleration_pts_simulation_fast_test_classes_count_selected_due_to_insufficient_data` bigint,
    `work_unit_test_acceleration_pts_simulation_fast_failed_test_classes_predicted_count` bigint,
    `work_unit_test_acceleration_td_usage_status` string,
    `work_unit_test_acceleration_td_wall_clock_savings_millis` bigint,
    `work_unit_test_acceleration_td_remote_test_classes_count` int,
    `work_unit_test_acceleration_wall_clock_savings_combined_millis` bigint,
    `build_requested_tasks_or_goals` string,
    `build_test_acceleration_pts_usage_selection_mode` string,
    `work_unit_test_acceleration_pts_usage_selection_mode` string)
PARTITIONED BY (`build_start_date` date, `batchid` bigint)
ROW FORMAT SERDE 'org.apache.hadoop.hive.ql.io.orc.OrcSerde'
WITH
  serdeproperties ('orc.column.index.access'='false')
    STORED AS
       INPUTFORMAT 'org.apache.hadoop.hive.ql.io.orc.OrcInputFormat'
       OUTPUTFORMAT 'org.apache.hadoop.hive.ql.io.orc.OrcOutputFormat'
LOCATION '${s3.path}/tables/test_performance_summary/'
TBLPROPERTIES ('develocity.reporting.schemaversion'='${currentVersion}', 'develocity.reporting.partition.date.key'='build_start_date', 'develocity.reporting.population.order'='1', 'develocity.reporting.source'='internal_test_performance_summary')
