CREATE OR REPLACE VIEW internal_extensions_summary AS
SELECT build.id                                                                       build_id,
       extensions.type                                                                type,
       extensions.version                                                             version,
       extensions.groupid                                                             group_id,
       extensions.artifactid                                                          artifact_id,
       CONCAT(extensions.groupid, ':', extensions.artifactid) AS                      name,
       mavenattributes.toplevelprojectname                                            projectname,
       build.type                                                                     build_tool,
       mavenattributes.buildduration                                                  build_duration_millis,
       mavenattributes.tags                                                           tags,
       (CASE
          WHEN (contains(build.mavenattributes.tags, 'CI') = true) THEN 'CI'
          WHEN (contains(build.mavenattributes.tags, 'CI') = false) THEN 'Local' END) environment,
       build_start_date,
       build_start_time,
       drv_chunk_id
FROM build,
     unnest(build.mavenextensions.extensions) t (extensions)
WHERE (mavenattributes.toplevelprojectname IS NOT NULL)
