CREATE EXTERNAL TABLE unit_execution_summary (
`build_id` string,
`build_tool` string,
`build_start_timestamp` bigint,
`remote_build_cache_enabled` boolean,
`remote_build_cache_push_enabled` boolean,
`remote_build_cache_disabled_due_to_error` boolean,
`local_build_cache_enabled` boolean,
`local_build_cache_push_enabled` boolean,
`local_build_cache_disabled_due_to_error` boolean,
`build_cache_enabled` boolean,
`requested_goals_or_tasks` string,
`projectname` string,
`has_failed` boolean,
`build_duration_millis` bigint,
`tags` array<string>,
`environment` string,
`goal_or_task_type` string,
`goal_or_task_duration_millis` bigint,
`avoidance_outcome` string,
`avoidance_savings_millis` bigint,
`cache_artifact_size` bigint,
`fingerprinting_duration_millis` bigint,
`serialization_factor` double,
`non_cacheability_category` string,
`goal_or_task_cache_key` string,
`goal_or_task_path` string,
`goal_or_task_category` string,
`category` string,
`drv_chunk_row_number` bigint)
PARTITIONED BY ( `build_start_date` date, `build_start_time` string, `drv_chunk_id` string)
ROW FORMAT SERDE 'org.apache.hadoop.hive.ql.io.orc.OrcSerde'
WITH
  serdeproperties ('orc.column.index.access'='false')
    STORED AS
       INPUTFORMAT 'org.apache.hadoop.hive.ql.io.orc.OrcInputFormat'
       OUTPUTFORMAT 'org.apache.hadoop.hive.ql.io.orc.OrcOutputFormat'
LOCATION '${s3.path}tables/unit_execution_summary/'
TBLPROPERTIES ('develocity.reporting.schemaversion'='${currentVersion}', 'develocity.reporting.partition.date.key'='build_start_date', 'develocity.reporting.population.order'='1', 'develocity.reporting.source'='internal_unit_execution_summary')
