CREATE OR REPLACE VIEW internal_unit_execution_summary AS
  SELECT build_id,
         build_tool,
         build_start_time,
         remote_build_cache_enabled,
         remote_build_cache_push_enabled,
         remote_build_cache_disabled_due_to_error,
         local_build_cache_enabled,
         local_build_cache_push_enabled,
         local_build_cache_disabled_due_to_error,
         build_cache_enabled,
         requested_goals      requested_goals_or_tasks,
         projectname,
         has_failed,
         build_duration_millis,
         tags,
         environment,
         goal_mojo_type       goal_or_task_type,
         goal_duration_millis goal_or_task_duration_millis,
         avoidance_outcome,
         avoidance_savings_millis,
         cache_artifact_size,
         fingerprinting_duration_millis,
         serialization_factor,
         non_cacheability_category,
         goal_cachekey        goal_or_task_cache_key,
         goal_path            goal_or_task_path,
         goal_category        goal_or_task_category,
         category,
         build_start_date,
         batchid
  FROM internal_maven_goal_summary
  UNION
  SELECT build_id,
         build_tool,
         build_start_time,
         remote_build_cache_enabled,
         remote_build_cache_push_enabled,
         remote_build_cache_disabled_due_to_error,
         local_build_cache_enabled,
         local_build_cache_push_enabled,
         local_build_cache_disabled_due_to_error,
         build_cache_enabled,
         requested_tasks      requested_goals_or_tasks,
         projectname,
         has_failed,
         build_duration_millis,
         tags,
         environment,
         task_type            goal_or_task_type,
         task_duration_millis goal_or_task_duration_millis,
         avoidance_outcome,
         avoidance_savings_millis,
         cache_artifact_size,
         fingerprinting_duration_millis,
         serialization_factor,
         non_cacheability_category,
         task_cachekey        goal_or_task_cache_key,
         task_path            goal_or_task_path,
         task_category        goal_or_task_category,
         category,
         build_start_date,
         batchid
  FROM internal_gradle_task_summary
