-- Replace ${database} with the actual database name
CREATE OR REPLACE VIEW internal_test_performance_summary AS
  WITH
    gradle_builds AS (SELECT id                                                                                                                                   build_id,
                             batchid                                                                                                                              batchid,
                             startdate                                                                                                                            build_start_date,
                             gradleattributes.buildstarttime                                                                                                      build_start_time,
                             gradleattributes.buildduration                                                                                                       build_duration_millis,
                             ARRAY_JOIN(gradleattributes.requestedtasks, ' ')                                                                                     build_requested_tasks_or_goals,
                             type                                                                                                                                 build_tool,
                             gradletestperformance.tests.testclassescount                                                                                         build_test_classes_count,
                             gradletestperformance.serialtesttasksexecutiontime                                                                                   build_serial_test_work_units_execution_time,
                             gradletestperformance.testacceleration.predictivetestselection.usage.status                                                          build_test_acceleration_pts_usage_status,
                             gradletestperformance.testacceleration.predictivetestselection.usage.wallclocksavings                                                build_test_acceleration_pts_usage_wall_clock_savings_millis,
                             gradletestperformance.testacceleration.predictivetestselection.usage.serialtimesavings                                               build_test_acceleration_pts_usage_serial_time_savings_millis,
                             gradletestperformance.testAcceleration.predictiveTestSelection.usage.selectionMode                                                   build_test_acceleration_pts_usage_selection_mode,
                             gradletestperformance.testacceleration.predictivetestselection.simulation.conservative.wallclocksavingspotential                     build_test_acceleration_pts_simulation_conservative_wall_clock_savings_potential_millis,
                             gradletestperformance.testacceleration.predictivetestselection.simulation.conservative.serialtimesavingspotential                    build_test_acceleration_pts_simulation_conservative_serial_time_savings_potential_millis,
                             gradletestperformance.testacceleration.predictivetestselection.simulation.conservative.workunitfailurespredictedcount                build_test_acceleration_pts_simulation_conservative_work_unit_failures_predicted_count,
                             gradletestperformance.testacceleration.predictivetestselection.simulation.conservative.workunitfailuresmissedcount                   build_test_acceleration_pts_simulation_conservative_work_unit_failures_missed_count,
                             gradletestperformance.testacceleration.predictivetestselection.simulation.conservative.avoidabletestclassescount                     build_test_acceleration_pts_simulation_conservative_avoidable_test_classes_count,
                             gradletestperformance.testacceleration.predictivetestselection.simulation.conservative.unavoidabletestclassescount                   build_test_acceleration_pts_simulation_conservative_unavoidable_test_classes_count,
                             gradletestperformance.testacceleration.predictivetestselection.simulation.conservative.testclassescountselectedduetoinsufficientdata build_test_acceleration_pts_simulation_conservative_test_classes_count_selected_due_to_insufficient_data,
                             gradletestperformance.testacceleration.predictivetestselection.simulation.standard.wallclocksavingspotential                         build_test_acceleration_pts_simulation_standard_wall_clock_savings_potential_millis,
                             gradletestperformance.testacceleration.predictivetestselection.simulation.standard.serialtimesavingspotential                        build_test_acceleration_pts_simulation_standard_serial_time_savings_potential_millis,
                             gradletestperformance.testacceleration.predictivetestselection.simulation.standard.workunitfailurespredictedcount                    build_test_acceleration_pts_simulation_standard_work_unit_failures_predicted_count,
                             gradletestperformance.testacceleration.predictivetestselection.simulation.standard.workunitfailuresmissedcount                       build_test_acceleration_pts_simulation_standard_work_unit_failures_missed_count,
                             gradletestperformance.testacceleration.predictivetestselection.simulation.standard.avoidabletestclassescount                         build_test_acceleration_pts_simulation_standard_avoidable_test_classes_count,
                             gradletestperformance.testacceleration.predictivetestselection.simulation.standard.unavoidabletestclassescount                       build_test_acceleration_pts_simulation_standard_unavoidable_test_classes_count,
                             gradletestperformance.testacceleration.predictivetestselection.simulation.standard.testclassescountselectedduetoinsufficientdata     build_test_acceleration_pts_simulation_standard_test_classes_count_selected_due_to_insufficient_data,
                             gradletestperformance.testacceleration.predictivetestselection.simulation.fast.wallclocksavingspotential                             build_test_acceleration_pts_simulation_fast_wall_clock_savings_potential_millis,
                             gradletestperformance.testacceleration.predictivetestselection.simulation.fast.serialtimesavingspotential                            build_test_acceleration_pts_simulation_fast_serial_time_savings_potential_millis,
                             gradletestperformance.testacceleration.predictivetestselection.simulation.fast.workunitfailurespredictedcount                        build_test_acceleration_pts_simulation_fast_work_unit_failures_predicted_count,
                             gradletestperformance.testacceleration.predictivetestselection.simulation.fast.workunitfailuresmissedcount                           build_test_acceleration_pts_simulation_fast_work_unit_failures_missed_count,
                             gradletestperformance.testacceleration.predictivetestselection.simulation.fast.avoidabletestclassescount                             build_test_acceleration_pts_simulation_fast_avoidable_test_classes_count,
                             gradletestperformance.testacceleration.predictivetestselection.simulation.fast.unavoidabletestclassescount                           build_test_acceleration_pts_simulation_fast_unavoidable_test_classes_count,
                             gradletestperformance.testacceleration.predictivetestselection.simulation.fast.testclassescountselectedduetoinsufficientdata         build_test_acceleration_pts_simulation_fast_test_classes_count_selected_due_to_insufficient_data,
                             gradletestperformance.testacceleration.testdistribution.usagestatus                                                                  build_test_acceleration_td_usage_status,
                             gradletestperformance.testacceleration.testdistribution.wallclocksavings                                                             build_test_acceleration_td_wall_clock_savings_millis,
                             gradletestperformance.testacceleration.wallclocksavings                                                                              build_test_acceleration_wall_clock_savings_combined_millis,
                             gradleattributes.rootprojectname                                                                                                     projectname,
                             (CASE
                                WHEN (contains(build.gradleattributes.tags, 'CI') = true) THEN 'CI'
                                WHEN (contains(build.gradleattributes.tags, 'CI') = false)
                                  THEN 'Local' END)                                                                                                               environment,
                             gradletestperformance.testtasks                                                                                                      testtasks
    FROM "${database}".build
    WHERE (type = 'gradle')),
    maven_builds AS (SELECT id                                                                                                                                  build_id,
                            batchid                                                                                                                             batchid,
                            startdate                                                                                                                           build_start_date,
                            mavenattributes.buildstarttime                                                                                                      build_start_time,
                            mavenattributes.buildduration                                                                                                       build_duration_millis,
                            ARRAY_JOIN(mavenattributes.requestedgoals, ' ')                                                                                     build_requested_tasks_or_goals,
                            type                                                                                                                                build_tool,
                            maventestperformance.tests.testclassescount                                                                                         build_test_classes_count,
                            maventestperformance.serialtestgoalsexecutiontime                                                                                   build_serial_test_work_units_execution_time,
                            maventestperformance.testacceleration.predictivetestselection.usage.status                                                          build_test_acceleration_pts_usage_status,
                            maventestperformance.testacceleration.predictivetestselection.usage.wallclocksavings                                                build_test_acceleration_pts_usage_wall_clock_savings_millis,
                            maventestperformance.testacceleration.predictivetestselection.usage.serialtimesavings                                               build_test_acceleration_pts_usage_serial_time_savings_millis,
                            maventestperformance.testAcceleration.predictiveTestSelection.usage.selectionMode                                                   build_test_acceleration_pts_usage_selection_mode,
                            maventestperformance.testacceleration.predictivetestselection.simulation.conservative.wallclocksavingspotential                     build_test_acceleration_pts_simulation_conservative_wall_clock_savings_potential_millis,
                            maventestperformance.testacceleration.predictivetestselection.simulation.conservative.serialtimesavingspotential                    build_test_acceleration_pts_simulation_conservative_serial_time_savings_potential_millis,
                            maventestperformance.testacceleration.predictivetestselection.simulation.conservative.workunitfailurespredictedcount                build_test_acceleration_pts_simulation_conservative_work_unit_failures_predicted_count,
                            maventestperformance.testacceleration.predictivetestselection.simulation.conservative.workunitfailuresmissedcount                   build_test_acceleration_pts_simulation_conservative_work_unit_failures_missed_count,
                            maventestperformance.testacceleration.predictivetestselection.simulation.conservative.avoidabletestclassescount                     build_test_acceleration_pts_simulation_conservative_avoidable_test_classes_count,
                            maventestperformance.testacceleration.predictivetestselection.simulation.conservative.unavoidabletestclassescount                   build_test_acceleration_pts_simulation_conservative_unavoidable_test_classes_count,
                            maventestperformance.testacceleration.predictivetestselection.simulation.conservative.testclassescountselectedduetoinsufficientdata build_test_acceleration_pts_simulation_conservative_test_classes_count_selected_due_to_insufficient_data,
                            maventestperformance.testacceleration.predictivetestselection.simulation.standard.wallclocksavingspotential                         build_test_acceleration_pts_simulation_standard_wall_clock_savings_potential_millis,
                            maventestperformance.testacceleration.predictivetestselection.simulation.standard.serialtimesavingspotential                        build_test_acceleration_pts_simulation_standard_serial_time_savings_potential_millis,
                            maventestperformance.testacceleration.predictivetestselection.simulation.standard.workunitfailurespredictedcount                    build_test_acceleration_pts_simulation_standard_work_unit_failures_predicted_count,
                            maventestperformance.testacceleration.predictivetestselection.simulation.standard.workunitfailuresmissedcount                       build_test_acceleration_pts_simulation_standard_work_unit_failures_missed_count,
                            maventestperformance.testacceleration.predictivetestselection.simulation.standard.avoidabletestclassescount                         build_test_acceleration_pts_simulation_standard_avoidable_test_classes_count,
                            maventestperformance.testacceleration.predictivetestselection.simulation.standard.unavoidabletestclassescount                       build_test_acceleration_pts_simulation_standard_unavoidable_test_classes_count,
                            maventestperformance.testacceleration.predictivetestselection.simulation.standard.testclassescountselectedduetoinsufficientdata     build_test_acceleration_pts_simulation_standard_test_classes_count_selected_due_to_insufficient_data,
                            maventestperformance.testacceleration.predictivetestselection.simulation.fast.wallclocksavingspotential                             build_test_acceleration_pts_simulation_fast_wall_clock_savings_potential_millis,
                            maventestperformance.testacceleration.predictivetestselection.simulation.fast.serialtimesavingspotential                            build_test_acceleration_pts_simulation_fast_serial_time_savings_potential_millis,
                            maventestperformance.testacceleration.predictivetestselection.simulation.fast.workunitfailurespredictedcount                        build_test_acceleration_pts_simulation_fast_work_unit_failures_predicted_count,
                            maventestperformance.testacceleration.predictivetestselection.simulation.fast.workunitfailuresmissedcount                           build_test_acceleration_pts_simulation_fast_work_unit_failures_missed_count,
                            maventestperformance.testacceleration.predictivetestselection.simulation.fast.avoidabletestclassescount                             build_test_acceleration_pts_simulation_fast_avoidable_test_classes_count,
                            maventestperformance.testacceleration.predictivetestselection.simulation.fast.unavoidabletestclassescount                           build_test_acceleration_pts_simulation_fast_unavoidable_test_classes_count,
                            maventestperformance.testacceleration.predictivetestselection.simulation.fast.testclassescountselectedduetoinsufficientdata         build_test_acceleration_pts_simulation_fast_test_classes_count_selected_due_to_insufficient_data,
                            maventestperformance.testacceleration.testdistribution.usagestatus                                                                  build_test_acceleration_td_usage_status,
                            maventestperformance.testacceleration.testdistribution.wallclocksavings                                                             build_test_acceleration_td_wall_clock_savings_millis,
                            maventestperformance.testacceleration.wallclocksavings                                                                              build_test_acceleration_wall_clock_savings_combined_millis,
                            mavenattributes.toplevelprojectname                                                                                                 projectname,
                            (CASE
                               WHEN (contains(build.mavenattributes.tags, 'CI') = true) THEN 'CI'
                               WHEN (contains(build.mavenattributes.tags, 'CI') = false)
                                 THEN 'Local' END)                                                                                                              environment,
                            maventestperformance.testgoals                                                                                                      testgoals
    FROM "${database}".build
    WHERE (type = 'maven'))
  SELECT build_id,
         build_start_time,
         build_duration_millis,
         build_requested_tasks_or_goals,
         build_tool,
         build_test_classes_count,
         build_serial_test_work_units_execution_time,
         build_test_acceleration_pts_usage_status,
         build_test_acceleration_pts_usage_wall_clock_savings_millis,
         build_test_acceleration_pts_usage_serial_time_savings_millis,
         build_test_acceleration_pts_usage_selection_mode,
         build_test_acceleration_pts_simulation_conservative_wall_clock_savings_potential_millis,
         build_test_acceleration_pts_simulation_conservative_serial_time_savings_potential_millis,
         build_test_acceleration_pts_simulation_conservative_work_unit_failures_predicted_count,
         build_test_acceleration_pts_simulation_conservative_work_unit_failures_missed_count,
         build_test_acceleration_pts_simulation_conservative_avoidable_test_classes_count,
         build_test_acceleration_pts_simulation_conservative_unavoidable_test_classes_count,
         build_test_acceleration_pts_simulation_conservative_test_classes_count_selected_due_to_insufficient_data,
         build_test_acceleration_pts_simulation_standard_wall_clock_savings_potential_millis,
         build_test_acceleration_pts_simulation_standard_serial_time_savings_potential_millis,
         build_test_acceleration_pts_simulation_standard_work_unit_failures_predicted_count,
         build_test_acceleration_pts_simulation_standard_work_unit_failures_missed_count,
         build_test_acceleration_pts_simulation_standard_avoidable_test_classes_count,
         build_test_acceleration_pts_simulation_standard_unavoidable_test_classes_count,
         build_test_acceleration_pts_simulation_standard_test_classes_count_selected_due_to_insufficient_data,
         build_test_acceleration_pts_simulation_fast_wall_clock_savings_potential_millis,
         build_test_acceleration_pts_simulation_fast_serial_time_savings_potential_millis,
         build_test_acceleration_pts_simulation_fast_work_unit_failures_predicted_count,
         build_test_acceleration_pts_simulation_fast_work_unit_failures_missed_count,
         build_test_acceleration_pts_simulation_fast_avoidable_test_classes_count,
         build_test_acceleration_pts_simulation_fast_unavoidable_test_classes_count,
         build_test_acceleration_pts_simulation_fast_test_classes_count_selected_due_to_insufficient_data,
         build_test_acceleration_td_usage_status,
         build_test_acceleration_td_wall_clock_savings_millis,
         build_test_acceleration_wall_clock_savings_combined_millis,
         projectname,
         environment,
         testtask.taskpath                                                                                                       work_unit_path,
         testtask.tasktype                                                                                                       work_unit_type,
         testtask.wallclockexecutiontime                                                                                         work_unit_wall_clock_execution_time,
         testtask.serialexecutiontime                                                                                            work_unit_serial_execution_time,
         testtask.tests.failedtestclassescount                                                                                   work_unit_failed_test_classes_count,
         testtask.tests.testclassescount                                                                                         work_unit_test_classes_count,
         testtask.testacceleration.predictivetestselection.usage.status                                                          work_unit_test_acceleration_pts_usage_status,
         testtask.testacceleration.predictivetestselection.usage.wallclocksavings                                                work_unit_test_acceleration_pts_usage_wall_clock_savings_millis,
         testtask.testacceleration.predictivetestselection.usage.serialtimesavings                                               work_unit_test_acceleration_pts_usage_serial_time_savings_millis,
         testTask.testAcceleration.predictiveTestSelection.usage.selectionMode                                                   work_unit_test_acceleration_pts_usage_selection_mode,
         testtask.testacceleration.predictivetestselection.usage.nonselectedtestclassescount                                     work_unit_test_acceleration_pts_usage_non_selected_test_classes_count,
         testtask.testacceleration.predictivetestselection.simulation.conservative.wallclocksavingspotential                     work_unit_test_acceleration_pts_simulation_conservative_wall_clock_savings_potential_millis,
         testtask.testacceleration.predictivetestselection.simulation.conservative.serialtimesavingspotential                    work_unit_test_acceleration_pts_simulation_conservative_serial_time_savings_potential_millis,
         testtask.testacceleration.predictivetestselection.simulation.conservative.avoidabletestclassescount                     work_unit_test_acceleration_pts_simulation_conservative_avoidable_test_classes_count,
         testtask.testacceleration.predictivetestselection.simulation.conservative.unavoidabletestclassescount                   work_unit_test_acceleration_pts_simulation_conservative_unavoidable_test_classes_count,
         testtask.testacceleration.predictivetestselection.simulation.conservative.testclassescountselectedduetoinsufficientdata work_unit_test_acceleration_pts_simulation_conservative_test_classes_count_selected_due_to_insufficient_data,
         testtask.testacceleration.predictivetestselection.simulation.conservative.failedtestclassespredictedcount               work_unit_test_acceleration_pts_simulation_conservative_failed_test_classes_predicted_count,
         testtask.testacceleration.predictivetestselection.simulation.standard.wallclocksavingspotential                         work_unit_test_acceleration_pts_simulation_standard_wall_clock_savings_potential_millis,
         testtask.testacceleration.predictivetestselection.simulation.standard.serialtimesavingspotential                        work_unit_test_acceleration_pts_simulation_standard_serial_time_savings_potential_millis,
         testtask.testacceleration.predictivetestselection.simulation.standard.avoidabletestclassescount                         work_unit_test_acceleration_pts_simulation_standard_avoidable_test_classes_count,
         testtask.testacceleration.predictivetestselection.simulation.standard.unavoidabletestclassescount                       work_unit_test_acceleration_pts_simulation_standard_unavoidable_test_classes_count,
         testtask.testacceleration.predictivetestselection.simulation.standard.testclassescountselectedduetoinsufficientdata     work_unit_test_acceleration_pts_simulation_standard_test_classes_count_selected_due_to_insufficient_data,
         testtask.testacceleration.predictivetestselection.simulation.standard.failedtestclassespredictedcount                   work_unit_test_acceleration_pts_simulation_standard_failed_test_classes_predicted_count,
         testtask.testacceleration.predictivetestselection.simulation.fast.wallclocksavingspotential                             work_unit_test_acceleration_pts_simulation_fast_wall_clock_savings_potential_millis,
         testtask.testacceleration.predictivetestselection.simulation.fast.serialtimesavingspotential                            work_unit_test_acceleration_pts_simulation_fast_serial_time_savings_potential_millis,
         testtask.testacceleration.predictivetestselection.simulation.fast.avoidabletestclassescount                             work_unit_test_acceleration_pts_simulation_fast_avoidable_test_classes_count,
         testtask.testacceleration.predictivetestselection.simulation.fast.unavoidabletestclassescount                           work_unit_test_acceleration_pts_simulation_fast_unavoidable_test_classes_count,
         testtask.testacceleration.predictivetestselection.simulation.fast.testclassescountselectedduetoinsufficientdata         work_unit_test_acceleration_pts_simulation_fast_test_classes_count_selected_due_to_insufficient_data,
         testtask.testacceleration.predictivetestselection.simulation.fast.failedtestclassespredictedcount                       work_unit_test_acceleration_pts_simulation_fast_failed_test_classes_predicted_count,
         testtask.testacceleration.testdistribution.usagestatus                                                                  work_unit_test_acceleration_td_usage_status,
         testtask.testacceleration.testdistribution.wallclocksavings                                                             work_unit_test_acceleration_td_wall_clock_savings_millis,
         testtask.testacceleration.testdistribution.remotetestclassescount                                                       work_unit_test_acceleration_td_remote_test_classes_count,
         testtask.testacceleration.wallclocksavings                                                                              work_unit_test_acceleration_wall_clock_savings_combined_millis,
         build_start_date,
         batchid
  FROM (gradle_builds CROSS JOIN UNNEST(testtasks) AS t(testtask))
  WHERE (projectname IS NOT NULL)

  UNION ALL

  SELECT build_id,
         build_start_time,
         build_duration_millis,
         build_requested_tasks_or_goals,
         build_tool,
         build_test_classes_count,
         build_serial_test_work_units_execution_time,
         build_test_acceleration_pts_usage_status,
         build_test_acceleration_pts_usage_wall_clock_savings_millis,
         build_test_acceleration_pts_usage_serial_time_savings_millis,
         build_test_acceleration_pts_usage_selection_mode,
         build_test_acceleration_pts_simulation_conservative_wall_clock_savings_potential_millis,
         build_test_acceleration_pts_simulation_conservative_serial_time_savings_potential_millis,
         build_test_acceleration_pts_simulation_conservative_work_unit_failures_predicted_count,
         build_test_acceleration_pts_simulation_conservative_work_unit_failures_missed_count,
         build_test_acceleration_pts_simulation_conservative_avoidable_test_classes_count,
         build_test_acceleration_pts_simulation_conservative_unavoidable_test_classes_count,
         build_test_acceleration_pts_simulation_conservative_test_classes_count_selected_due_to_insufficient_data,
         build_test_acceleration_pts_simulation_standard_wall_clock_savings_potential_millis,
         build_test_acceleration_pts_simulation_standard_serial_time_savings_potential_millis,
         build_test_acceleration_pts_simulation_standard_work_unit_failures_predicted_count,
         build_test_acceleration_pts_simulation_standard_work_unit_failures_missed_count,
         build_test_acceleration_pts_simulation_standard_avoidable_test_classes_count,
         build_test_acceleration_pts_simulation_standard_unavoidable_test_classes_count,
         build_test_acceleration_pts_simulation_standard_test_classes_count_selected_due_to_insufficient_data,
         build_test_acceleration_pts_simulation_fast_wall_clock_savings_potential_millis,
         build_test_acceleration_pts_simulation_fast_serial_time_savings_potential_millis,
         build_test_acceleration_pts_simulation_fast_work_unit_failures_predicted_count,
         build_test_acceleration_pts_simulation_fast_work_unit_failures_missed_count,
         build_test_acceleration_pts_simulation_fast_avoidable_test_classes_count,
         build_test_acceleration_pts_simulation_fast_unavoidable_test_classes_count,
         build_test_acceleration_pts_simulation_fast_test_classes_count_selected_due_to_insufficient_data,
         build_test_acceleration_td_usage_status,
         build_test_acceleration_td_wall_clock_savings_millis,
         build_test_acceleration_wall_clock_savings_combined_millis,
         projectname,
         environment,
         testgoal.goalpath                                                                                                       work_unit_path,
         testgoal.goaltype                                                                                                       work_unit_type,
         testgoal.wallclockexecutiontime                                                                                         work_unit_wall_clock_execution_time,
         testgoal.serialexecutiontime                                                                                            work_unit_serial_execution_time,
         testgoal.tests.failedtestclassescount                                                                                   work_unit_failed_test_classes_count,
         testgoal.tests.testclassescount                                                                                         work_unit_test_classes_count,
         testgoal.testacceleration.predictivetestselection.usage.status                                                          work_unit_test_acceleration_pts_usage_status,
         testgoal.testacceleration.predictivetestselection.usage.wallclocksavings                                                work_unit_test_acceleration_pts_usage_wall_clock_savings_millis,
         testgoal.testacceleration.predictivetestselection.usage.serialtimesavings                                               work_unit_test_acceleration_pts_usage_serial_time_savings_millis,
         testGoal.testAcceleration.predictiveTestSelection.usage.selectionMode                                                   work_unit_test_acceleration_pts_usage_selection_mode,
         testgoal.testacceleration.predictivetestselection.usage.nonselectedtestclassescount                                     work_unit_test_acceleration_pts_usage_non_selected_test_classes_count,
         testgoal.testacceleration.predictivetestselection.simulation.conservative.wallclocksavingspotential                     work_unit_test_acceleration_pts_simulation_conservative_wall_clock_savings_potential_millis,
         testgoal.testacceleration.predictivetestselection.simulation.conservative.serialtimesavingspotential                    work_unit_test_acceleration_pts_simulation_conservative_serial_time_savings_potential_millis,
         testgoal.testacceleration.predictivetestselection.simulation.conservative.avoidabletestclassescount                     work_unit_test_acceleration_pts_simulation_conservative_avoidable_test_classes_count,
         testgoal.testacceleration.predictivetestselection.simulation.conservative.unavoidabletestclassescount                   work_unit_test_acceleration_pts_simulation_conservative_unavoidable_test_classes_count,
         testgoal.testacceleration.predictivetestselection.simulation.conservative.testclassescountselectedduetoinsufficientdata work_unit_test_acceleration_pts_simulation_conservative_test_classes_count_selected_due_to_insufficient_data,
         testgoal.testacceleration.predictivetestselection.simulation.conservative.failedtestclassespredictedcount               work_unit_test_acceleration_pts_simulation_conservative_failed_test_classes_predicted_count,
         testgoal.testacceleration.predictivetestselection.simulation.standard.wallclocksavingspotential                         work_unit_test_acceleration_pts_simulation_standard_wall_clock_savings_potential_millis,
         testgoal.testacceleration.predictivetestselection.simulation.standard.serialtimesavingspotential                        work_unit_test_acceleration_pts_simulation_standard_serial_time_savings_potential_millis,
         testgoal.testacceleration.predictivetestselection.simulation.standard.avoidabletestclassescount                         work_unit_test_acceleration_pts_simulation_standard_avoidable_test_classes_count,
         testgoal.testacceleration.predictivetestselection.simulation.standard.unavoidabletestclassescount                       work_unit_test_acceleration_pts_simulation_standard_unavoidable_test_classes_count,
         testgoal.testacceleration.predictivetestselection.simulation.standard.testclassescountselectedduetoinsufficientdata     work_unit_test_acceleration_pts_simulation_standard_test_classes_count_selected_due_to_insufficient_data,
         testgoal.testacceleration.predictivetestselection.simulation.standard.failedtestclassespredictedcount                   work_unit_test_acceleration_pts_simulation_standard_failed_test_classes_predicted_count,
         testgoal.testacceleration.predictivetestselection.simulation.fast.wallclocksavingspotential                             work_unit_test_acceleration_pts_simulation_fast_wall_clock_savings_potential_millis,
         testgoal.testacceleration.predictivetestselection.simulation.fast.serialtimesavingspotential                            work_unit_test_acceleration_pts_simulation_fast_serial_time_savings_potential_millis,
         testgoal.testacceleration.predictivetestselection.simulation.fast.avoidabletestclassescount                             work_unit_test_acceleration_pts_simulation_fast_avoidable_test_classes_count,
         testgoal.testacceleration.predictivetestselection.simulation.fast.unavoidabletestclassescount                           work_unit_test_acceleration_pts_simulation_fast_unavoidable_test_classes_count,
         testgoal.testacceleration.predictivetestselection.simulation.fast.testclassescountselectedduetoinsufficientdata         work_unit_test_acceleration_pts_simulation_fast_test_classes_count_selected_due_to_insufficient_data,
         testgoal.testacceleration.predictivetestselection.simulation.fast.failedtestclassespredictedcount                       work_unit_test_acceleration_pts_simulation_fast_failed_test_classes_predicted_count,
         testgoal.testacceleration.testdistribution.usagestatus                                                                  work_unit_test_acceleration_td_usage_status,
         testgoal.testacceleration.testdistribution.wallclocksavings                                                             work_unit_test_acceleration_td_wall_clock_savings_millis,
         testgoal.testacceleration.testdistribution.remotetestclassescount                                                       work_unit_test_acceleration_td_remote_test_classes_count,
         testgoal.testacceleration.wallclocksavings                                                                              work_unit_test_acceleration_wall_clock_savings_combined_millis,
         build_start_date,
         batchid
  FROM (
    maven_builds CROSS JOIN UNNEST(testgoals) AS t(testgoal))
  WHERE (projectname IS NOT NULL)