-- Create the new schema
CREATE EXTERNAL TABLE `plugin_summary`
(
`build_id` string,
`plugin_id` string,
`version` string,
`modules` array<string>,
`projectname` string,
`build_tool` string,
`build_duration_millis` bigint,
`tags` array<string>,
`environment` string)
PARTITIONED BY (`build_start_date` date, `batchid` bigint)
ROW FORMAT SERDE 'org.apache.hadoop.hive.ql.io.orc.OrcSerde'
STORED AS
       INPUTFORMAT 'org.apache.hadoop.hive.ql.io.orc.OrcInputFormat'
       OUTPUTFORMAT 'org.apache.hadoop.hive.ql.io.orc.OrcOutputFormat'
LOCATION '${s3.path}/tables/plugin_summary/'
TBLPROPERTIES ( 'develocity.reporting.partition.date.key'='build_start_date', 'develocity.reporting.population.order'='1', 'develocity.reporting.source'='internal_plugin_summary')
