-- Create the new schema
CREATE EXTERNAL TABLE `internal_build`(
    `type` string,
    `id` string,
    `buildtoolversion` string,
    `buildagentversion` string,
    `modelversion` struct<year:int,`string`:string,patch:int,release:int>,
    `buildstarttime` date,
    `gradleattributes` struct<id:string,tags:array<string>,`values`:array<struct<name:string,value:string>>,links:array<struct<label:string,url:string>>,buildstarttime:bigint,buildduration:bigint,gradleversion:string,pluginversion:string,rootprojectname:string,requestedtasks:array<string>,hasfailed:boolean,hasverificationfailure:boolean,buildoptions:struct<buildcacheenabled:boolean,continuousbuildenabled:boolean,daemonenabled:boolean,dryrunenabled:boolean,excludedtasks:array<string>,offlinemodeenabled:boolean,reruntasksenabled:boolean,configurationcacheenabled:boolean,configurationondemandenabled:boolean,continueonfailureenabled:boolean,filesystemwatchingenabled:boolean,maxnumberofgradleworkers:int,parallelprojectexecutionenabled:boolean,refreshdependenciesenabled:boolean>,environment:struct<username:string,operatingsystem:string,numberofcpucores:int,jreversion:string,jvmversion:string,jvmmaxmemoryheapsize:bigint,jvmcharset:string,jvmlocale:string,publichostname:string,localhostname:string,localipaddresses:array<string>>,hasnonverificationfailure:boolean,gradleenterprisesettings:struct<backgroundpublicationenabled:boolean,buildoutputcapturingenabled:boolean,taskinputsfilecapturingenabled:boolean,testoutputcapturingenabled:boolean>,develocitysettings:struct<backgroundpublicationenabled:boolean,buildoutputcapturingenabled:boolean,taskinputsfilecapturingenabled:boolean,testoutputcapturingenabled:boolean>>,
    `mavenattributes` struct<id:string,tags:array<string>,`values`:array<struct<name:string,value:string>>,links:array<struct<label:string,url:string>>,buildstarttime:bigint,buildduration:bigint,hasfailed:boolean,hasverificationfailure:boolean,buildoptions:struct<batchmodeenabled:boolean,debugenabled:boolean,errorsenabled:boolean,failatendenabled:boolean,failfastenabled:boolean,failneverenabled:boolean,laxchecksumsenabled:boolean,maxnumberofthreads:int,nonrecursiveenabled:boolean,rerungoals:boolean,quietenabled:boolean,strictchecksumsenabled:boolean,updatesnapshotsenabled:boolean,offlinemodeenabled:boolean,nosnapshotsupdatesenabled:boolean,daemonenabled:boolean>,environment:struct<username:string,operatingsystem:string,numberofcpucores:int,jreversion:string,jvmversion:string,jvmmaxmemoryheapsize:bigint,jvmcharset:string,jvmlocale:string,publichostname:string,localhostname:string,localipaddresses:array<string>>,mavenversion:string,extensionversion:string,toplevelprojectname:string,requestedgoals:array<string>,hasnonverificationfailure:boolean,gradleenterprisesettings:struct<backgroundpublicationenabled:boolean,buildoutputcapturingenabled:boolean,testoutputcapturingenabled:boolean,goalinputsfilecapturingenabled:boolean>,develocitysettings:struct<backgroundpublicationenabled:boolean,buildoutputcapturingenabled:boolean,testoutputcapturingenabled:boolean,goalinputsfilecapturingenabled:boolean>>,
    `gradlebuildcacheperformance` struct<id:string,effectivetaskexecutiontime:bigint,effectiveworkunitexecutiontime:bigint,serialworkunitexecutiontime:bigint,taskfingerprintingsummary:struct<count:int,serialduration:bigint>,workunitfingerprintingsummary:struct<count:int,serialduration:bigint>,taskavoidancesavingssummary:struct<uptodate:bigint,localbuildcache:bigint,remotebuildcache:bigint,total:bigint,ratio:double>,workunitavoidancesavingssummary:struct<uptodate:bigint,localbuildcache:bigint,remotebuildcache:bigint,total:bigint,ratio:double>,buildtime:bigint,serialtaskexecutiontime:bigint,serializationfactor:double,taskexecution:array<struct<duration:bigint,cachekey:string,cacheartifactrejectedreason:string,fingerprintingduration:bigint,taskpath:string,tasktype:string,avoidanceoutcome:string,avoidancesavings:bigint,noncacheabilitycategory:string,noncacheabilityreason:string,skipreasonmessage:string,cacheartifactsize:bigint>>,avoidancesavingssummary:struct<uptodate:bigint,localbuildcache:bigint,remotebuildcache:bigint,total:bigint,ratio:double>,buildcaches:struct<local:struct<isenabled:boolean,ispushenabled:boolean,isdisabledduetoerror:boolean,directory:string>,overhead:struct<uploading:bigint,downloading:bigint,unpacking:bigint,packing:bigint>,remote:struct<type:string,classname:string,isenabled:boolean,ispushenabled:boolean,isdisabledduetoerror:boolean,url:string>>>,
    `mavenbuildcacheperformance` struct<id:string,effectiveprojectexecutiontime:bigint,serialprojectexecutiontime:bigint,goalfingerprintingsummary:struct<count:int,serialduration:bigint>,buildtime:bigint,serializationfactor:double,avoidancesavingssummary:struct<localbuildcache:bigint,remotebuildcache:bigint,total:bigint,ratio:double>,buildcaches:struct<local:struct<isenabled:boolean,ispushenabled:boolean,isdisabledduetoerror:boolean,directory:string>,overhead:struct<uploading:bigint,downloading:bigint,unpacking:bigint,packing:bigint>,remote:struct<isenabled:boolean,ispushenabled:boolean,isdisabledduetoerror:boolean,url:string>>,goalexecution:array<struct<duration:bigint,cachekey:string,cacheartifactrejectedreason:string,fingerprintingduration:bigint,avoidanceoutcome:string,avoidancesavings:bigint,noncacheabilitycategory:string,noncacheabilityreason:string,cacheartifactsize:bigint,goalname:string,mojotype:string,goalexecutionid:string,goalprojectname:string>>>,
    `gradleprojects` array<struct<name:string,parent:int,path:string>>,
    `mavenmodules` array<struct<name:string,parent:int,version:string,groupid:string,artifactid:string>>,
    `gradledeprecations` struct<deprecations:array<struct<removaldetails:string,documentationurl:string,summary:string,advice:string,usages:array<struct<owner:struct<location:string,type:string>,contextualadvice:string>>>>>,
    `gradlenetworkactivity` struct<serialnetworkrequesttime:bigint,wallclocknetworkrequesttime:bigint,networkrequestcount:bigint,filedownloadsize:bigint,filedownloadcount:bigint>,
    `mavendependencyresolution` struct<serialdependencyresolutiontime:bigint,serialnetworkrequesttime:bigint,wallclocknetworkrequesttime:bigint,networkrequestcount:bigint,filedownloadsize:bigint,filedownloadcount:bigint>,
    `gradleplugins` struct<plugins:array<struct<id:string,classname:string,version:string,projects:array<string>>>>,
    `mavenplugins` struct<plugins:array<struct<name:string,groupid:string,artifactid:string,version:string,modules:array<string>,executedgoals:array<string>,requiredmavenversion:array<string>>>>,
    `gradleresourceusage` struct<total:struct<allprocessescpu:struct<average:bigint,max:bigint,p5:bigint,p25:bigint,p75:bigint,p95:bigint,median:bigint>,buildprocesscpu:struct<average:bigint,max:bigint,p5:bigint,p25:bigint,p75:bigint,p95:bigint,median:bigint>,allprocessesmemory:struct<average:bigint,max:bigint,p5:bigint,p25:bigint,p75:bigint,p95:bigint,median:bigint>,buildprocessmemory:struct<average:bigint,max:bigint,p5:bigint,p25:bigint,p75:bigint,p95:bigint,median:bigint>,diskreadspeed:struct<average:bigint,max:bigint,p5:bigint,p25:bigint,p75:bigint,p95:bigint,median:bigint>,diskwritespeed:struct<average:bigint,max:bigint,p5:bigint,p25:bigint,p75:bigint,p95:bigint,median:bigint>,networkuploadspeed:struct<average:bigint,max:bigint,p5:bigint,p25:bigint,p75:bigint,p95:bigint,median:bigint>,buildchildprocessescpu:struct<average:bigint,max:bigint,p5:bigint,p25:bigint,p75:bigint,p95:bigint,median:bigint>,buildchildprocessesmemory:struct<average:bigint,max:bigint,p5:bigint,p25:bigint,p75:bigint,p95:bigint,median:bigint>,networkdownloadspeed:struct<average:bigint,max:bigint,p5:bigint,p25:bigint,p75:bigint,p95:bigint,median:bigint>>,totalmemory:bigint,execution:struct<allprocessescpu:struct<average:bigint,max:bigint,p5:bigint,p25:bigint,p75:bigint,p95:bigint,median:bigint>,buildprocesscpu:struct<average:bigint,max:bigint,p5:bigint,p25:bigint,p75:bigint,p95:bigint,median:bigint>,allprocessesmemory:struct<average:bigint,max:bigint,p5:bigint,p25:bigint,p75:bigint,p95:bigint,median:bigint>,buildprocessmemory:struct<average:bigint,max:bigint,p5:bigint,p25:bigint,p75:bigint,p95:bigint,median:bigint>,diskreadspeed:struct<average:bigint,max:bigint,p5:bigint,p25:bigint,p75:bigint,p95:bigint,median:bigint>,diskwritespeed:struct<average:bigint,max:bigint,p5:bigint,p25:bigint,p75:bigint,p95:bigint,median:bigint>,networkuploadspeed:struct<average:bigint,max:bigint,p5:bigint,p25:bigint,p75:bigint,p95:bigint,median:bigint>,buildchildprocessescpu:struct<average:bigint,max:bigint,p5:bigint,p25:bigint,p75:bigint,p95:bigint,median:bigint>,buildchildprocessesmemory:struct<average:bigint,max:bigint,p5:bigint,p25:bigint,p75:bigint,p95:bigint,median:bigint>,networkdownloadspeed:struct<average:bigint,max:bigint,p5:bigint,p25:bigint,p75:bigint,p95:bigint,median:bigint>>,nonexecution:struct<allprocessescpu:struct<average:bigint,max:bigint,p5:bigint,p25:bigint,p75:bigint,p95:bigint,median:bigint>,buildprocesscpu:struct<average:bigint,max:bigint,p5:bigint,p25:bigint,p75:bigint,p95:bigint,median:bigint>,allprocessesmemory:struct<average:bigint,max:bigint,p5:bigint,p25:bigint,p75:bigint,p95:bigint,median:bigint>,buildprocessmemory:struct<average:bigint,max:bigint,p5:bigint,p25:bigint,p75:bigint,p95:bigint,median:bigint>,diskreadspeed:struct<average:bigint,max:bigint,p5:bigint,p25:bigint,p75:bigint,p95:bigint,median:bigint>,diskwritespeed:struct<average:bigint,max:bigint,p5:bigint,p25:bigint,p75:bigint,p95:bigint,median:bigint>,networkuploadspeed:struct<average:bigint,max:bigint,p5:bigint,p25:bigint,p75:bigint,p95:bigint,median:bigint>,buildchildprocessescpu:struct<average:bigint,max:bigint,p5:bigint,p25:bigint,p75:bigint,p95:bigint,median:bigint>,buildchildprocessesmemory:struct<average:bigint,max:bigint,p5:bigint,p25:bigint,p75:bigint,p95:bigint,median:bigint>,networkdownloadspeed:struct<average:bigint,max:bigint,p5:bigint,p25:bigint,p75:bigint,p95:bigint,median:bigint>>>,
    `mavenresourceusage` struct<total:struct<allprocessescpu:struct<average:bigint,max:bigint,p5:bigint,p25:bigint,p75:bigint,p95:bigint,median:bigint>,buildprocesscpu:struct<average:bigint,max:bigint,p5:bigint,p25:bigint,p75:bigint,p95:bigint,median:bigint>,allprocessesmemory:struct<average:bigint,max:bigint,p5:bigint,p25:bigint,p75:bigint,p95:bigint,median:bigint>,buildprocessmemory:struct<average:bigint,max:bigint,p5:bigint,p25:bigint,p75:bigint,p95:bigint,median:bigint>,diskreadspeed:struct<average:bigint,max:bigint,p5:bigint,p25:bigint,p75:bigint,p95:bigint,median:bigint>,diskwritespeed:struct<average:bigint,max:bigint,p5:bigint,p25:bigint,p75:bigint,p95:bigint,median:bigint>,networkuploadspeed:struct<average:bigint,max:bigint,p5:bigint,p25:bigint,p75:bigint,p95:bigint,median:bigint>,buildchildprocessescpu:struct<average:bigint,max:bigint,p5:bigint,p25:bigint,p75:bigint,p95:bigint,median:bigint>,buildchildprocessesmemory:struct<average:bigint,max:bigint,p5:bigint,p25:bigint,p75:bigint,p95:bigint,median:bigint>,networkdownloadspeed:struct<average:bigint,max:bigint,p5:bigint,p25:bigint,p75:bigint,p95:bigint,median:bigint>>,totalmemory:bigint,execution:struct<allprocessescpu:struct<average:bigint,max:bigint,p5:bigint,p25:bigint,p75:bigint,p95:bigint,median:bigint>,buildprocesscpu:struct<average:bigint,max:bigint,p5:bigint,p25:bigint,p75:bigint,p95:bigint,median:bigint>,allprocessesmemory:struct<average:bigint,max:bigint,p5:bigint,p25:bigint,p75:bigint,p95:bigint,median:bigint>,buildprocessmemory:struct<average:bigint,max:bigint,p5:bigint,p25:bigint,p75:bigint,p95:bigint,median:bigint>,diskreadspeed:struct<average:bigint,max:bigint,p5:bigint,p25:bigint,p75:bigint,p95:bigint,median:bigint>,diskwritespeed:struct<average:bigint,max:bigint,p5:bigint,p25:bigint,p75:bigint,p95:bigint,median:bigint>,networkuploadspeed:struct<average:bigint,max:bigint,p5:bigint,p25:bigint,p75:bigint,p95:bigint,median:bigint>,buildchildprocessescpu:struct<average:bigint,max:bigint,p5:bigint,p25:bigint,p75:bigint,p95:bigint,median:bigint>,buildchildprocessesmemory:struct<average:bigint,max:bigint,p5:bigint,p25:bigint,p75:bigint,p95:bigint,median:bigint>,networkdownloadspeed:struct<average:bigint,max:bigint,p5:bigint,p25:bigint,p75:bigint,p95:bigint,median:bigint>>,nonexecution:struct<allprocessescpu:struct<average:bigint,max:bigint,p5:bigint,p25:bigint,p75:bigint,p95:bigint,median:bigint>,buildprocesscpu:struct<average:bigint,max:bigint,p5:bigint,p25:bigint,p75:bigint,p95:bigint,median:bigint>,allprocessesmemory:struct<average:bigint,max:bigint,p5:bigint,p25:bigint,p75:bigint,p95:bigint,median:bigint>,buildprocessmemory:struct<average:bigint,max:bigint,p5:bigint,p25:bigint,p75:bigint,p95:bigint,median:bigint>,diskreadspeed:struct<average:bigint,max:bigint,p5:bigint,p25:bigint,p75:bigint,p95:bigint,median:bigint>,diskwritespeed:struct<average:bigint,max:bigint,p5:bigint,p25:bigint,p75:bigint,p95:bigint,median:bigint>,networkuploadspeed:struct<average:bigint,max:bigint,p5:bigint,p25:bigint,p75:bigint,p95:bigint,median:bigint>,buildchildprocessescpu:struct<average:bigint,max:bigint,p5:bigint,p25:bigint,p75:bigint,p95:bigint,median:bigint>,buildchildprocessesmemory:struct<average:bigint,max:bigint,p5:bigint,p25:bigint,p75:bigint,p95:bigint,median:bigint>,networkdownloadspeed:struct<average:bigint,max:bigint,p5:bigint,p25:bigint,p75:bigint,p95:bigint,median:bigint>>>,
    `gradlebuildprofileoverview` struct<breakdown:struct<endofbuild:bigint,total:bigint,execution:bigint,initialization:bigint,configuration:bigint>,memoryusage:struct<memorypools:array<struct<name:string,peakmemory:bigint,maxmemory:bigint>>,totalgarbagecollectiontime:bigint>>,
    `mavenbuildprofileoverview` struct<breakdown:struct<total:bigint,execution:struct<endofbuild:bigint,total:bigint,goalexecution:bigint>,initializationanddiscovery:struct<total:bigint,settings:bigint,toolchains:bigint,other:bigint,projectdiscovery:bigint>>,memoryusage:struct<memorypools:array<struct<name:string,peakmemory:bigint,maxmemory:bigint>>,totalgarbagecollectiontime:bigint>>,
    `gradleartifacttransformexecutions` struct<artifacttransformexecutions:array<struct<duration:bigint,cachekey:string,outcome:string,transformactiontype:string,inputartifactname:string,changedattributes:array<struct<name:string,`from`:string,`to`:string>>,avoidanceoutcome:string,avoidancesavings:bigint,skipreasonmessage:string,cacheartifactsize:bigint,artifacttransformexecutionname:string,fingerprintingduration:bigint,noncacheabilitycategory:string,noncacheabilityreason:string,cacheartifactrejectedreason:string>>>,
    `gradleconfigurationcache` struct<result:struct<entrysize:bigint,store:struct<duration:bigint,hasfailed:boolean>,load:struct<duration:bigint,hasfailed:boolean>,missreasons:array<string>,outcome:string,dependencyresolutionduration:bigint,checkfingerprintduration:bigint>>,
    `gradledependencies` struct<dependencies:array<struct<name:string,type:string,scheme:string,version:string,namespace:string,qualifiers:map<string,string>,subpath:string,purl:string>>>,
    `mavendependencies` struct<dependencies:array<struct<name:string,type:string,scheme:string,version:string,namespace:string,qualifiers:map<string,string>,subpath:string,purl:string>>>,
    `gradletestperformance` struct<`serialtesttasksexecutiontime`:bigint,`testacceleration`:struct<`predictivetestselection`:struct<`usage`:struct<`wallclocksavings`:bigint,`selectionmode`:string,`serialtimesavings`:bigint,`status`:string>,`simulation`:struct<`conservative`:struct<`workunitfailurespredictedcount`:bigint,`wallclocksavingspotential`:bigint,`serialtimesavingspotential`:bigint,`workunitfailuresmissedcount`:bigint,`avoidabletestclassescount`:bigint,`unavoidabletestclassescount`:bigint,`testclassescountselectedduetoinsufficientdata`:bigint>,`standard`:struct<`workunitfailurespredictedcount`:bigint,`wallclocksavingspotential`:bigint,`serialtimesavingspotential`:bigint,`workunitfailuresmissedcount`:bigint,`avoidabletestclassescount`:bigint,`unavoidabletestclassescount`:bigint,`testclassescountselectedduetoinsufficientdata`:bigint>,`fast`:struct<`workunitfailurespredictedcount`:bigint,`wallclocksavingspotential`:bigint,`serialtimesavingspotential`:bigint,`workunitfailuresmissedcount`:bigint,`avoidabletestclassescount`:bigint,`unavoidabletestclassescount`:bigint,`testclassescountselectedduetoinsufficientdata`:bigint>>>,`testdistribution`:struct<`wallclocksavings`:bigint,`usagestatus`:string>,`wallclocksavings`:bigint>,`tests`:struct<`testclassescount`:int>,`testtasks`:array<struct<`wallclockexecutiontime`:bigint,`serialexecutiontime`:bigint,`testacceleration`:struct<`predictivetestselection`:struct<`usage`:struct<`nonselectedtestclassescount`:int,`wallclocksavings`:bigint,`selectionmode`:string,`serialtimesavings`:bigint,`status`:string>,`simulation`:struct<`conservative`:struct<`failedtestclassespredictedcount`:bigint,`wallclocksavingspotential`:bigint,`serialtimesavingspotential`:bigint,`avoidabletestclassescount`:bigint,`unavoidabletestclassescount`:bigint,`testclassescountselectedduetoinsufficientdata`:bigint>,`standard`:struct<`failedtestclassespredictedcount`:bigint,`wallclocksavingspotential`:bigint,`serialtimesavingspotential`:bigint,`avoidabletestclassescount`:bigint,`unavoidabletestclassescount`:bigint,`testclassescountselectedduetoinsufficientdata`:bigint>,`fast`:struct<`failedtestclassespredictedcount`:bigint,`wallclocksavingspotential`:bigint,`serialtimesavingspotential`:bigint,`avoidabletestclassescount`:bigint,`unavoidabletestclassescount`:bigint,`testclassescountselectedduetoinsufficientdata`:bigint>>>,`testdistribution`:struct<`remotetestclassescount`:int,`wallclocksavings`:bigint,`usagestatus`:string>,`wallclocksavings`:bigint>,`tests`:struct<`failedtestclassescount`:int,`testclassescount`:int>,`taskpath`:string,`tasktype`:string>>>,
    `maventestperformance` struct<`serialtestgoalsexecutiontime`:bigint,`testacceleration`:struct<`predictivetestselection`:struct<`usage`:struct<`wallclocksavings`:bigint,`selectionmode`:string,`serialtimesavings`:bigint,`status`:string>,`simulation`:struct<`conservative`:struct<`workunitfailurespredictedcount`:bigint,`wallclocksavingspotential`:bigint,`serialtimesavingspotential`:bigint,`workunitfailuresmissedcount`:bigint,`avoidabletestclassescount`:bigint,`unavoidabletestclassescount`:bigint,`testclassescountselectedduetoinsufficientdata`:bigint>,`standard`:struct<`workunitfailurespredictedcount`:bigint,`wallclocksavingspotential`:bigint,`serialtimesavingspotential`:bigint,`workunitfailuresmissedcount`:bigint,`avoidabletestclassescount`:bigint,`unavoidabletestclassescount`:bigint,`testclassescountselectedduetoinsufficientdata`:bigint>,`fast`:struct<`workunitfailurespredictedcount`:bigint,`wallclocksavingspotential`:bigint,`serialtimesavingspotential`:bigint,`workunitfailuresmissedcount`:bigint,`avoidabletestclassescount`:bigint,`unavoidabletestclassescount`:bigint,`testclassescountselectedduetoinsufficientdata`:bigint>>>,`testdistribution`:struct<`wallclocksavings`:bigint,`usagestatus`:string>,`wallclocksavings`:bigint>,`tests`:struct<`testclassescount`:int>,`testgoals`:array<struct<`wallclockexecutiontime`:bigint,`serialexecutiontime`:bigint,`testacceleration`:struct<`predictivetestselection`:struct<`usage`:struct<`nonselectedtestclassescount`:int,`wallclocksavings`:bigint,`selectionmode`:string,`serialtimesavings`:bigint,`status`:string>,`simulation`:struct<`conservative`:struct<`failedtestclassespredictedcount`:bigint,`wallclocksavingspotential`:bigint,`serialtimesavingspotential`:bigint,`avoidabletestclassescount`:bigint,`unavoidabletestclassescount`:bigint,`testclassescountselectedduetoinsufficientdata`:bigint>,`standard`:struct<`failedtestclassespredictedcount`:bigint,`wallclocksavingspotential`:bigint,`serialtimesavingspotential`:bigint,`avoidabletestclassescount`:bigint,`unavoidabletestclassescount`:bigint,`testclassescountselectedduetoinsufficientdata`:bigint>,`fast`:struct<`failedtestclassespredictedcount`:bigint,`wallclocksavingspotential`:bigint,`serialtimesavingspotential`:bigint,`avoidabletestclassescount`:bigint,`unavoidabletestclassescount`:bigint,`testclassescountselectedduetoinsufficientdata`:bigint>>>,`testdistribution`:struct<`remotetestclassescount`:int,`wallclocksavings`:bigint,`usagestatus`:string>,`wallclocksavings`:bigint>,`tests`:struct<`failedtestclassescount`:int,`testclassescount`:int>,`goalpath`:string,`goaltype`:string>>>,
    `bazelcriticalpath` struct<actions:array<struct<name:string,duration:bigint,category:string>>>,
    `bazelattributes` struct<id:string,host:string,modulename:string,buildstarttime:bigint,buildduration:bigint,invocationid:string,bazelversion:string,targetpatterns:array<string>,user:string,hasfailed:boolean,tags:array<string>,links:array<struct<url:string,label:string>>,command:string,exitcode:int,values:array<struct<name:string,value:string>>>,
    `npmattributes` struct<packagename:string,id:string,host:string,buildstarttime:bigint,buildduration:bigint,nodejsversion:string,npmagentversion:string,user:string,hasfailed:boolean,tags:array<string>,links:array<struct<url:string,label:string>>,command:struct<command:string,arguments:array<string>>,exitcode:int,values:array<struct<name:string,value:string>>,npmversion:string>,
    `pythonattributes` struct<exception:string,id:string,host:string,buildstarttime:bigint,buildduration:bigint,pythonversion:string,pythonagentversion:string,user:string,hasfailed:boolean,tags:array<string>,links:array<struct<url:string,label:string>>,command:array<string>,exitcode:int,projectname:string,values:array<struct<name:string,value:string>>>,
    `sbtattributes` struct<id:string,buildstarttime:bigint,buildduration:bigint,pluginversion:string,rootprojectname:string,develocitysettings:struct<backgroundpublicationenabled:boolean,resourceusagecapturingenabled:boolean,buildoutputcapturingenabled:boolean>,buildoptions:struct<usecoursierenabled:boolean,turboenabled:boolean,offlinemodeenabled:boolean,semanticdbscalacpluginenabled:boolean,interactivemodeenabled:boolean,parallelexecutionenabled:boolean>,requestedcommands:array<string>,hasfailed:boolean,tags:array<string>,links:array<struct<url:string,label:string>>,environment:struct<operatingsystem:string,numberofcpucores:int,publichostname:string,localhostname:string,localipaddresses:array<string>,username:string,jreversion:string,jvmversion:string,jvmcharset:string,jvmlocale:string,jvmmaxmemoryheapsize:bigint>,sbtversion:string,values:array<struct<name:string,value:string>>,hasverificationfailure:boolean,hasnonverificationfailure:boolean>
)
PARTITIONED BY ( `startdate` date, `batchid` bigint)
ROW FORMAT SERDE 'org.openx.data.jsonserde.JsonSerDe'
WITH
  serdeproperties ('ignore.malformed.json'='true', 'orc.column.index.access'='false')
    STORED AS
       INPUTFORMAT 'org.apache.hadoop.mapred.TextInputFormat'
       OUTPUTFORMAT 'org.apache.hadoop.hive.ql.io.HiveIgnoreKeyTextOutputFormat'
LOCATION '${s3.path}/internal/builds'
TBLPROPERTIES ( 'empty-response-workaround'='true')