CREATE
OR REPLACE VIEW test_performance_summary AS
  WITH gradle_builds AS (SELECT id                                                                                                                                   build_id,
                                startdate                                                                                                                            build_start_date,
                                gradleattributes.buildstarttime                                                                                                      build_start_time,
                                gradleattributes.buildduration                                                                                                       build_duration_millis,
                                ARRAY_JOIN(gradleattributes.requestedtasks, ' ')                                                                                     build_requested_tasks_or_goals,
                                type                                                                                                                                 build_tool,
                                gradletestperformance.tests.testclassescount                                                                                         build_test_classes_count,
                                gradletestperformance.serialTestTasksExecutionTime                                                                                   build_serial_test_work_units_execution_time,
                                gradletestperformance.testAcceleration.predictiveTestSelection.usage.status                                                          build_test_acceleration_pts_usage_status,
                                gradletestperformance.testAcceleration.predictiveTestSelection.usage.wallClockSavings                                                build_test_acceleration_pts_usage_wall_clock_savings_millis,
                                gradletestperformance.testAcceleration.predictiveTestSelection.usage.serialTimeSavings                                               build_test_acceleration_pts_usage_serial_time_savings_millis,
                                gradletestperformance.testAcceleration.predictiveTestSelection.usage.selectionMode                                                   build_test_acceleration_pts_usage_selection_mode,
                                gradletestperformance.testAcceleration.predictiveTestSelection.simulation.conservative.wallClockSavingsPotential                     build_test_acceleration_pts_simulation_conservative_wall_clock_savings_potential_millis,
                                gradletestperformance.testAcceleration.predictiveTestSelection.simulation.conservative.serialTimeSavingsPotential                    build_test_acceleration_pts_simulation_conservative_serial_time_savings_potential_millis,
                                gradletestperformance.testAcceleration.predictiveTestSelection.simulation.conservative.workUnitFailuresPredictedCount                build_test_acceleration_pts_simulation_conservative_work_unit_failures_predicted_count,
                                gradletestperformance.testAcceleration.predictiveTestSelection.simulation.conservative.workUnitFailuresMissedCount                   build_test_acceleration_pts_simulation_conservative_work_unit_failures_missed_count,
                                gradletestperformance.testAcceleration.predictiveTestSelection.simulation.conservative.avoidableTestClassesCount                     build_test_acceleration_pts_simulation_conservative_avoidable_test_classes_count,
                                gradletestperformance.testAcceleration.predictiveTestSelection.simulation.conservative.unavoidableTestClassesCount                   build_test_acceleration_pts_simulation_conservative_unavoidable_test_classes_count,
                                gradletestperformance.testAcceleration.predictiveTestSelection.simulation.conservative.testClassesCountSelectedDueToInsufficientData build_test_acceleration_pts_simulation_conservative_test_classes_count_selected_due_to_insufficient_data,
                                gradletestperformance.testAcceleration.predictiveTestSelection.simulation.standard.wallClockSavingsPotential                         build_test_acceleration_pts_simulation_standard_wall_clock_savings_potential_millis,
                                gradletestperformance.testAcceleration.predictiveTestSelection.simulation.standard.serialTimeSavingsPotential                        build_test_acceleration_pts_simulation_standard_serial_time_savings_potential_millis,
                                gradletestperformance.testAcceleration.predictiveTestSelection.simulation.standard.workUnitFailuresPredictedCount                    build_test_acceleration_pts_simulation_standard_work_unit_failures_predicted_count,
                                gradletestperformance.testAcceleration.predictiveTestSelection.simulation.standard.workUnitFailuresMissedCount                       build_test_acceleration_pts_simulation_standard_work_unit_failures_missed_count,
                                gradletestperformance.testAcceleration.predictiveTestSelection.simulation.standard.avoidableTestClassesCount                         build_test_acceleration_pts_simulation_standard_avoidable_test_classes_count,
                                gradletestperformance.testAcceleration.predictiveTestSelection.simulation.standard.unavoidableTestClassesCount                       build_test_acceleration_pts_simulation_standard_unavoidable_test_classes_count,
                                gradletestperformance.testAcceleration.predictiveTestSelection.simulation.standard.testClassesCountSelectedDueToInsufficientData     build_test_acceleration_pts_simulation_standard_test_classes_count_selected_due_to_insufficient_data,
                                gradletestperformance.testAcceleration.predictiveTestSelection.simulation.fast.wallClockSavingsPotential                             build_test_acceleration_pts_simulation_fast_wall_clock_savings_potential_millis,
                                gradletestperformance.testAcceleration.predictiveTestSelection.simulation.fast.serialTimeSavingsPotential                            build_test_acceleration_pts_simulation_fast_serial_time_savings_potential_millis,
                                gradletestperformance.testAcceleration.predictiveTestSelection.simulation.fast.workUnitFailuresPredictedCount                        build_test_acceleration_pts_simulation_fast_work_unit_failures_predicted_count,
                                gradletestperformance.testAcceleration.predictiveTestSelection.simulation.fast.workUnitFailuresMissedCount                           build_test_acceleration_pts_simulation_fast_work_unit_failures_missed_count,
                                gradletestperformance.testAcceleration.predictiveTestSelection.simulation.fast.avoidableTestClassesCount                             build_test_acceleration_pts_simulation_fast_avoidable_test_classes_count,
                                gradletestperformance.testAcceleration.predictiveTestSelection.simulation.fast.unavoidableTestClassesCount                           build_test_acceleration_pts_simulation_fast_unavoidable_test_classes_count,
                                gradletestperformance.testAcceleration.predictiveTestSelection.simulation.fast.testClassesCountSelectedDueToInsufficientData         build_test_acceleration_pts_simulation_fast_test_classes_count_selected_due_to_insufficient_data,
                                gradletestperformance.testAcceleration.testDistribution.usageStatus                                                                  build_test_acceleration_td_usage_status,
                                gradletestperformance.testAcceleration.testDistribution.wallClockSavings                                                             build_test_acceleration_td_wall_clock_savings_millis,
                                gradletestperformance.testAcceleration.wallClockSavings                                                                              build_test_acceleration_wall_clock_savings_combined_millis,
                                gradleattributes.rootprojectname                                                                                                     projectname,
                                (CASE
                                  WHEN (CONTAINS(build.gradleattributes.tags, 'CI') = true) THEN 'CI'
                                  WHEN (CONTAINS(build.gradleattributes.tags, 'CI') = false) THEN 'Local' END)                                                       environment,
                                gradletestperformance.testTasks                                                                                                      testTasks
                         FROM "develocity-db"."build"
                         WHERE (type = 'gradle')),
       maven_builds AS  (SELECT id                                                                                                                                  build_id,
                                startdate                                                                                                                           build_start_date,
                                mavenattributes.buildstarttime                                                                                                      build_start_time,
                                mavenattributes.buildduration                                                                                                       build_duration_millis,
                                ARRAY_JOIN(mavenattributes.requestedgoals, ' ')                                                                                     build_requested_tasks_or_goals,
                                type                                                                                                                                build_tool,
                                maventestperformance.tests.testclassescount                                                                                         build_test_classes_count,
                                maventestperformance.serialTestGoalsExecutionTime                                                                                   build_serial_test_work_units_execution_time,
                                maventestperformance.testAcceleration.predictiveTestSelection.usage.status                                                          build_test_acceleration_pts_usage_status,
                                maventestperformance.testAcceleration.predictiveTestSelection.usage.wallClockSavings                                                build_test_acceleration_pts_usage_wall_clock_savings_millis,
                                maventestperformance.testAcceleration.predictiveTestSelection.usage.serialTimeSavings                                               build_test_acceleration_pts_usage_serial_time_savings_millis,
                                maventestperformance.testAcceleration.predictiveTestSelection.usage.selectionMode                                                   build_test_acceleration_pts_usage_selection_mode,
                                maventestperformance.testAcceleration.predictiveTestSelection.simulation.conservative.wallClockSavingsPotential                     build_test_acceleration_pts_simulation_conservative_wall_clock_savings_potential_millis,
                                maventestperformance.testAcceleration.predictiveTestSelection.simulation.conservative.serialTimeSavingsPotential                    build_test_acceleration_pts_simulation_conservative_serial_time_savings_potential_millis,
                                maventestperformance.testAcceleration.predictiveTestSelection.simulation.conservative.workUnitFailuresPredictedCount                build_test_acceleration_pts_simulation_conservative_work_unit_failures_predicted_count,
                                maventestperformance.testAcceleration.predictiveTestSelection.simulation.conservative.workUnitFailuresMissedCount                   build_test_acceleration_pts_simulation_conservative_work_unit_failures_missed_count,
                                maventestperformance.testAcceleration.predictiveTestSelection.simulation.conservative.avoidableTestClassesCount                     build_test_acceleration_pts_simulation_conservative_avoidable_test_classes_count,
                                maventestperformance.testAcceleration.predictiveTestSelection.simulation.conservative.unavoidableTestClassesCount                   build_test_acceleration_pts_simulation_conservative_unavoidable_test_classes_count,
                                maventestperformance.testAcceleration.predictiveTestSelection.simulation.conservative.testClassesCountSelectedDueToInsufficientData build_test_acceleration_pts_simulation_conservative_test_classes_count_selected_due_to_insufficient_data,
                                maventestperformance.testAcceleration.predictiveTestSelection.simulation.standard.wallClockSavingsPotential                         build_test_acceleration_pts_simulation_standard_wall_clock_savings_potential_millis,
                                maventestperformance.testAcceleration.predictiveTestSelection.simulation.standard.serialTimeSavingsPotential                        build_test_acceleration_pts_simulation_standard_serial_time_savings_potential_millis,
                                maventestperformance.testAcceleration.predictiveTestSelection.simulation.standard.workUnitFailuresPredictedCount                    build_test_acceleration_pts_simulation_standard_work_unit_failures_predicted_count,
                                maventestperformance.testAcceleration.predictiveTestSelection.simulation.standard.workUnitFailuresMissedCount                       build_test_acceleration_pts_simulation_standard_work_unit_failures_missed_count,
                                maventestperformance.testAcceleration.predictiveTestSelection.simulation.standard.avoidableTestClassesCount                         build_test_acceleration_pts_simulation_standard_avoidable_test_classes_count,
                                maventestperformance.testAcceleration.predictiveTestSelection.simulation.standard.unavoidableTestClassesCount                       build_test_acceleration_pts_simulation_standard_unavoidable_test_classes_count,
                                maventestperformance.testAcceleration.predictiveTestSelection.simulation.standard.testClassesCountSelectedDueToInsufficientData     build_test_acceleration_pts_simulation_standard_test_classes_count_selected_due_to_insufficient_data,
                                maventestperformance.testAcceleration.predictiveTestSelection.simulation.fast.wallClockSavingsPotential                             build_test_acceleration_pts_simulation_fast_wall_clock_savings_potential_millis,
                                maventestperformance.testAcceleration.predictiveTestSelection.simulation.fast.serialTimeSavingsPotential                            build_test_acceleration_pts_simulation_fast_serial_time_savings_potential_millis,
                                maventestperformance.testAcceleration.predictiveTestSelection.simulation.fast.workUnitFailuresPredictedCount                        build_test_acceleration_pts_simulation_fast_work_unit_failures_predicted_count,
                                maventestperformance.testAcceleration.predictiveTestSelection.simulation.fast.workUnitFailuresMissedCount                           build_test_acceleration_pts_simulation_fast_work_unit_failures_missed_count,
                                maventestperformance.testAcceleration.predictiveTestSelection.simulation.fast.avoidableTestClassesCount                             build_test_acceleration_pts_simulation_fast_avoidable_test_classes_count,
                                maventestperformance.testAcceleration.predictiveTestSelection.simulation.fast.unavoidableTestClassesCount                           build_test_acceleration_pts_simulation_fast_unavoidable_test_classes_count,
                                maventestperformance.testAcceleration.predictiveTestSelection.simulation.fast.testClassesCountSelectedDueToInsufficientData         build_test_acceleration_pts_simulation_fast_test_classes_count_selected_due_to_insufficient_data,
                                maventestperformance.testAcceleration.testDistribution.usageStatus                                                                  build_test_acceleration_td_usage_status,
                                maventestperformance.testAcceleration.testDistribution.wallClockSavings                                                             build_test_acceleration_td_wall_clock_savings_millis,
                                maventestperformance.testAcceleration.wallClockSavings                                                                              build_test_acceleration_wall_clock_savings_combined_millis,
                                mavenattributes.topLevelProjectName                                                                                                 projectname,
                                (CASE
                                  WHEN (CONTAINS(build.mavenattributes.tags, 'CI') = true) THEN 'CI'
                                  WHEN (CONTAINS(build.mavenattributes.tags, 'CI') = false) THEN 'Local' END)                                                       environment,
                                maventestperformance.testGoals                                                                                                      testGoals
                         FROM "develocity-db"."build"
                        WHERE (type = 'maven'))
SELECT build_id,
       build_start_date,
       build_start_time,
       build_duration_millis,
       build_requested_tasks_or_goals,
       build_tool,
       build_test_classes_count,
       build_serial_test_work_units_execution_time,
       build_test_acceleration_pts_usage_status,
       build_test_acceleration_pts_usage_wall_clock_savings_millis,
       build_test_acceleration_pts_usage_serial_time_savings_millis,
       build_test_acceleration_pts_usage_selection_mode,
       build_test_acceleration_pts_simulation_conservative_wall_clock_savings_potential_millis,
       build_test_acceleration_pts_simulation_conservative_serial_time_savings_potential_millis,
       build_test_acceleration_pts_simulation_conservative_work_unit_failures_predicted_count,
       build_test_acceleration_pts_simulation_conservative_work_unit_failures_missed_count,
       build_test_acceleration_pts_simulation_conservative_avoidable_test_classes_count,
       build_test_acceleration_pts_simulation_conservative_unavoidable_test_classes_count,
       build_test_acceleration_pts_simulation_conservative_test_classes_count_selected_due_to_insufficient_data,
       build_test_acceleration_pts_simulation_standard_wall_clock_savings_potential_millis,
       build_test_acceleration_pts_simulation_standard_serial_time_savings_potential_millis,
       build_test_acceleration_pts_simulation_standard_work_unit_failures_predicted_count,
       build_test_acceleration_pts_simulation_standard_work_unit_failures_missed_count,
       build_test_acceleration_pts_simulation_standard_avoidable_test_classes_count,
       build_test_acceleration_pts_simulation_standard_unavoidable_test_classes_count,
       build_test_acceleration_pts_simulation_standard_test_classes_count_selected_due_to_insufficient_data,
       build_test_acceleration_pts_simulation_fast_wall_clock_savings_potential_millis,
       build_test_acceleration_pts_simulation_fast_serial_time_savings_potential_millis,
       build_test_acceleration_pts_simulation_fast_work_unit_failures_predicted_count,
       build_test_acceleration_pts_simulation_fast_work_unit_failures_missed_count,
       build_test_acceleration_pts_simulation_fast_avoidable_test_classes_count,
       build_test_acceleration_pts_simulation_fast_unavoidable_test_classes_count,
       build_test_acceleration_pts_simulation_fast_test_classes_count_selected_due_to_insufficient_data,
       build_test_acceleration_td_usage_status,
       build_test_acceleration_td_wall_clock_savings_millis,
       build_test_acceleration_wall_clock_savings_combined_millis,
       projectname,
       environment,
       testTask.taskPath                                                                                                       work_unit_path,
       testTask.taskType                                                                                                       work_unit_type,
       testTask.wallClockExecutionTime                                                                                         work_unit_wall_clock_execution_time,
       testTask.serialExecutionTime                                                                                            work_unit_serial_execution_time,
       testTask.tests.failedTestClassesCount                                                                                   work_unit_failed_test_classes_count,
       testTask.tests.testClassesCount                                                                                         work_unit_test_classes_count,
       testTask.testAcceleration.predictiveTestSelection.usage.status                                                          work_unit_test_acceleration_pts_usage_status,
       testTask.testAcceleration.predictiveTestSelection.usage.wallClockSavings                                                work_unit_test_acceleration_pts_usage_wall_clock_savings_millis,
       testTask.testAcceleration.predictiveTestSelection.usage.serialTimeSavings                                               work_unit_test_acceleration_pts_usage_serial_time_savings_millis,
       testTask.testAcceleration.predictiveTestSelection.usage.selectionMode                                                   work_unit_test_acceleration_pts_usage_selection_mode,
       testTask.testAcceleration.predictiveTestSelection.usage.nonSelectedTestClassesCount                                     work_unit_test_acceleration_pts_usage_non_selected_test_classes_count,
       testTask.testAcceleration.predictiveTestSelection.simulation.conservative.wallClockSavingsPotential                     work_unit_test_acceleration_pts_simulation_conservative_wall_clock_savings_potential_millis,
       testTask.testAcceleration.predictiveTestSelection.simulation.conservative.serialTimeSavingsPotential                    work_unit_test_acceleration_pts_simulation_conservative_serial_time_savings_potential_millis,
       testTask.testAcceleration.predictiveTestSelection.simulation.conservative.avoidableTestClassesCount                     work_unit_test_acceleration_pts_simulation_conservative_avoidable_test_classes_count,
       testTask.testAcceleration.predictiveTestSelection.simulation.conservative.unavoidableTestClassesCount                   work_unit_test_acceleration_pts_simulation_conservative_unavoidable_test_classes_count,
       testTask.testAcceleration.predictiveTestSelection.simulation.conservative.testClassesCountSelectedDueToInsufficientData work_unit_test_acceleration_pts_simulation_conservative_test_classes_count_selected_due_to_insufficient_data,
       testTask.testAcceleration.predictiveTestSelection.simulation.conservative.failedTestClassesPredictedCount               work_unit_test_acceleration_pts_simulation_conservative_failed_test_classes_predicted_count,
       testTask.testAcceleration.predictiveTestSelection.simulation.standard.wallClockSavingsPotential                         work_unit_test_acceleration_pts_simulation_standard_wall_clock_savings_potential_millis,
       testTask.testAcceleration.predictiveTestSelection.simulation.standard.serialTimeSavingsPotential                        work_unit_test_acceleration_pts_simulation_standard_serial_time_savings_potential_millis,
       testTask.testAcceleration.predictiveTestSelection.simulation.standard.avoidableTestClassesCount                         work_unit_test_acceleration_pts_simulation_standard_avoidable_test_classes_count,
       testTask.testAcceleration.predictiveTestSelection.simulation.standard.unavoidableTestClassesCount                       work_unit_test_acceleration_pts_simulation_standard_unavoidable_test_classes_count,
       testTask.testAcceleration.predictiveTestSelection.simulation.standard.testClassesCountSelectedDueToInsufficientData     work_unit_test_acceleration_pts_simulation_standard_test_classes_count_selected_due_to_insufficient_data,
       testTask.testAcceleration.predictiveTestSelection.simulation.standard.failedTestClassesPredictedCount                   work_unit_test_acceleration_pts_simulation_standard_failed_test_classes_predicted_count,
       testTask.testAcceleration.predictiveTestSelection.simulation.fast.wallClockSavingsPotential                             work_unit_test_acceleration_pts_simulation_fast_wall_clock_savings_potential_millis,
       testTask.testAcceleration.predictiveTestSelection.simulation.fast.serialTimeSavingsPotential                            work_unit_test_acceleration_pts_simulation_fast_serial_time_savings_potential_millis,
       testTask.testAcceleration.predictiveTestSelection.simulation.fast.avoidableTestClassesCount                             work_unit_test_acceleration_pts_simulation_fast_avoidable_test_classes_count,
       testTask.testAcceleration.predictiveTestSelection.simulation.fast.unavoidableTestClassesCount                           work_unit_test_acceleration_pts_simulation_fast_unavoidable_test_classes_count,
       testTask.testAcceleration.predictiveTestSelection.simulation.fast.testClassesCountSelectedDueToInsufficientData         work_unit_test_acceleration_pts_simulation_fast_test_classes_count_selected_due_to_insufficient_data,
       testTask.testAcceleration.predictiveTestSelection.simulation.fast.failedTestClassesPredictedCount                       work_unit_test_acceleration_pts_simulation_fast_failed_test_classes_predicted_count,
       testTask.testAcceleration.testDistribution.usageStatus                                                                  work_unit_test_acceleration_td_usage_status,
       testTask.testAcceleration.testDistribution.wallClockSavings                                                             work_unit_test_acceleration_td_wall_clock_savings_millis,
       testTask.testAcceleration.testDistribution.remoteTestClassesCount                                                       work_unit_test_acceleration_td_remote_test_classes_count,
       testTask.testAcceleration.wallClockSavings                                                                              work_unit_test_acceleration_wall_clock_savings_combined_millis
FROM (
         gradle_builds CROSS JOIN UNNEST(testTasks) AS t(testTask))
WHERE (projectname IS NOT NULL)

UNION ALL

SELECT build_id,
       build_start_date,
       build_start_time,
       build_duration_millis,
       build_requested_tasks_or_goals,
       build_tool,
       build_test_classes_count,
       build_serial_test_work_units_execution_time,
       build_test_acceleration_pts_usage_status,
       build_test_acceleration_pts_usage_wall_clock_savings_millis,
       build_test_acceleration_pts_usage_serial_time_savings_millis,
       build_test_acceleration_pts_usage_selection_mode,
       build_test_acceleration_pts_simulation_conservative_wall_clock_savings_potential_millis,
       build_test_acceleration_pts_simulation_conservative_serial_time_savings_potential_millis,
       build_test_acceleration_pts_simulation_conservative_work_unit_failures_predicted_count,
       build_test_acceleration_pts_simulation_conservative_work_unit_failures_missed_count,
       build_test_acceleration_pts_simulation_conservative_avoidable_test_classes_count,
       build_test_acceleration_pts_simulation_conservative_unavoidable_test_classes_count,
       build_test_acceleration_pts_simulation_conservative_test_classes_count_selected_due_to_insufficient_data,
       build_test_acceleration_pts_simulation_standard_wall_clock_savings_potential_millis,
       build_test_acceleration_pts_simulation_standard_serial_time_savings_potential_millis,
       build_test_acceleration_pts_simulation_standard_work_unit_failures_predicted_count,
       build_test_acceleration_pts_simulation_standard_work_unit_failures_missed_count,
       build_test_acceleration_pts_simulation_standard_avoidable_test_classes_count,
       build_test_acceleration_pts_simulation_standard_unavoidable_test_classes_count,
       build_test_acceleration_pts_simulation_standard_test_classes_count_selected_due_to_insufficient_data,
       build_test_acceleration_pts_simulation_fast_wall_clock_savings_potential_millis,
       build_test_acceleration_pts_simulation_fast_serial_time_savings_potential_millis,
       build_test_acceleration_pts_simulation_fast_work_unit_failures_predicted_count,
       build_test_acceleration_pts_simulation_fast_work_unit_failures_missed_count,
       build_test_acceleration_pts_simulation_fast_avoidable_test_classes_count,
       build_test_acceleration_pts_simulation_fast_unavoidable_test_classes_count,
       build_test_acceleration_pts_simulation_fast_test_classes_count_selected_due_to_insufficient_data,
       build_test_acceleration_td_usage_status,
       build_test_acceleration_td_wall_clock_savings_millis,
       build_test_acceleration_wall_clock_savings_combined_millis,
       projectname,
       environment,
       testGoal.goalPath                                                                                                       work_unit_path,
       testGoal.goalType                                                                                                       work_unit_type,
       testGoal.wallClockExecutionTime                                                                                         work_unit_wall_clock_execution_time,
       testGoal.serialExecutionTime                                                                                            work_unit_serial_execution_time,
       testGoal.tests.failedTestClassesCount                                                                                   work_unit_failed_test_classes_count,
       testGoal.tests.testClassesCount                                                                                         work_unit_test_classes_count,
       testGoal.testAcceleration.predictiveTestSelection.usage.status                                                          work_unit_test_acceleration_pts_usage_status,
       testGoal.testAcceleration.predictiveTestSelection.usage.wallClockSavings                                                work_unit_test_acceleration_pts_usage_wall_clock_savings_millis,
       testGoal.testAcceleration.predictiveTestSelection.usage.serialTimeSavings                                               work_unit_test_acceleration_pts_usage_serial_time_savings_millis,
       testGoal.testAcceleration.predictiveTestSelection.usage.selectionMode                                                   work_unit_test_acceleration_pts_usage_selection_mode,
       testGoal.testAcceleration.predictiveTestSelection.usage.nonSelectedTestClassesCount                                     work_unit_test_acceleration_pts_usage_non_selected_test_classes_count,
       testGoal.testAcceleration.predictiveTestSelection.simulation.conservative.wallClockSavingsPotential                     work_unit_test_acceleration_pts_simulation_conservative_wall_clock_savings_potential_millis,
       testGoal.testAcceleration.predictiveTestSelection.simulation.conservative.serialTimeSavingsPotential                    work_unit_test_acceleration_pts_simulation_conservative_serial_time_savings_potential_millis,
       testGoal.testAcceleration.predictiveTestSelection.simulation.conservative.avoidableTestClassesCount                     work_unit_test_acceleration_pts_simulation_conservative_avoidable_test_classes_count,
       testGoal.testAcceleration.predictiveTestSelection.simulation.conservative.unavoidableTestClassesCount                   work_unit_test_acceleration_pts_simulation_conservative_unavoidable_test_classes_count,
       testGoal.testAcceleration.predictiveTestSelection.simulation.conservative.testClassesCountSelectedDueToInsufficientData work_unit_test_acceleration_pts_simulation_conservative_test_classes_count_selected_due_to_insufficient_data,
       testGoal.testAcceleration.predictiveTestSelection.simulation.conservative.failedTestClassesPredictedCount               work_unit_test_acceleration_pts_simulation_conservative_failed_test_classes_predicted_count,
       testGoal.testAcceleration.predictiveTestSelection.simulation.standard.wallClockSavingsPotential                         work_unit_test_acceleration_pts_simulation_standard_wall_clock_savings_potential_millis,
       testGoal.testAcceleration.predictiveTestSelection.simulation.standard.serialTimeSavingsPotential                        work_unit_test_acceleration_pts_simulation_standard_serial_time_savings_potential_millis,
       testGoal.testAcceleration.predictiveTestSelection.simulation.standard.avoidableTestClassesCount                         work_unit_test_acceleration_pts_simulation_standard_avoidable_test_classes_count,
       testGoal.testAcceleration.predictiveTestSelection.simulation.standard.unavoidableTestClassesCount                       work_unit_test_acceleration_pts_simulation_standard_unavoidable_test_classes_count,
       testGoal.testAcceleration.predictiveTestSelection.simulation.standard.testClassesCountSelectedDueToInsufficientData     work_unit_test_acceleration_pts_simulation_standard_test_classes_count_selected_due_to_insufficient_data,
       testGoal.testAcceleration.predictiveTestSelection.simulation.standard.failedTestClassesPredictedCount                   work_unit_test_acceleration_pts_simulation_standard_failed_test_classes_predicted_count,
       testGoal.testAcceleration.predictiveTestSelection.simulation.fast.wallClockSavingsPotential                             work_unit_test_acceleration_pts_simulation_fast_wall_clock_savings_potential_millis,
       testGoal.testAcceleration.predictiveTestSelection.simulation.fast.serialTimeSavingsPotential                            work_unit_test_acceleration_pts_simulation_fast_serial_time_savings_potential_millis,
       testGoal.testAcceleration.predictiveTestSelection.simulation.fast.avoidableTestClassesCount                             work_unit_test_acceleration_pts_simulation_fast_avoidable_test_classes_count,
       testGoal.testAcceleration.predictiveTestSelection.simulation.fast.unavoidableTestClassesCount                           work_unit_test_acceleration_pts_simulation_fast_unavoidable_test_classes_count,
       testGoal.testAcceleration.predictiveTestSelection.simulation.fast.testClassesCountSelectedDueToInsufficientData         work_unit_test_acceleration_pts_simulation_fast_test_classes_count_selected_due_to_insufficient_data,
       testGoal.testAcceleration.predictiveTestSelection.simulation.fast.failedTestClassesPredictedCount                       work_unit_test_acceleration_pts_simulation_fast_failed_test_classes_predicted_count,
       testGoal.testAcceleration.testDistribution.usageStatus                                                                  work_unit_test_acceleration_td_usage_status,
       testGoal.testAcceleration.testDistribution.wallClockSavings                                                             work_unit_test_acceleration_td_wall_clock_savings_millis,
       testGoal.testAcceleration.testDistribution.remoteTestClassesCount                                                       work_unit_test_acceleration_td_remote_test_classes_count,
       testGoal.testAcceleration.wallClockSavings                                                                              work_unit_test_acceleration_wall_clock_savings_combined_millis
FROM (
         maven_builds CROSS JOIN UNNEST(testGoals) AS t(testGoal))
WHERE (projectname IS NOT NULL)