resource "aws_iam_role" "develocity_drv_grafana_grafana_workspace_role" {
  name               = "${var.prefix}develocity-drv-grafana-grafana-workspace-role"
  assume_role_policy = <<EOF
{
  "Version": "2012-10-17",
  "Statement": [
    {
      "Action": "sts:AssumeRole",
      "Principal": {
        "Service": "grafana.amazonaws.com"
      },
      "Effect": "Allow",
      "Sid": ""
    }
  ]
}
EOF
}

resource "aws_iam_role_policy_attachment" "develocity_drv_grafana_grafana_workspace_role_policy_attachment" {
  role       = aws_iam_role.develocity_drv_grafana_grafana_workspace_role.name
  policy_arn = "arn:aws:iam::aws:policy/service-role/AmazonGrafanaAthenaAccess"
}

resource "aws_iam_role_policy" "develocity_drv_grafana_workspace_policy" {
  role = aws_iam_role.develocity_drv_grafana_grafana_workspace_role.id

  policy = <<EOF
{
    "Version": "2012-10-17",
    "Statement": [
        {
            "Effect": "Allow",
            "Action": [
                "s3:GetObject",
                "s3:ListBucket"
            ],
            "Resource": [
                "arn:aws:s3:::${var.bucket_name}",
                "arn:aws:s3:::${var.bucket_name}/*"
            ]
        }
    ]
}
EOF
}
