CREATE
OR REPLACE VIEW "build_summary" AS
  WITH
    view_base AS (
      SELECT
        COALESCE(mavenattributes.toplevelprojectname, gradleattributes.rootprojectname, bazelAttributes.modulename,
                 npmattributes.packageName, pythonattributes.projectname, sbtattributes.rootprojectname)                                                   projectname
          , ARRAY_JOIN(COALESCE(mavenattributes.requestedgoals, gradleattributes.requestedtasks,
                    IF(bazelattributes.command IS NULL, NULL, ARRAY[CONCAT(bazelattributes.command, ' ', ARRAY_JOIN(bazelattributes.targetpatterns, ' '))]),
                    IF(npmattributes.command.command IS NULL, NULL, ARRAY[CONCAT(npmattributes.command.command, ' ', ARRAY_JOIN(npmattributes.command.arguments, ' '))]) ,
                    sbtattributes.requestedcommands, pythonattributes.command), ' ')                                                                       requested_goals_or_tasks
          , COALESCE(mavenattributes.environment.username, gradleattributes.environment.username,
                     bazelAttributes.user, npmattributes.user, pythonattributes.user, sbtattributes.environment.username)                                  username
          , COALESCE(mavenattributes.buildduration, gradleattributes.buildduration, bazelAttributes.buildduration,
                     npmattributes.buildduration, pythonattributes.buildduration, sbtattributes.buildduration)                                             build_duration_millis
          , COALESCE(mavenattributes.tags, gradleattributes.tags, bazelAttributes.tags,
                     npmattributes.tags, pythonattributes.tags, sbtattributes.tags)                                                                        tags
          , COALESCE(mavenattributes.hasfailed, gradleattributes.hasfailed, bazelAttributes.hasfailed,
                     npmattributes.hasfailed, pythonattributes.hasfailed, sbtattributes.hasfailed)                                                         has_failed
          , COALESCE(mavenattributes.hasnonverificationfailure,
                     gradleattributes.hasnonverificationfailure,
                     sbtattributes.hasnonverificationfailure)                                                                                              has_non_verification_failure
          , COALESCE(mavenattributes.hasverificationfailure,
                     gradleattributes.hasverificationfailure,
                     sbtattributes.hasverificationfailure)                                                                                                 has_verification_failure
          , COALESCE("mavenattributes"."environment".publichostname,
                     "gradleattributes"."environment".publichostname,
                      bazelAttributes.host, npmattributes.host, pythonattributes.host, "sbtattributes"."environment".publichostname)                       hostname
          , COALESCE("mavenattributes"."environment".operatingsystem,
                     "gradleattributes"."environment".operatingsystem,
                     "sbtattributes"."environment".operatingsystem)                                                                                        operatingsystem
          , COALESCE(gradlebuildcacheperformance.avoidancesavingssummary.localbuildcache,
                     mavenbuildcacheperformance.avoidancesavingssummary.localbuildcache)                                                                   local_build_cache_avoidance_millis
          , COALESCE(gradlebuildcacheperformance.avoidancesavingssummary.remotebuildcache,
                     mavenbuildcacheperformance.avoidancesavingssummary.remotebuildcache)                                                                  remote_build_cache_avoidance_millis
          , COALESCE("gradlebuildcacheperformance"."buildcaches"."local"."isenabled",
                     "mavenbuildcacheperformance"."buildcaches"."local"."isenabled")                                                                       local_build_cache_enabled
          , COALESCE("gradlebuildcacheperformance"."buildcaches"."local"."ispushenabled",
                     "mavenbuildcacheperformance"."buildcaches"."local"."ispushenabled")                                                                   local_build_cache_push_enabled
          , COALESCE("gradlebuildcacheperformance"."buildcaches"."local"."isdisabledduetoerror",
                     "mavenbuildcacheperformance"."buildcaches"."local"."isdisabledduetoerror")                                                            local_build_cache_disabled_due_to_error
          , COALESCE("gradlebuildcacheperformance"."buildcaches"."remote"."isenabled",
                     "mavenbuildcacheperformance"."buildcaches"."remote"."isenabled")                                                                      remote_build_cache_enabled
          , COALESCE("gradlebuildcacheperformance"."buildcaches"."remote"."ispushenabled",
                     "mavenbuildcacheperformance"."buildcaches"."remote"."ispushenabled")                                                                  remote_build_cache_push_enabled
          , COALESCE("gradlebuildcacheperformance"."buildcaches"."remote"."isdisabledduetoerror",
                     "mavenbuildcacheperformance"."buildcaches"."remote"."isdisabledduetoerror")                                                           remote_build_cache_disabled_due_to_error
          , REGEXP_REPLACE(
              COALESCE(mavenattributes.environment.jvmversion,
                      gradleattributes.environment.jvmversion,
                      sbtattributes.environment.jvmversion),
              '^([0-9a-zA-Z_\-.]+).*(OpenJDK|Java HotSpot).*VM.*?([\d\.?]+).*', '$1 $2 $3')                                                                jvm_version
          , COALESCE(gradleattributes.buildoptions.parallelprojectexecutionenabled,
                     (mavenattributes.buildoptions.maxnumberofthreads > 1),
                      sbtattributes.buildoptions.parallelExecutionEnabled)                                                                                parallel_enabled
          , COALESCE(gradleattributes.buildoptions.buildcacheenabled,
                     (mavenbuildcacheperformance.buildcaches.local.isenabled OR
                      mavenbuildcacheperformance.buildcaches.remote.isenabled))                                                                            build_cache_enabled
          , COALESCE(gradleattributes.buildoptions.configurationcacheenabled, false)                                                                       config_cache_enabled
          , COALESCE(gradleconfigurationcache.result is not null, false)                                                                                   config_cache_used
          , COALESCE(gradleattributes.buildoptions.reruntasksenabled,
                     mavenattributes.buildoptions.rerungoals)                                                                                              rerun_tasks_enabled
          , COALESCE(gradleattributes.buildoptions.refreshdependenciesenabled,
                     mavenattributes.buildoptions.updatesnapshotsenabled)                                                                                  refresh_dependencies_enabled
          , COALESCE(gradleattributes.develocitysettings.backgroundpublicationenabled,
                     mavenattributes.develocitysettings.backgroundpublicationenabled,
                     sbtattributes.develocitysettings.backgroundpublicationenabled)                                                                        background_upload_enabled
          , COALESCE(gradleattributes.develocitysettings.taskinputsfilecapturingenabled,
                     mavenattributes.develocitysettings.goalinputsfilecapturingenabled)                                                                    input_file_capturing_enabled
          , COALESCE(cardinality(gradleprojects), cardinality(mavenmodules))                                                                               module_count
          , GREATEST(
              COALESCE(
                  COALESCE(mavenbuildcacheperformance.serializationfactor,
                           gradlebuildcacheperformance.serializationfactor),
                  1),
              1)                                                                                                                                           serialization_factor
          , id                                                                                                                                             build_id
          , type                                                                                                                                           build_tool
          , startdate                                                                                                                                      build_start_date
          , buildtoolversion                                                                                                                               build_tool_version_full
          , COALESCE("mavenattributes"."environment".numberOfCpuCores,
                     "gradleattributes"."environment".numberOfCpuCores,
                     "sbtattributes"."environment".numberOfCpuCores)                                                                                       number_of_cores
          , COALESCE(gradleattributes.buildoptions.maxNumberOfGradleWorkers,
                     mavenattributes.buildoptions.maxNumberOfThreads)                                                                                      number_of_workers
          , COALESCE(gradleattributes."values", mavenattributes."values", bazelAttributes."values",
                     npmattributes."values", pythonattributes."values", sbtattributes."values")                                                            custom_values
          , COALESCE(gradlenetworkactivity.networkrequestcount,
                     mavendependencyresolution.networkrequestcount)                                                                                        network_request_count
          , COALESCE(gradleNetworkActivity.serialnetworkrequesttime,
                     mavendependencyresolution.serialnetworkrequesttime)                                                                                   serial_network_request_time_millis
          , COALESCE(gradleNetworkActivity.wallclocknetworkrequesttime,
                     mavendependencyresolution.wallclocknetworkrequesttime)                                                                                wall_clock_network_request_time_millis
          , COALESCE(gradleNetworkActivity.filedownloadsize,
                     mavendependencyresolution.filedownloadsize)                                                                                           file_download_size
          , COALESCE(gradleNetworkActivity.filedownloadcount,
                     mavendependencyresolution.filedownloadcount)                                                                                          file_download_count
          , COALESCE(mavenresourceusage.totalmemory, gradleresourceusage.totalmemory)                                                                      resource_usage_total_system_memory
          , COALESCE(mavenresourceusage.total.allprocessescpu.median,
                     gradleresourceusage.total.allprocessescpu.median)                                                                                     resource_usage_total_all_processes_cpu_median
          , COALESCE(mavenresourceusage.total.buildprocesscpu.median,
                     gradleresourceusage.total.buildprocesscpu.median)                                                                                     resource_usage_total_build_process_cpu_median
          , COALESCE(mavenresourceusage.total.buildchildprocessescpu.median,
                     gradleresourceusage.total.buildchildprocessescpu.median)                                                                              resource_usage_total_build_child_processes_cpu_median
          , COALESCE(mavenresourceusage.total.allprocessesmemory.max,
                     gradleresourceusage.total.allprocessesmemory.max)                                                                                     resource_usage_total_all_processes_memory_max
          , COALESCE(mavenresourceusage.total.buildprocessmemory.p95,
                     gradleresourceusage.total.buildprocessmemory.p95)                                                                                     resource_usage_total_build_process_memory_p95
          , COALESCE(mavenresourceusage.total.buildchildprocessesmemory.p95,
                     gradleresourceusage.total.buildchildprocessesmemory.p95)                                                                              resource_usage_total_build_child_processes_memory_p95
          , COALESCE(mavenresourceusage.execution.allprocessescpu.p75,
                     gradleresourceusage.execution.allprocessescpu.p75)                                                                                    resource_usage_execution_all_processes_cpu_p75
          , COALESCE(mavenBuildProfileOverview.breakdown.execution.goalExecution,
                     gradleBuildProfileOverview.breakdown.execution)                                                                                       executing_goals_or_tasks_duration_millis
          , gradledeprecations.deprecations                                                                                                                gradle_deprecations
          , COALESCE(gradleattributes.buildoptions.daemonenabled, mavenattributes.buildoptions.daemonenabled)                                              daemon_enabled
          , COALESCE(gradleBuildProfileOverview.breakdown.configuration, 0)                                                                                gradle_configuration_duration_millis
          , COALESCE(gradleconfigurationcache.result.outcome, '')                                                                                          gradle_configuration_cache_outcome
          , gradleconfigurationcache.result.missReasons                                                                                                    gradle_configuration_cache_miss_reasons
          , COALESCE(maventestperformance.tests.testClassesCount,
                     gradletestperformance.tests.testClassesCount)                                                                                         tests_test_classes_count
          , COALESCE(maventestperformance.serialTestGoalsExecutionTime,
                     gradletestperformance.serialTestTasksExecutionTime)                                                                                   serial_test_work_units_execution_time
          , COALESCE(maventestperformance.testAcceleration.predictiveTestSelection.usage.status,
                     gradletestperformance.testAcceleration.predictiveTestSelection.usage.status)                                                          test_acceleration_pts_usage_status
          , COALESCE(maventestperformance.testAcceleration.predictiveTestSelection.usage.wallClockSavings,
                     gradletestperformance.testAcceleration.predictiveTestSelection.usage.wallClockSavings)                                                test_acceleration_pts_usage_wall_clock_savings_millis
          , COALESCE(maventestperformance.testAcceleration.predictiveTestSelection.usage.serialTimeSavings,
                     gradletestperformance.testAcceleration.predictiveTestSelection.usage.serialTimeSavings)                                               test_acceleration_pts_usage_serial_time_savings_millis
          , COALESCE(maventestperformance.testAcceleration.predictiveTestSelection.simulation.conservative.wallClockSavingsPotential,
                     gradletestperformance.testAcceleration.predictiveTestSelection.simulation.conservative.wallClockSavingsPotential)                     test_acceleration_pts_simulation_conservative_wall_clock_savings_potential
          , COALESCE(maventestperformance.testAcceleration.predictiveTestSelection.simulation.conservative.serialTimeSavingsPotential,
                     gradletestperformance.testAcceleration.predictiveTestSelection.simulation.conservative.serialTimeSavingsPotential)                    test_acceleration_pts_simulation_conservative_serial_time_savings_potential
          , COALESCE(maventestperformance.testAcceleration.predictiveTestSelection.simulation.conservative.workUnitFailuresPredictedCount,
                     gradletestperformance.testAcceleration.predictiveTestSelection.simulation.conservative.workUnitFailuresPredictedCount)                test_acceleration_pts_simulation_conservative_work_unit_failures_predicted_count
          , COALESCE(maventestperformance.testAcceleration.predictiveTestSelection.simulation.conservative.workUnitFailuresMissedCount,
                     gradletestperformance.testAcceleration.predictiveTestSelection.simulation.conservative.workUnitFailuresMissedCount)                   test_acceleration_pts_simulation_conservative_work_unit_failures_missed_count
          , COALESCE(maventestperformance.testAcceleration.predictiveTestSelection.simulation.conservative.avoidableTestClassesCount,
                     gradletestperformance.testAcceleration.predictiveTestSelection.simulation.conservative.avoidableTestClassesCount)                     test_acceleration_pts_simulation_conservative_avoidable_test_classes_count
          , COALESCE(maventestperformance.testAcceleration.predictiveTestSelection.simulation.conservative.unavoidableTestClassesCount,
                     gradletestperformance.testAcceleration.predictiveTestSelection.simulation.conservative.unavoidableTestClassesCount)                   test_acceleration_pts_simulation_conservative_unavoidable_test_classes_count
          , COALESCE(maventestperformance.testAcceleration.predictiveTestSelection.simulation.conservative.testClassesCountSelectedDueToInsufficientData,
                     gradletestperformance.testAcceleration.predictiveTestSelection.simulation.conservative.testClassesCountSelectedDueToInsufficientData) test_acceleration_pts_simulation_conservative_test_classes_count_selected_due_to_insufficient_data
          , COALESCE(maventestperformance.testAcceleration.predictiveTestSelection.simulation.standard.wallClockSavingsPotential,
                     gradletestperformance.testAcceleration.predictiveTestSelection.simulation.standard.wallClockSavingsPotential)                         test_acceleration_pts_simulation_standard_wall_clock_savings_potential
          , COALESCE(maventestperformance.testAcceleration.predictiveTestSelection.simulation.standard.serialTimeSavingsPotential,
                     gradletestperformance.testAcceleration.predictiveTestSelection.simulation.standard.serialTimeSavingsPotential)                        test_acceleration_pts_simulation_standard_serial_time_savings_potential
          , COALESCE(maventestperformance.testAcceleration.predictiveTestSelection.simulation.standard.workUnitFailuresPredictedCount,
                     gradletestperformance.testAcceleration.predictiveTestSelection.simulation.standard.workUnitFailuresPredictedCount)                    test_acceleration_pts_simulation_standard_work_unit_failures_predicted_count
          , COALESCE(maventestperformance.testAcceleration.predictiveTestSelection.simulation.standard.workUnitFailuresMissedCount,
                     gradletestperformance.testAcceleration.predictiveTestSelection.simulation.standard.workUnitFailuresMissedCount)                       test_acceleration_pts_simulation_standard_work_unit_failures_missed_count
          , COALESCE(maventestperformance.testAcceleration.predictiveTestSelection.simulation.standard.avoidableTestClassesCount,
                     gradletestperformance.testAcceleration.predictiveTestSelection.simulation.standard.avoidableTestClassesCount)                         test_acceleration_pts_simulation_standard_avoidable_test_classes_count
          , COALESCE(maventestperformance.testAcceleration.predictiveTestSelection.simulation.standard.unavoidableTestClassesCount,
                     gradletestperformance.testAcceleration.predictiveTestSelection.simulation.standard.unavoidableTestClassesCount)                       test_acceleration_pts_simulation_standard_unavoidable_test_classes_count
          , COALESCE(maventestperformance.testAcceleration.predictiveTestSelection.simulation.standard.testClassesCountSelectedDueToInsufficientData,
                     gradletestperformance.testAcceleration.predictiveTestSelection.simulation.standard.testClassesCountSelectedDueToInsufficientData)     test_acceleration_pts_simulation_standard_test_classes_count_selected_due_to_insufficient_data
          , COALESCE(maventestperformance.testAcceleration.predictiveTestSelection.simulation.fast.wallClockSavingsPotential,
                     gradletestperformance.testAcceleration.predictiveTestSelection.simulation.fast.wallClockSavingsPotential)                             test_acceleration_pts_simulation_fast_wall_clock_savings_potential
          , COALESCE(maventestperformance.testAcceleration.predictiveTestSelection.simulation.fast.serialTimeSavingsPotential,
                     gradletestperformance.testAcceleration.predictiveTestSelection.simulation.fast.serialTimeSavingsPotential)                            test_acceleration_pts_simulation_fast_serial_time_savings_potential
          , COALESCE(maventestperformance.testAcceleration.predictiveTestSelection.simulation.fast.workUnitFailuresPredictedCount,
                     gradletestperformance.testAcceleration.predictiveTestSelection.simulation.fast.workUnitFailuresPredictedCount)                        test_acceleration_pts_simulation_fast_work_unit_failures_predicted_count
          , COALESCE(maventestperformance.testAcceleration.predictiveTestSelection.simulation.fast.workUnitFailuresMissedCount,
                     gradletestperformance.testAcceleration.predictiveTestSelection.simulation.fast.workUnitFailuresMissedCount)                           test_acceleration_pts_simulation_fast_work_unit_failures_missed_count
          , COALESCE(maventestperformance.testAcceleration.predictiveTestSelection.simulation.fast.avoidableTestClassesCount,
                     gradletestperformance.testAcceleration.predictiveTestSelection.simulation.fast.avoidableTestClassesCount)                             test_acceleration_pts_simulation_fast_avoidable_test_classes_count
          , COALESCE(maventestperformance.testAcceleration.predictiveTestSelection.simulation.fast.unavoidableTestClassesCount,
                     gradletestperformance.testAcceleration.predictiveTestSelection.simulation.fast.unavoidableTestClassesCount)                           test_acceleration_pts_simulation_fast_unavoidable_test_classes_count
          , COALESCE(maventestperformance.testAcceleration.predictiveTestSelection.simulation.fast.testClassesCountSelectedDueToInsufficientData,
                     gradletestperformance.testAcceleration.predictiveTestSelection.simulation.fast.testClassesCountSelectedDueToInsufficientData)         test_acceleration_pts_simulation_fast_test_classes_count_selected_due_to_insufficient_data
          , COALESCE(maventestperformance.testAcceleration.testDistribution.usageStatus,
                     gradletestperformance.testAcceleration.testDistribution.usageStatus)                                                                  test_acceleration_td_usage_status
          , COALESCE(maventestperformance.testAcceleration.testDistribution.wallClockSavings,
                     gradletestperformance.testAcceleration.testDistribution.wallClockSavings)                                                             test_acceleration_td_wall_clock_savings_millis
          , COALESCE(maventestperformance.testAcceleration.wallClockSavings,
                     gradletestperformance.testAcceleration.wallClockSavings)                                                                              test_acceleration_wall_clock_savings_combined_millis
          , modelversion.year                                                                                                                              release_year
          , modelversion.release                                                                                                                           release_number
    FROM "develocity-db"."build")
SELECT projectname
     , requested_goals_or_tasks
     , username
     , build_duration_millis
     , has_failed
     , has_non_verification_failure
     , has_verification_failure
     , hostname
     , operatingsystem
     , build_cache_enabled
     , local_build_cache_avoidance_millis
     , remote_build_cache_avoidance_millis
     , local_build_cache_enabled
     , local_build_cache_push_enabled
     , local_build_cache_disabled_due_to_error
     , remote_build_cache_enabled
     , remote_build_cache_push_enabled
     , remote_build_cache_disabled_due_to_error
     , parallel_enabled
     , config_cache_enabled
     , config_cache_used
     , rerun_tasks_enabled
     , refresh_dependencies_enabled
     , background_upload_enabled
     , input_file_capturing_enabled
     , module_count
     , serialization_factor
     , build_id
     , build_tool
     , build_start_date
     , build_tool_version_full
     , REGEXP_REPLACE(build_tool_version_full, '^(\d+\.\d+).*', '$1.x')          build_tool_version_major_minor
     , REGEXP_REPLACE(build_tool_version_full, '^(\d+).*', '$1.x')               build_tool_version_major
     , jvm_version                                                               jvm_version_full_vendored
     , REGEXP_REPLACE(jvm_version, '^([A-Za-z\s]+)\s[\d\.]+.*$', '$1')           jvm_version_vendor
     , REGEXP_REPLACE(jvm_version, '^[A-Za-z\s]+\s([\d\.]+).*$', '$1')           jvm_version_full
     , REGEXP_REPLACE(jvm_version, '^[A-Za-z\s]+\s([\d]+)\.?[\d\.]?.*$', '$1.x') jvm_version_major
     , (CASE
            WHEN REGEXP_LIKE(REGEXP_REPLACE(jvm_version, '^[A-Za-z\s]+\s(\d+\.?\d+)\.?\d*.*', '$1.x'), '\d+\.\d+')
                THEN REGEXP_REPLACE(jvm_version, '^[A-Za-z\s]+\s(\d+\.?\d+)\.?\d*.*', '$1.x')
            ELSE CONCAT(REGEXP_REPLACE(jvm_version, '^[A-Za-z\s]+\s(\d+\.?\d+)\.?\d*.*', '$1'),
                        '.0.x') END)                                             jvm_version_major_minor
     , (CASE
            WHEN (CONTAINS(tags, 'CI') = true) THEN 'CI'
            WHEN (COALESCE(CONTAINS(tags, 'CI'), false) = false) THEN 'Local' END) environment
     , tags
     , custom_values
     , network_request_count
     , serial_network_request_time_millis
     , wall_clock_network_request_time_millis
     , file_download_size
     , file_download_count
     , number_of_cores
     , number_of_workers
     , resource_usage_total_all_processes_cpu_median
     , resource_usage_total_build_process_cpu_median
     , resource_usage_total_build_child_processes_cpu_median
     , resource_usage_execution_all_processes_cpu_p75
     , resource_usage_total_system_memory
     , resource_usage_total_all_processes_memory_max
     , resource_usage_total_build_process_memory_p95
     , resource_usage_total_build_child_processes_memory_p95
     , executing_goals_or_tasks_duration_millis
     , gradle_deprecations
     , daemon_enabled
     , gradle_configuration_duration_millis
     , gradle_configuration_cache_outcome
     , gradle_configuration_cache_miss_reasons
     , tests_test_classes_count
     , serial_test_work_units_execution_time
     , test_acceleration_pts_usage_status
     , test_acceleration_pts_usage_wall_clock_savings_millis
     , test_acceleration_pts_usage_serial_time_savings_millis
     , test_acceleration_pts_simulation_conservative_wall_clock_savings_potential
     , test_acceleration_pts_simulation_conservative_serial_time_savings_potential
     , test_acceleration_pts_simulation_conservative_work_unit_failures_predicted_count
     , test_acceleration_pts_simulation_conservative_work_unit_failures_missed_count
     , test_acceleration_pts_simulation_conservative_avoidable_test_classes_count
     , test_acceleration_pts_simulation_conservative_unavoidable_test_classes_count
     , test_acceleration_pts_simulation_conservative_test_classes_count_selected_due_to_insufficient_data
     , test_acceleration_pts_simulation_standard_wall_clock_savings_potential
     , test_acceleration_pts_simulation_standard_serial_time_savings_potential
     , test_acceleration_pts_simulation_standard_work_unit_failures_predicted_count
     , test_acceleration_pts_simulation_standard_work_unit_failures_missed_count
     , test_acceleration_pts_simulation_standard_avoidable_test_classes_count
     , test_acceleration_pts_simulation_standard_unavoidable_test_classes_count
     , test_acceleration_pts_simulation_standard_test_classes_count_selected_due_to_insufficient_data
     , test_acceleration_pts_simulation_fast_wall_clock_savings_potential
     , test_acceleration_pts_simulation_fast_serial_time_savings_potential
     , test_acceleration_pts_simulation_fast_work_unit_failures_predicted_count
     , test_acceleration_pts_simulation_fast_work_unit_failures_missed_count
     , test_acceleration_pts_simulation_fast_avoidable_test_classes_count
     , test_acceleration_pts_simulation_fast_unavoidable_test_classes_count
     , test_acceleration_pts_simulation_fast_test_classes_count_selected_due_to_insufficient_data
     , test_acceleration_td_usage_status
     , test_acceleration_td_wall_clock_savings_millis
     , test_acceleration_wall_clock_savings_combined_millis
     , release_year
     , release_number
FROM view_base
WHERE (projectname IS NOT NULL);

CREATE
OR REPLACE VIEW "task_mapping" AS
select *
from ((values
           --CODEGEN MAVEN
           ('org.jvnet.jaxb.maven%', null, 'codegen'),
           ('org.jvnet.jaxb2.maven2%', null, 'codegen'),
           (null, 'io.openapitools.swagger.GenerateMojo', 'codegen'),
           (null, 'com.github.kongchen.swagger.docgen.mavenplugin.ApiDocumentMojo', 'codegen'),
           (null, 'org.codehaus.mojo.aspectj.AjcCompileMojo', 'codegen'),
           ('org.apache.avro.mojo%', null, 'codegen'),
           ('org.springframework.cloud.contract.maven.verifier.GenerateStubsMojo', null, 'codegen'),
           ('org.springframework.cloud.contract.maven.verifier.RunMojo', null, 'codegen'),
           ('com.graphql_java_generator.mavenplugin%', null, 'codegen'),
           ('org.xolstice.maven.plugin.protobuf%', null, 'codegen'),
           (null, 'org.antlr.mojo.antlr4.Antlr4Mojo', 'codegen'),
           --LINT MAVEN
           (null, 'org.apache.maven.plugins.checkstyle.CheckstyleViolationCheckMojo', 'lint'),
           (null, 'org.codehaus.mojo.spotbugs.SpotBugsMojo', 'lint'),
           ('org.apache.maven.plugins.pmd%', null, 'lint'),
           ('com.diffplug.spotless.maven%', null, 'lint'),
           ('org.codehaus.mojo.animal_sniffer.maven%', null, 'lint'),
           --GRADLE CODEGEN
           (null, 'com.gradleup.jaxb.tasks.GenerateJaxb2Classes', 'codegen'),
           (null, 'com.ewerk.gradle.plugins.tasks.GenerateJaxb2Classes', 'codegen'),
           (null, 'com.intershop.gradle.jaxb.task.JavaToSchemaTask', 'codegen'),
           (null, 'com.intershop.gradle.jaxb.task.SchemaToJavaTask', 'codegen'),
           (null, 'org.openrepose.gradle.plugins.jaxb.task.JaxbXjc', 'codegen'),
           (null, 'io.swagger.v3.plugins.gradle.tasks.ResolveTask', 'codegen'),
           ('org.openapitools.generator.gradle.plugin.tasks%', null, 'codegen'),
           ('com.graphql_java_generator.gradleplugin%', null, 'codegen'),
           (null, 'com.google.protobuf.gradle.GenerateProtoTask', 'codegen'),
           (null, 'org.gradle.api.plugins.antlr.AntlrTask', 'codegen'),
           ('io.freefair.gradle.plugin%', null, 'codegen'),
           ('io.freefair.gradle.plugins%', null, 'codegen'),
           ('com.github.davidmc24.gradle.plugin.avro%', null, 'codegen'),
           ('org.springframework.cloud.contract.verifier.plugin%', null, 'codegen'),
           --GRADLE LINT
           (null, 'org.gradle.api.plugins.quality.Checkstyle', 'lint'),
           (null, 'com.github.spotbugs.snom.SpotBugsTask', 'lint'),
           (null, 'org.gradle.api.plugins.quality.Pmd', 'lint'),
           ('com.diffplug.gradle.spotless%', null, 'lint'),
           ('ru.vyarus.gradle.plugin.animalsniffer%', null, 'lint'),
           --MAVEN TEST
           (null, 'org.apache.maven.plugin.failsafe.IntegrationTestMojo', 'test'),
           (null, 'org.apache.maven.plugin.surefire.SurefirePlugin', 'test'),
           --GRADLE TEST
           (null, 'org.gradle.api.tasks.testing.Test', 'test'),
           --COMPILE
           ('%Compile%', null, 'compile'),
           --OTHER
           ('%JavaDoc%', null, 'other_cacheable'),
           ('%Javadoc%', null, 'other_cacheable')) as t(typematch, typename, category)
         );


CREATE
OR REPLACE VIEW "gradle_task_summary" AS
  WITH gradle_tasks AS (SELECT gradleattributes.rootprojectname                                    projectname
                             , gradlebuildcacheperformance.buildcaches.remote.isenabled            remote_build_cache_enabled
                             , gradlebuildcacheperformance.buildcaches.remote.ispushenabled        remote_build_cache_push_enabled
                             , gradlebuildcacheperformance.buildcaches.remote.isdisabledduetoerror remote_build_cache_disabled_due_to_error
                             , gradlebuildcacheperformance.buildcaches.local.isenabled             local_build_cache_enabled
                             , gradlebuildcacheperformance.buildcaches.local.ispushenabled         local_build_cache_push_enabled
                             , gradlebuildcacheperformance.buildcaches.local.isdisabledduetoerror  local_build_cache_disabled_due_to_error
                             , gradleattributes.buildoptions.buildcacheenabled                     build_cache_enabled
                             , COALESCE(gradlebuildcacheperformance.serializationfactor, 1)        serialization_factor
                             , id                                                                  build_id
                             , ARRAY_JOIN(gradleattributes.requestedtasks, ' ')                    requested_tasks
                             , gradlebuildcacheperformance.taskexecution                           tasks
                             , startdate                                                           build_start_date
                             , gradleattributes.tags                                               tags
                             , gradleattributes.hasfailed                                          has_failed
                             , gradleattributes.buildduration                                      build_duration_millis
                             , type                                                                build_tool
                             , gradleattributes.buildstarttime                                     build_start_time
  FROM "develocity-db".build
  WHERE (type = 'gradle'))
SELECT build_id
     , build_tool
     , build_start_date
     , build_start_time
     , remote_build_cache_enabled
     , remote_build_cache_push_enabled
     , remote_build_cache_disabled_due_to_error
     , local_build_cache_enabled
     , local_build_cache_push_enabled
     , local_build_cache_disabled_due_to_error
     , build_cache_enabled
     , requested_tasks
     , projectname
     , has_failed
     , build_duration_millis
     , tags
     , (CASE
            WHEN (contains(tags, 'CI') = true) THEN 'CI'
            WHEN (COALESCE(CONTAINS(tags, 'CI'), false) = false) THEN 'Local' END)                              environment
     , taskexecution.tasktype                                                                  task_type
     , taskexecution.duration                                                                  task_duration_millis
     , taskexecution.avoidanceoutcome                                                          avoidance_outcome
     , taskexecution.avoidancesavings                                                          avoidance_savings_millis
     , taskexecution.cacheartifactsize                                                         cache_artifact_size
     , taskexecution.fingerprintingduration                                                    fingerprinting_duration_millis
     , serialization_factor
     , taskexecution.noncacheabilitycategory                                                   non_cacheability_category
     , taskexecution.cachekey                                                                  task_cachekey
     , taskexecution.taskpath                                                                  task_path
     , COALESCE(t.category, 'other')                                                           task_category
     , (CASE
            WHEN (taskexecution.noncacheabilitycategory = 'build_cache_not_enabled') THEN 'potentially_avoidable'
            WHEN (taskexecution.noncacheabilitycategory = 'build_cache_disabled_by_user') THEN 'potentially_avoidable'
            WHEN (taskexecution.noncacheabilitycategory = 'multiple_outputs_declared') THEN 'potentially_avoidable'
            WHEN (taskexecution.noncacheabilitycategory = 'no_outputs_declared') THEN 'potentially_avoidable'
            WHEN (taskexecution.noncacheabilitycategory = 'task_output_caching_not_enabled')
                THEN 'potentially_avoidable'
            WHEN (taskexecution.noncacheabilitycategory = 'overlapping_outputs') THEN 'potentially_avoidable'
            WHEN (taskexecution.noncacheabilitycategory = 'cache-if_condition_not_matched') THEN 'unavoidable'
            WHEN (taskexecution.noncacheabilitycategory = 'disabled_to_ensure_correctness') THEN 'unavoidable'
            WHEN (taskexecution.noncacheabilitycategory = 'do-not-cache-if_condition_matched') THEN 'unavoidable'
            WHEN (taskexecution.noncacheabilitycategory = 'non_cacheable_inputs') THEN 'unavoidable'
            WHEN (taskexecution.noncacheabilitycategory = 'non_cacheable_task_action') THEN 'unavoidable'
            WHEN (taskexecution.noncacheabilitycategory = 'non_cacheable_task_implementation') THEN 'unavoidable'
            WHEN (taskexecution.noncacheabilitycategory = 'non_cacheable_tree_output') THEN 'unavoidable'
            WHEN (taskexecution.noncacheabilitycategory = 'task_has_no_actions') THEN 'unavoidable'
            WHEN (taskexecution.noncacheabilitycategory = 'not_entitled') THEN 'unknown'
            WHEN (taskexecution.noncacheabilitycategory = 'unknown') THEN 'unknown'
            WHEN (taskexecution.noncacheabilitycategory = 'unknown_entitlements') THEN 'unknown'
            WHEN (taskexecution.noncacheabilitycategory = 'offline_build') THEN 'unknown' END) category
FROM ((gradle_tasks
    CROSS JOIN UNNEST(tasks) t (taskexecution))
    LEFT JOIN task_mapping t ON ((taskexecution.tasktype LIKE t.typematch) OR (taskexecution.tasktype = t.typename)))
WHERE ((projectname IS NOT NULL) AND (serialization_factor <> 0) AND (taskexecution.cachekey IS NOT NULL));

CREATE
OR REPLACE VIEW "maven_goal_summary" AS
  WITH maven_goals AS (SELECT mavenattributes.toplevelprojectname                                projectname
                            , mavenbuildcacheperformance.buildcaches.remote.isenabled            remote_build_cache_enabled
                            , mavenbuildcacheperformance.buildcaches.remote.ispushenabled        remote_build_cache_push_enabled
                            , mavenbuildcacheperformance.buildcaches.remote.isdisabledduetoerror remote_build_cache_disabled_due_to_error
                            , mavenbuildcacheperformance.buildcaches.local.isenabled             local_build_cache_enabled
                            , mavenbuildcacheperformance.buildcaches.local.ispushenabled         local_build_cache_push_enabled
                            , mavenbuildcacheperformance.buildcaches.local.isdisabledduetoerror  local_build_cache_disabled_due_to_error
                            , (mavenbuildcacheperformance.buildcaches.local.isenabled OR
                               mavenbuildcacheperformance.buildcaches.remote.isenabled)          build_cache_enabled
                            , id                                                                 build_id
                            , ARRAY_JOIN(mavenattributes.requestedgoals, ' ')                    requested_goals
                            , mavenbuildcacheperformance.goalexecution                           goals
                            , startdate                                                          build_start_date
                            , mavenattributes.tags                                               tags
                            , mavenattributes.hasfailed                                          has_failed
                            , COALESCE(mavenbuildcacheperformance.serializationfactor, 1)        serialization_factor
                            , mavenattributes.buildduration                                      build_duration_millis
                            , type                                                               build_tool
                            , mavenattributes.buildstarttime                                     build_start_time
  FROM "develocity-db".build
  WHERE (type = 'maven'))
SELECT build_id
     , build_tool
     , build_start_date
     , build_start_time
     , remote_build_cache_enabled
     , remote_build_cache_push_enabled
     , remote_build_cache_disabled_due_to_error
     , local_build_cache_enabled
     , local_build_cache_push_enabled
     , local_build_cache_disabled_due_to_error
     , build_cache_enabled
     , requested_goals
     , projectname
     , has_failed
     , build_duration_millis
     , tags
     , (CASE
            WHEN (contains(tags, 'CI') = true) THEN 'CI'
            WHEN (COALESCE(CONTAINS(tags, 'CI'), false) = false) THEN 'Local' END)             environment
     , goalexecution.mojotype                                                                  goal_mojo_type
     , goalexecution.duration                                                                  goal_duration_millis
     , goalexecution.avoidanceoutcome                                                          avoidance_outcome
     , goalexecution.avoidancesavings                                                          avoidance_savings_millis
     , goalexecution.cacheartifactsize                                                         cache_artifact_size
     , goalexecution.fingerprintingduration                                                    fingerprinting_duration_millis
     , serialization_factor
     , goalexecution.noncacheabilitycategory                                                   non_cacheability_category
     , goalexecution.cachekey                                                                  goal_cachekey
     , goalexecution.goalname                                                                  goal_path
     , COALESCE(t.category, 'other')                                                           goal_category
     , (CASE
            WHEN (goalexecution.noncacheabilitycategory = 'build_cache_disabled_by_user') THEN 'potentially_avoidable'
            WHEN (goalexecution.noncacheabilitycategory = 'no_gradle_enterprise_server_configured')
                THEN 'potentially_avoidable'
            WHEN (goalexecution.noncacheabilitycategory = 'no_develocity_server_configured')
                THEN 'potentially_avoidable'
            WHEN (goalexecution.noncacheabilitycategory = 'non_clean_build') THEN 'potentially_avoidable'
            WHEN (goalexecution.noncacheabilitycategory = 'goal_execution_marked_non_cacheable') THEN 'unavoidable'
            WHEN (goalexecution.noncacheabilitycategory = 'goal_not_supported') THEN 'unavoidable'
            WHEN (goalexecution.noncacheabilitycategory = 'cache-if_condition_not_matched') THEN 'unavoidable'
            WHEN (goalexecution.noncacheabilitycategory = 'disabled_to_ensure_correctness') THEN 'unavoidable'
            WHEN (goalexecution.noncacheabilitycategory = 'not_entitled') THEN 'unknown'
            WHEN (goalexecution.noncacheabilitycategory = 'unknown') THEN 'unknown'
            WHEN (goalexecution.noncacheabilitycategory = 'unknown_entitlements') THEN 'unknown'
            WHEN (goalexecution.noncacheabilitycategory = 'offline_build') THEN 'unknown' END) category
FROM ((maven_goals
    CROSS JOIN UNNEST(goals) t (goalexecution))
    LEFT JOIN task_mapping t ON ((goalexecution.mojotype LIKE t.typematch) OR (goalexecution.mojotype = t.typename)))
WHERE ((projectname IS NOT NULL) AND (serialization_factor <> 0) AND (goalexecution.cachekey IS NOT NULL));

CREATE
OR REPLACE VIEW "unit_execution_summary" AS
SELECT build_id
     , build_tool
     , build_start_date
     , build_start_time
     , remote_build_cache_enabled
     , remote_build_cache_push_enabled
     , remote_build_cache_disabled_due_to_error
     , local_build_cache_enabled
     , local_build_cache_push_enabled
     , local_build_cache_disabled_due_to_error
     , build_cache_enabled
     , requested_goals      requested_goals_or_tasks
     , projectname
     , has_failed
     , build_duration_millis
     , tags
     , environment
     , goal_mojo_type       goal_or_task_type
     , goal_duration_millis goal_or_task_duration_millis
     , avoidance_outcome
     , avoidance_savings_millis
     , cache_artifact_size
     , fingerprinting_duration_millis
     , serialization_factor
     , non_cacheability_category
     , goal_cachekey        goal_or_task_cache_key
     , goal_path            goal_or_task_path
     , goal_category        goal_or_task_category
     , category
FROM maven_goal_summary
UNION
SELECT build_id
     , build_tool
     , build_start_date
     , build_start_time
     , remote_build_cache_enabled
     , remote_build_cache_push_enabled
     , remote_build_cache_disabled_due_to_error
     , local_build_cache_enabled
     , local_build_cache_push_enabled
     , local_build_cache_disabled_due_to_error
     , build_cache_enabled
     , requested_tasks      requested_goals_or_tasks
     , projectname
     , has_failed
     , build_duration_millis
     , tags
     , environment
     , task_type            goal_or_task_type
     , task_duration_millis goal_or_task_duration_millis
     , avoidance_outcome
     , avoidance_savings_millis
     , cache_artifact_size
     , fingerprinting_duration_millis
     , serialization_factor
     , non_cacheability_category
     , task_cachekey        goal_or_task_cache_key
     , task_path            goal_or_task_path
     , task_category        goal_or_task_category
     , category
FROM gradle_task_summary;

CREATE
OR REPLACE VIEW "plugin_summary" AS
SELECT build.id                                                                          build_id,
       COALESCE(plugins.id, plugins.classname)                                           plugin_id,
       plugins.version                                                                   version,
       plugins.projects                                                                  modules,
       startdate                                                                         build_start_date,
       gradleattributes.rootprojectname                                                  projectname,
       type                                                                              build_tool,
       gradleattributes.buildduration                                                    build_duration_millis,
       (CASE
            WHEN (CONTAINS(build.gradleattributes.tags, 'CI') = true) THEN 'CI'
            WHEN (CONTAINS(build.gradleattributes.tags, 'CI') = false) THEN 'Local' END) environment
FROM "develocity-db"."build",
     unnest(build.gradleplugins.plugins) as t(plugins)
WHERE (gradleattributes.rootprojectname IS NOT NULL)

UNION ALL
SELECT build.id                                                                         build_id,
       plugins.name                                                                     plugin_id,
       plugins.version                                                                  version,
       plugins.modules                                                                  modules,
       startdate                                                                        build_start_date,
       mavenattributes.toplevelprojectname                                              projectname,
       type                                                                             build_tool,
       mavenattributes.buildduration                                                    build_duration_millis,
       (CASE
            WHEN (CONTAINS(build.mavenattributes.tags, 'CI') = true) THEN 'CI'
            WHEN (CONTAINS(build.mavenattributes.tags, 'CI') = false) THEN 'Local' END) environment
FROM "develocity-db"."build",
     unnest(build.mavenplugins.plugins) as t(plugins)
WHERE (mavenattributes.toplevelprojectname IS NOT NULL);

CREATE
OR REPLACE VIEW test_performance_summary AS
  WITH gradle_builds AS (SELECT id                                                                                                                                   build_id,
                                startdate                                                                                                                            build_start_date,
                                gradleattributes.buildstarttime                                                                                                      build_start_time,
                                gradleattributes.buildduration                                                                                                       build_duration_millis,
                                ARRAY_JOIN(gradleattributes.requestedtasks, ' ')                                                                                     build_requested_tasks_or_goals,
                                type                                                                                                                                 build_tool,
                                gradletestperformance.tests.testclassescount                                                                                         build_test_classes_count,
                                gradletestperformance.serialTestTasksExecutionTime                                                                                   build_serial_test_work_units_execution_time,
                                gradletestperformance.testAcceleration.predictiveTestSelection.usage.status                                                          build_test_acceleration_pts_usage_status,
                                gradletestperformance.testAcceleration.predictiveTestSelection.usage.wallClockSavings                                                build_test_acceleration_pts_usage_wall_clock_savings_millis,
                                gradletestperformance.testAcceleration.predictiveTestSelection.usage.serialTimeSavings                                               build_test_acceleration_pts_usage_serial_time_savings_millis,
                                gradletestperformance.testAcceleration.predictiveTestSelection.simulation.conservative.wallClockSavingsPotential                     build_test_acceleration_pts_simulation_conservative_wall_clock_savings_potential_millis,
                                gradletestperformance.testAcceleration.predictiveTestSelection.simulation.conservative.serialTimeSavingsPotential                    build_test_acceleration_pts_simulation_conservative_serial_time_savings_potential_millis,
                                gradletestperformance.testAcceleration.predictiveTestSelection.simulation.conservative.workUnitFailuresPredictedCount                build_test_acceleration_pts_simulation_conservative_work_unit_failures_predicted_count,
                                gradletestperformance.testAcceleration.predictiveTestSelection.simulation.conservative.workUnitFailuresMissedCount                   build_test_acceleration_pts_simulation_conservative_work_unit_failures_missed_count,
                                gradletestperformance.testAcceleration.predictiveTestSelection.simulation.conservative.avoidableTestClassesCount                     build_test_acceleration_pts_simulation_conservative_avoidable_test_classes_count,
                                gradletestperformance.testAcceleration.predictiveTestSelection.simulation.conservative.unavoidableTestClassesCount                   build_test_acceleration_pts_simulation_conservative_unavoidable_test_classes_count,
                                gradletestperformance.testAcceleration.predictiveTestSelection.simulation.conservative.testClassesCountSelectedDueToInsufficientData build_test_acceleration_pts_simulation_conservative_test_classes_count_selected_due_to_insufficient_data,
                                gradletestperformance.testAcceleration.predictiveTestSelection.simulation.standard.wallClockSavingsPotential                         build_test_acceleration_pts_simulation_standard_wall_clock_savings_potential_millis,
                                gradletestperformance.testAcceleration.predictiveTestSelection.simulation.standard.serialTimeSavingsPotential                        build_test_acceleration_pts_simulation_standard_serial_time_savings_potential_millis,
                                gradletestperformance.testAcceleration.predictiveTestSelection.simulation.standard.workUnitFailuresPredictedCount                    build_test_acceleration_pts_simulation_standard_work_unit_failures_predicted_count,
                                gradletestperformance.testAcceleration.predictiveTestSelection.simulation.standard.workUnitFailuresMissedCount                       build_test_acceleration_pts_simulation_standard_work_unit_failures_missed_count,
                                gradletestperformance.testAcceleration.predictiveTestSelection.simulation.standard.avoidableTestClassesCount                         build_test_acceleration_pts_simulation_standard_avoidable_test_classes_count,
                                gradletestperformance.testAcceleration.predictiveTestSelection.simulation.standard.unavoidableTestClassesCount                       build_test_acceleration_pts_simulation_standard_unavoidable_test_classes_count,
                                gradletestperformance.testAcceleration.predictiveTestSelection.simulation.standard.testClassesCountSelectedDueToInsufficientData     build_test_acceleration_pts_simulation_standard_test_classes_count_selected_due_to_insufficient_data,
                                gradletestperformance.testAcceleration.predictiveTestSelection.simulation.fast.wallClockSavingsPotential                             build_test_acceleration_pts_simulation_fast_wall_clock_savings_potential_millis,
                                gradletestperformance.testAcceleration.predictiveTestSelection.simulation.fast.serialTimeSavingsPotential                            build_test_acceleration_pts_simulation_fast_serial_time_savings_potential_millis,
                                gradletestperformance.testAcceleration.predictiveTestSelection.simulation.fast.workUnitFailuresPredictedCount                        build_test_acceleration_pts_simulation_fast_work_unit_failures_predicted_count,
                                gradletestperformance.testAcceleration.predictiveTestSelection.simulation.fast.workUnitFailuresMissedCount                           build_test_acceleration_pts_simulation_fast_work_unit_failures_missed_count,
                                gradletestperformance.testAcceleration.predictiveTestSelection.simulation.fast.avoidableTestClassesCount                             build_test_acceleration_pts_simulation_fast_avoidable_test_classes_count,
                                gradletestperformance.testAcceleration.predictiveTestSelection.simulation.fast.unavoidableTestClassesCount                           build_test_acceleration_pts_simulation_fast_unavoidable_test_classes_count,
                                gradletestperformance.testAcceleration.predictiveTestSelection.simulation.fast.testClassesCountSelectedDueToInsufficientData         build_test_acceleration_pts_simulation_fast_test_classes_count_selected_due_to_insufficient_data,
                                gradletestperformance.testAcceleration.testDistribution.usageStatus                                                                  build_test_acceleration_td_usage_status,
                                gradletestperformance.testAcceleration.testDistribution.wallClockSavings                                                             build_test_acceleration_td_wall_clock_savings_millis,
                                gradletestperformance.testAcceleration.wallClockSavings                                                                              build_test_acceleration_wall_clock_savings_combined_millis,
                                gradleattributes.rootprojectname                                                                                                     projectname,
                                (CASE
                                  WHEN (CONTAINS(build.gradleattributes.tags, 'CI') = true) THEN 'CI'
                                  WHEN (CONTAINS(build.gradleattributes.tags, 'CI') = false) THEN 'Local' END)                                                       environment,
                                gradletestperformance.testTasks                                                                                                      testTasks
                         FROM "develocity-db"."build"
                         WHERE (type = 'gradle')),
       maven_builds AS  (SELECT id                                                                                                                                  build_id,
                                startdate                                                                                                                           build_start_date,
                                mavenattributes.buildstarttime                                                                                                      build_start_time,
                                mavenattributes.buildduration                                                                                                       build_duration_millis,
                                ARRAY_JOIN(mavenattributes.requestedgoals, ' ')                                                                                     build_requested_tasks_or_goals,
                                type                                                                                                                                build_tool,
                                maventestperformance.tests.testclassescount                                                                                         build_test_classes_count,
                                maventestperformance.serialTestGoalsExecutionTime                                                                                   build_serial_test_work_units_execution_time,
                                maventestperformance.testAcceleration.predictiveTestSelection.usage.status                                                          build_test_acceleration_pts_usage_status,
                                maventestperformance.testAcceleration.predictiveTestSelection.usage.wallClockSavings                                                build_test_acceleration_pts_usage_wall_clock_savings_millis,
                                maventestperformance.testAcceleration.predictiveTestSelection.usage.serialTimeSavings                                               build_test_acceleration_pts_usage_serial_time_savings_millis,
                                maventestperformance.testAcceleration.predictiveTestSelection.simulation.conservative.wallClockSavingsPotential                     build_test_acceleration_pts_simulation_conservative_wall_clock_savings_potential_millis,
                                maventestperformance.testAcceleration.predictiveTestSelection.simulation.conservative.serialTimeSavingsPotential                    build_test_acceleration_pts_simulation_conservative_serial_time_savings_potential_millis,
                                maventestperformance.testAcceleration.predictiveTestSelection.simulation.conservative.workUnitFailuresPredictedCount                build_test_acceleration_pts_simulation_conservative_work_unit_failures_predicted_count,
                                maventestperformance.testAcceleration.predictiveTestSelection.simulation.conservative.workUnitFailuresMissedCount                   build_test_acceleration_pts_simulation_conservative_work_unit_failures_missed_count,
                                maventestperformance.testAcceleration.predictiveTestSelection.simulation.conservative.avoidableTestClassesCount                     build_test_acceleration_pts_simulation_conservative_avoidable_test_classes_count,
                                maventestperformance.testAcceleration.predictiveTestSelection.simulation.conservative.unavoidableTestClassesCount                   build_test_acceleration_pts_simulation_conservative_unavoidable_test_classes_count,
                                maventestperformance.testAcceleration.predictiveTestSelection.simulation.conservative.testClassesCountSelectedDueToInsufficientData build_test_acceleration_pts_simulation_conservative_test_classes_count_selected_due_to_insufficient_data,
                                maventestperformance.testAcceleration.predictiveTestSelection.simulation.standard.wallClockSavingsPotential                         build_test_acceleration_pts_simulation_standard_wall_clock_savings_potential_millis,
                                maventestperformance.testAcceleration.predictiveTestSelection.simulation.standard.serialTimeSavingsPotential                        build_test_acceleration_pts_simulation_standard_serial_time_savings_potential_millis,
                                maventestperformance.testAcceleration.predictiveTestSelection.simulation.standard.workUnitFailuresPredictedCount                    build_test_acceleration_pts_simulation_standard_work_unit_failures_predicted_count,
                                maventestperformance.testAcceleration.predictiveTestSelection.simulation.standard.workUnitFailuresMissedCount                       build_test_acceleration_pts_simulation_standard_work_unit_failures_missed_count,
                                maventestperformance.testAcceleration.predictiveTestSelection.simulation.standard.avoidableTestClassesCount                         build_test_acceleration_pts_simulation_standard_avoidable_test_classes_count,
                                maventestperformance.testAcceleration.predictiveTestSelection.simulation.standard.unavoidableTestClassesCount                       build_test_acceleration_pts_simulation_standard_unavoidable_test_classes_count,
                                maventestperformance.testAcceleration.predictiveTestSelection.simulation.standard.testClassesCountSelectedDueToInsufficientData     build_test_acceleration_pts_simulation_standard_test_classes_count_selected_due_to_insufficient_data,
                                maventestperformance.testAcceleration.predictiveTestSelection.simulation.fast.wallClockSavingsPotential                             build_test_acceleration_pts_simulation_fast_wall_clock_savings_potential_millis,
                                maventestperformance.testAcceleration.predictiveTestSelection.simulation.fast.serialTimeSavingsPotential                            build_test_acceleration_pts_simulation_fast_serial_time_savings_potential_millis,
                                maventestperformance.testAcceleration.predictiveTestSelection.simulation.fast.workUnitFailuresPredictedCount                        build_test_acceleration_pts_simulation_fast_work_unit_failures_predicted_count,
                                maventestperformance.testAcceleration.predictiveTestSelection.simulation.fast.workUnitFailuresMissedCount                           build_test_acceleration_pts_simulation_fast_work_unit_failures_missed_count,
                                maventestperformance.testAcceleration.predictiveTestSelection.simulation.fast.avoidableTestClassesCount                             build_test_acceleration_pts_simulation_fast_avoidable_test_classes_count,
                                maventestperformance.testAcceleration.predictiveTestSelection.simulation.fast.unavoidableTestClassesCount                           build_test_acceleration_pts_simulation_fast_unavoidable_test_classes_count,
                                maventestperformance.testAcceleration.predictiveTestSelection.simulation.fast.testClassesCountSelectedDueToInsufficientData         build_test_acceleration_pts_simulation_fast_test_classes_count_selected_due_to_insufficient_data,
                                maventestperformance.testAcceleration.testDistribution.usageStatus                                                                  build_test_acceleration_td_usage_status,
                                maventestperformance.testAcceleration.testDistribution.wallClockSavings                                                             build_test_acceleration_td_wall_clock_savings_millis,
                                maventestperformance.testAcceleration.wallClockSavings                                                                              build_test_acceleration_wall_clock_savings_combined_millis,
                                mavenattributes.topLevelProjectName                                                                                                 projectname,
                                (CASE
                                  WHEN (CONTAINS(build.mavenattributes.tags, 'CI') = true) THEN 'CI'
                                  WHEN (CONTAINS(build.mavenattributes.tags, 'CI') = false) THEN 'Local' END)                                                       environment,
                                maventestperformance.testGoals                                                                                                      testGoals
                         FROM "develocity-db"."build"
                        WHERE (type = 'maven'))
SELECT
    build_id,
    build_start_date,
    build_start_time,
    build_duration_millis,
    build_requested_tasks_or_goals,
    build_tool,
    build_test_classes_count,
    build_serial_test_work_units_execution_time,
    build_test_acceleration_pts_usage_status,
    build_test_acceleration_pts_usage_wall_clock_savings_millis,
    build_test_acceleration_pts_usage_serial_time_savings_millis,
    build_test_acceleration_pts_simulation_conservative_wall_clock_savings_potential_millis,
    build_test_acceleration_pts_simulation_conservative_serial_time_savings_potential_millis,
    build_test_acceleration_pts_simulation_conservative_work_unit_failures_predicted_count,
    build_test_acceleration_pts_simulation_conservative_work_unit_failures_missed_count,
    build_test_acceleration_pts_simulation_conservative_avoidable_test_classes_count,
    build_test_acceleration_pts_simulation_conservative_unavoidable_test_classes_count,
    build_test_acceleration_pts_simulation_conservative_test_classes_count_selected_due_to_insufficient_data,
    build_test_acceleration_pts_simulation_standard_wall_clock_savings_potential_millis,
    build_test_acceleration_pts_simulation_standard_serial_time_savings_potential_millis,
    build_test_acceleration_pts_simulation_standard_work_unit_failures_predicted_count,
    build_test_acceleration_pts_simulation_standard_work_unit_failures_missed_count,
    build_test_acceleration_pts_simulation_standard_avoidable_test_classes_count,
    build_test_acceleration_pts_simulation_standard_unavoidable_test_classes_count,
    build_test_acceleration_pts_simulation_standard_test_classes_count_selected_due_to_insufficient_data,
    build_test_acceleration_pts_simulation_fast_wall_clock_savings_potential_millis,
    build_test_acceleration_pts_simulation_fast_serial_time_savings_potential_millis,
    build_test_acceleration_pts_simulation_fast_work_unit_failures_predicted_count,
    build_test_acceleration_pts_simulation_fast_work_unit_failures_missed_count,
    build_test_acceleration_pts_simulation_fast_avoidable_test_classes_count,
    build_test_acceleration_pts_simulation_fast_unavoidable_test_classes_count,
    build_test_acceleration_pts_simulation_fast_test_classes_count_selected_due_to_insufficient_data,
    build_test_acceleration_td_usage_status,
    build_test_acceleration_td_wall_clock_savings_millis,
    build_test_acceleration_wall_clock_savings_combined_millis,
    projectname,
    environment,
    testTask.taskPath                                                                                                       work_unit_path,
    testTask.taskType work_unit_type,
    testTask.wallClockExecutionTime                                                                                         work_unit_wall_clock_execution_time,
    testTask.serialExecutionTime                                                                                            work_unit_serial_execution_time,
    testTask.tests.failedTestClassesCount                                                                                   work_unit_failed_test_classes_count,
    testTask.tests.testClassesCount                                                                                         work_unit_test_classes_count,
    testTask.testAcceleration.predictiveTestSelection.usage.status                                                          work_unit_test_acceleration_pts_usage_status,
    testTask.testAcceleration.predictiveTestSelection.usage.wallClockSavings                                                work_unit_test_acceleration_pts_usage_wall_clock_savings_millis,
    testTask.testAcceleration.predictiveTestSelection.usage.serialTimeSavings                                               work_unit_test_acceleration_pts_usage_serial_time_savings_millis,
    testTask.testAcceleration.predictiveTestSelection.usage.nonSelectedTestClassesCount                                     work_unit_test_acceleration_pts_usage_non_selected_test_classes_count,
    testTask.testAcceleration.predictiveTestSelection.simulation.conservative.wallClockSavingsPotential                     work_unit_test_acceleration_pts_simulation_conservative_wall_clock_savings_potential_millis,
    testTask.testAcceleration.predictiveTestSelection.simulation.conservative.serialTimeSavingsPotential                    work_unit_test_acceleration_pts_simulation_conservative_serial_time_savings_potential_millis,
    testTask.testAcceleration.predictiveTestSelection.simulation.conservative.avoidableTestClassesCount                     work_unit_test_acceleration_pts_simulation_conservative_avoidable_test_classes_count,
    testTask.testAcceleration.predictiveTestSelection.simulation.conservative.unavoidableTestClassesCount                   work_unit_test_acceleration_pts_simulation_conservative_unavoidable_test_classes_count,
    testTask.testAcceleration.predictiveTestSelection.simulation.conservative.testClassesCountSelectedDueToInsufficientData work_unit_test_acceleration_pts_simulation_conservative_test_classes_count_selected_due_to_insufficient_data,
    testTask.testAcceleration.predictiveTestSelection.simulation.conservative.failedTestClassesPredictedCount               work_unit_test_acceleration_pts_simulation_conservative_failed_test_classes_predicted_count,
    testTask.testAcceleration.predictiveTestSelection.simulation.standard.wallClockSavingsPotential                         work_unit_test_acceleration_pts_simulation_standard_wall_clock_savings_potential_millis,
    testTask.testAcceleration.predictiveTestSelection.simulation.standard.serialTimeSavingsPotential                        work_unit_test_acceleration_pts_simulation_standard_serial_time_savings_potential_millis,
    testTask.testAcceleration.predictiveTestSelection.simulation.standard.avoidableTestClassesCount                         work_unit_test_acceleration_pts_simulation_standard_avoidable_test_classes_count,
    testTask.testAcceleration.predictiveTestSelection.simulation.standard.unavoidableTestClassesCount                       work_unit_test_acceleration_pts_simulation_standard_unavoidable_test_classes_count,
    testTask.testAcceleration.predictiveTestSelection.simulation.standard.testClassesCountSelectedDueToInsufficientData     work_unit_test_acceleration_pts_simulation_standard_test_classes_count_selected_due_to_insufficient_data,
    testTask.testAcceleration.predictiveTestSelection.simulation.standard.failedTestClassesPredictedCount                   work_unit_test_acceleration_pts_simulation_standard_failed_test_classes_predicted_count,
    testTask.testAcceleration.predictiveTestSelection.simulation.fast.wallClockSavingsPotential                             work_unit_test_acceleration_pts_simulation_fast_wall_clock_savings_potential_millis,
    testTask.testAcceleration.predictiveTestSelection.simulation.fast.serialTimeSavingsPotential                            work_unit_test_acceleration_pts_simulation_fast_serial_time_savings_potential_millis,
    testTask.testAcceleration.predictiveTestSelection.simulation.fast.avoidableTestClassesCount                             work_unit_test_acceleration_pts_simulation_fast_avoidable_test_classes_count,
    testTask.testAcceleration.predictiveTestSelection.simulation.fast.unavoidableTestClassesCount                           work_unit_test_acceleration_pts_simulation_fast_unavoidable_test_classes_count,
    testTask.testAcceleration.predictiveTestSelection.simulation.fast.testClassesCountSelectedDueToInsufficientData         work_unit_test_acceleration_pts_simulation_fast_test_classes_count_selected_due_to_insufficient_data,
    testTask.testAcceleration.predictiveTestSelection.simulation.fast.failedTestClassesPredictedCount                       work_unit_test_acceleration_pts_simulation_fast_failed_test_classes_predicted_count,
    testTask.testAcceleration.testDistribution.usageStatus                                                                  work_unit_test_acceleration_td_usage_status,
    testTask.testAcceleration.testDistribution.wallClockSavings                                                             work_unit_test_acceleration_td_wall_clock_savings_millis,
    testTask.testAcceleration.testDistribution.remoteTestClassesCount                                                       work_unit_test_acceleration_td_remote_test_classes_count,
    testTask.testAcceleration.wallClockSavings                                                                              work_unit_test_acceleration_wall_clock_savings_combined_millis
FROM (
         gradle_builds CROSS JOIN UNNEST(testTasks) AS t(testTask)
     )
WHERE (projectname IS NOT NULL)

UNION ALL

SELECT
    build_id,
    build_start_date,
    build_start_time,
    build_duration_millis,
    build_requested_tasks_or_goals,
    build_tool,
    build_test_classes_count,
    build_serial_test_work_units_execution_time,
    build_test_acceleration_pts_usage_status,
    build_test_acceleration_pts_usage_wall_clock_savings_millis,
    build_test_acceleration_pts_usage_serial_time_savings_millis,
    build_test_acceleration_pts_simulation_conservative_wall_clock_savings_potential_millis,
    build_test_acceleration_pts_simulation_conservative_serial_time_savings_potential_millis,
    build_test_acceleration_pts_simulation_conservative_work_unit_failures_predicted_count,
    build_test_acceleration_pts_simulation_conservative_work_unit_failures_missed_count,
    build_test_acceleration_pts_simulation_conservative_avoidable_test_classes_count,
    build_test_acceleration_pts_simulation_conservative_unavoidable_test_classes_count,
    build_test_acceleration_pts_simulation_conservative_test_classes_count_selected_due_to_insufficient_data,
    build_test_acceleration_pts_simulation_standard_wall_clock_savings_potential_millis,
    build_test_acceleration_pts_simulation_standard_serial_time_savings_potential_millis,
    build_test_acceleration_pts_simulation_standard_work_unit_failures_predicted_count,
    build_test_acceleration_pts_simulation_standard_work_unit_failures_missed_count,
    build_test_acceleration_pts_simulation_standard_avoidable_test_classes_count,
    build_test_acceleration_pts_simulation_standard_unavoidable_test_classes_count,
    build_test_acceleration_pts_simulation_standard_test_classes_count_selected_due_to_insufficient_data,
    build_test_acceleration_pts_simulation_fast_wall_clock_savings_potential_millis,
    build_test_acceleration_pts_simulation_fast_serial_time_savings_potential_millis,
    build_test_acceleration_pts_simulation_fast_work_unit_failures_predicted_count,
    build_test_acceleration_pts_simulation_fast_work_unit_failures_missed_count,
    build_test_acceleration_pts_simulation_fast_avoidable_test_classes_count,
    build_test_acceleration_pts_simulation_fast_unavoidable_test_classes_count,
    build_test_acceleration_pts_simulation_fast_test_classes_count_selected_due_to_insufficient_data,
    build_test_acceleration_td_usage_status,
    build_test_acceleration_td_wall_clock_savings_millis,
    build_test_acceleration_wall_clock_savings_combined_millis,
    projectname,
    environment,
    testGoal.goalPath                                                                                                       work_unit_path,
    testGoal.goalType work_unit_type,
    testGoal.wallClockExecutionTime                                                                                         work_unit_wall_clock_execution_time,
    testGoal.serialExecutionTime                                                                                            work_unit_serial_execution_time,
    testGoal.tests.failedTestClassesCount                                                                                   work_unit_failed_test_classes_count,
    testGoal.tests.testClassesCount                                                                                         work_unit_test_classes_count,
    testGoal.testAcceleration.predictiveTestSelection.usage.status                                                          work_unit_test_acceleration_pts_usage_status,
    testGoal.testAcceleration.predictiveTestSelection.usage.wallClockSavings                                                work_unit_test_acceleration_pts_usage_wall_clock_savings_millis,
    testGoal.testAcceleration.predictiveTestSelection.usage.serialTimeSavings                                               work_unit_test_acceleration_pts_usage_serial_time_savings_millis,
    testGoal.testAcceleration.predictiveTestSelection.usage.nonSelectedTestClassesCount                                     work_unit_test_acceleration_pts_usage_non_selected_test_classes_count,
    testGoal.testAcceleration.predictiveTestSelection.simulation.conservative.wallClockSavingsPotential                     work_unit_test_acceleration_pts_simulation_conservative_wall_clock_savings_potential_millis,
    testGoal.testAcceleration.predictiveTestSelection.simulation.conservative.serialTimeSavingsPotential                    work_unit_test_acceleration_pts_simulation_conservative_serial_time_savings_potential_millis,
    testGoal.testAcceleration.predictiveTestSelection.simulation.conservative.avoidableTestClassesCount                     work_unit_test_acceleration_pts_simulation_conservative_avoidable_test_classes_count,
    testGoal.testAcceleration.predictiveTestSelection.simulation.conservative.unavoidableTestClassesCount                   work_unit_test_acceleration_pts_simulation_conservative_unavoidable_test_classes_count,
    testGoal.testAcceleration.predictiveTestSelection.simulation.conservative.testClassesCountSelectedDueToInsufficientData work_unit_test_acceleration_pts_simulation_conservative_test_classes_count_selected_due_to_insufficient_data,
    testGoal.testAcceleration.predictiveTestSelection.simulation.conservative.failedTestClassesPredictedCount               work_unit_test_acceleration_pts_simulation_conservative_failed_test_classes_predicted_count,
    testGoal.testAcceleration.predictiveTestSelection.simulation.standard.wallClockSavingsPotential                         work_unit_test_acceleration_pts_simulation_standard_wall_clock_savings_potential_millis,
    testGoal.testAcceleration.predictiveTestSelection.simulation.standard.serialTimeSavingsPotential                        work_unit_test_acceleration_pts_simulation_standard_serial_time_savings_potential_millis,
    testGoal.testAcceleration.predictiveTestSelection.simulation.standard.avoidableTestClassesCount                         work_unit_test_acceleration_pts_simulation_standard_avoidable_test_classes_count,
    testGoal.testAcceleration.predictiveTestSelection.simulation.standard.unavoidableTestClassesCount                       work_unit_test_acceleration_pts_simulation_standard_unavoidable_test_classes_count,
    testGoal.testAcceleration.predictiveTestSelection.simulation.standard.testClassesCountSelectedDueToInsufficientData     work_unit_test_acceleration_pts_simulation_standard_test_classes_count_selected_due_to_insufficient_data,
    testGoal.testAcceleration.predictiveTestSelection.simulation.standard.failedTestClassesPredictedCount                   work_unit_test_acceleration_pts_simulation_standard_failed_test_classes_predicted_count,
    testGoal.testAcceleration.predictiveTestSelection.simulation.fast.wallClockSavingsPotential                             work_unit_test_acceleration_pts_simulation_fast_wall_clock_savings_potential_millis,
    testGoal.testAcceleration.predictiveTestSelection.simulation.fast.serialTimeSavingsPotential                            work_unit_test_acceleration_pts_simulation_fast_serial_time_savings_potential_millis,
    testGoal.testAcceleration.predictiveTestSelection.simulation.fast.avoidableTestClassesCount                             work_unit_test_acceleration_pts_simulation_fast_avoidable_test_classes_count,
    testGoal.testAcceleration.predictiveTestSelection.simulation.fast.unavoidableTestClassesCount                           work_unit_test_acceleration_pts_simulation_fast_unavoidable_test_classes_count,
    testGoal.testAcceleration.predictiveTestSelection.simulation.fast.testClassesCountSelectedDueToInsufficientData         work_unit_test_acceleration_pts_simulation_fast_test_classes_count_selected_due_to_insufficient_data,
    testGoal.testAcceleration.predictiveTestSelection.simulation.fast.failedTestClassesPredictedCount                       work_unit_test_acceleration_pts_simulation_fast_failed_test_classes_predicted_count,
    testGoal.testAcceleration.testDistribution.usageStatus                                                                  work_unit_test_acceleration_td_usage_status,
    testGoal.testAcceleration.testDistribution.wallClockSavings                                                             work_unit_test_acceleration_td_wall_clock_savings_millis,
    testGoal.testAcceleration.testDistribution.remoteTestClassesCount                                                       work_unit_test_acceleration_td_remote_test_classes_count,
    testGoal.testAcceleration.wallClockSavings                                                                              work_unit_test_acceleration_wall_clock_savings_combined_millis
FROM (
         maven_builds CROSS JOIN UNNEST(testGoals) AS t(testGoal)
     )
WHERE (projectname IS NOT NULL);

CREATE OR REPLACE VIEW "dependency_summary" AS
WITH view_base AS (
    SELECT
        COALESCE(mavenattributes.toplevelprojectname, gradleattributes.rootprojectname)         projectname
        , COALESCE(gradleattributes.tags, mavenattributes.tags)                                 tags
        , id                                                                                    build_id
        , type                                                                                  build_tool
        , startdate                                                                             build_start_date
        , COALESCE(gradleattributes.buildduration, mavenattributes.buildduration)               build_duration_millis
        , COALESCE(gradleattributes."values", mavenattributes."values")                         custom_values
        , COALESCE(gradleDependencies.dependencies, mavenDependencies.dependencies)             dependencies
    FROM "develocity-db"."build"
)
SELECT view_base.build_id                                                                       build_id
     , concat(
        dependency.scheme, ':', dependency.type,
        if(dependency.namespace is null, '', concat('/', dependency.namespace)),
        '/', dependency.name)                                                                  dependency_unversioned_id
     , concat(
        dependency.scheme, ':', dependency.type,
        if(dependency.namespace is null, '', concat('/', dependency.namespace)),
        '/', dependency.name,
        if(dependency.version is null, '', concat('@', dependency.version)))                   dependency_versioned_id
     , dependency.scheme                                                                        scheme
     , dependency.type                                                                          type
     , dependency.namespace                                                                     namespace
     , dependency.name                                                                          name
     , dependency.version                                                                       version
     , dependency.qualifiers                                                                    qualifiers
     , JSON_FORMAT(CAST(dependency.qualifiers as JSON))                                         qualifiers_json
     , dependency.subpath                                                                       subpath
     , dependency.purl                                                                          purl
     , view_base.build_start_date                                                               build_start_date
     , view_base.build_duration_millis                                                          build_duration_millis
     , view_base.projectname                                                                    projectname
     , element_at(
        filter(view_base.custom_values, entry -> entry.name = 'Git repository')
    , 1
       ).value                                                                                  vcs_repo
     , view_base.build_tool                                                                     build_tool
     , (CASE
            WHEN (CONTAINS(view_base.tags, 'CI') = true) THEN 'CI'
            WHEN (CONTAINS(view_base.tags, 'CI') = false) THEN 'Local' END)                        environment
FROM view_base, unnest(dependencies) as t(dependency)
WHERE view_base.projectname IS NOT NULL;

CREATE
OR REPLACE VIEW "tool_mapping"
AS
SELECT *
FROM ((values ('gradle', 'Gradle'),
              ('maven', 'Maven'),
              ('python', 'Python'),
              ('sbt', 'sbt'),
              ('bazel', 'Bazel'),
              ('npm', 'npm')) as t(raw, display))