resource "aws_grafana_workspace" "develocity_drv_grafana" {
  account_access_type      = "CURRENT_ACCOUNT"
  authentication_providers = ["AWS_SSO"]
  name                     = "${var.prefix}develocity-drv-grafana"
  description              = "Develocity DRV Grafana"
  permission_type          = "SERVICE_MANAGED"
  grafana_version          = "10.4"

  data_sources = ["ATHENA"]

  configuration = "{\"plugins\": {\"pluginAdminEnabled\": true}, \"unifiedAlerting\": {\"enabled\": false} }"

  role_arn = aws_iam_role.develocity_drv_grafana_grafana_workspace_role.arn
}


resource "aws_grafana_role_association" "develocity_drv_grafana_admin_role_association" {
  role         = "ADMIN"
  group_ids    = var.develocity_drv_grafana_admin_group_ids
  user_ids     = var.develocity_drv_grafana_admin_user_ids
  workspace_id = aws_grafana_workspace.develocity_drv_grafana.id
}
