locals {
  module_path    = path.module
  dashboard_path = "${var.dashboard_folder_path}/"
  dashboards     = fileset(local.dashboard_path, "**/*")
  dashboard_dirs = toset([for d in local.dashboards : dirname(d)])
}

resource "grafana_folder" "drv_folder" {
  for_each = local.dashboard_dirs

  title = each.value
  uid   = "dir-${lower(replace(replace(each.value, "/^\\d+ - /", ""), " ", "_"))}"
}


resource "grafana_dashboard" "drv_dashboard" {
  for_each = local.dashboards

  config_json = replace(file("${local.dashboard_path}/${each.key}"), "athena-datasource-uid-placeholder", trim(var.datasource_id, "\""))
  folder      = grafana_folder.drv_folder[dirname(each.key)].id
}
