variable "bucket_name" {
  type        = string
  description = "The name of the bucket where the build models are exported"
}

variable "develocity_drv_grafana_admin_group_ids" {
  default = []
  type = list(string)
  description = "The list of AWS SSO ids of groups that should have ADMIN privileges on the Grafana instance"
}

variable "develocity_drv_grafana_admin_user_ids" {
  default = []
  type = list(string)
  description = "The list of AWS SSO ids of users that should have ADMIN privileges on the Grafana instance"
}

variable "aws_region" {
  type        = string
  description = "The AWS region where the resources will be deployed"
}

variable "aws_profile" {
  type        = string
  description = "The AWS profile to use for the deployment"
}

variable "prefix" {
  type        = string
  default     = ""
  description = "The optional prefix to use for the resources"
}
