CREATE
OR REPLACE VIEW "build_summary" AS
        WITH view_base AS (SELECT COALESCE(mavenattributes.toplevelprojectname, gradleattributes.rootprojectname)       projectname
                                , ARRAY_JOIN(COALESCE(mavenattributes.requestedgoals, gradleattributes.requestedtasks),
                                             ' ')                                                                       requested_goals_or_tasks
                                , COALESCE(mavenattributes.environment.username, gradleattributes.environment.username) username
                                , COALESCE(mavenattributes.buildduration, gradleattributes.buildduration)               build_duration_millis
                                , COALESCE(mavenattributes.tags, gradleattributes.tags)                                 tags
                                , COALESCE(mavenattributes.hasfailed, gradleattributes.hasfailed)                       has_failed
                                , COALESCE(mavenattributes.hasnonverificationfailure,
                                           gradleattributes.hasnonverificationfailure)                                  has_non_verification_failure
                                , COALESCE(mavenattributes.hasverificationfailure,
                                           gradleattributes.hasverificationfailure)                                     has_verification_failure
                                , COALESCE("mavenattributes"."environment".publichostname,
                                           "gradleattributes"."environment".publichostname)                             hostname
                                , COALESCE("mavenattributes"."environment".operatingsystem,
                                           "gradleattributes"."environment".operatingsystem)                            operatingsystem
                                , COALESCE(gradlebuildcacheperformance.avoidancesavingssummary.localbuildcache,
                                           mavenbuildcacheperformance.avoidancesavingssummary.localbuildcache)          local_build_cache_avoidance_millis
                                , COALESCE(gradlebuildcacheperformance.avoidancesavingssummary.remotebuildcache,
                                           mavenbuildcacheperformance.avoidancesavingssummary.remotebuildcache)         remote_build_cache_avoidance_millis
                                , COALESCE("gradlebuildcacheperformance"."buildcaches"."local"."isenabled",
                                           "mavenbuildcacheperformance"."buildcaches"."local"."isenabled")              local_build_cache_enabled
                                , COALESCE("gradlebuildcacheperformance"."buildcaches"."local"."ispushenabled",
                                           "mavenbuildcacheperformance"."buildcaches"."local"."ispushenabled")          local_build_cache_push_enabled
                                , COALESCE("gradlebuildcacheperformance"."buildcaches"."local"."isdisabledduetoerror",
                                           "mavenbuildcacheperformance"."buildcaches"."local"."isdisabledduetoerror")   local_build_cache_disabled_due_to_error
                                , COALESCE("gradlebuildcacheperformance"."buildcaches"."remote"."isenabled",
                                           "mavenbuildcacheperformance"."buildcaches"."remote"."isenabled")             remote_build_cache_enabled
                                , COALESCE("gradlebuildcacheperformance"."buildcaches"."remote"."ispushenabled",
                                           "mavenbuildcacheperformance"."buildcaches"."remote"."ispushenabled")         remote_build_cache_push_enabled
                                , COALESCE("gradlebuildcacheperformance"."buildcaches"."remote"."isdisabledduetoerror",
                                           "mavenbuildcacheperformance"."buildcaches"."remote"."isdisabledduetoerror")  remote_build_cache_disabled_due_to_error
                                , REGEXP_REPLACE(
                    COALESCE(mavenattributes.environment.jvmversion, gradleattributes.environment.jvmversion),
                    '^([0-9a-zA-Z_\-.]+).*(OpenJDK|Java HotSpot).*VM.*?([\d\.?]+).*', '$1 $2 $3')                       jvm_version
                                , COALESCE(gradleattributes.buildoptions.parallelprojectexecutionenabled,
                                           (mavenattributes.buildoptions.maxnumberofthreads > 1))                       parallel_enabled
                                , COALESCE(gradleattributes.buildoptions.buildcacheenabled,
                                           (mavenbuildcacheperformance.buildcaches.local.isenabled OR
                                            mavenbuildcacheperformance.buildcaches.remote.isenabled))                   build_cache_enabled
                                , COALESCE(gradleattributes.buildoptions.configurationcacheenabled, false)              config_cache_enabled
                                , COALESCE(gradleattributes.buildoptions.reruntasksenabled,
                                           mavenattributes.buildoptions.rerungoals)                                     rerun_tasks_enabled
                                , COALESCE(gradleattributes.buildoptions.refreshdependenciesenabled,
                                           mavenattributes.buildoptions.updatesnapshotsenabled)                         refresh_dependencies_enabled
                                , COALESCE(gradleattributes.develocitysettings.backgroundpublicationenabled,
                                           mavenattributes.develocitysettings.backgroundpublicationenabled)             background_upload_enabled
                                , COALESCE(gradleattributes.develocitysettings.taskinputsfilecapturingenabled,
                                           mavenattributes.develocitysettings.goalinputsfilecapturingenabled)           input_file_capturing_enabled
                                , COALESCE(cardinality(gradleprojects), cardinality(mavenmodules))                      module_count
                                , COALESCE(
                    COALESCE(mavenbuildcacheperformance.serializationfactor, gradlebuildcacheperformance.serializationfactor),
                    1)                                                                                                  serialization_factor
                                , id                                                                                    build_id
                                , type                                                                                  build_tool
                                , startdate                                                                             build_start_date
                                , buildtoolversion                                                                      build_tool_version_full
                                , COALESCE("mavenattributes"."environment".numberOfCpuCores,
                                           "gradleattributes"."environment".numberOfCpuCores)                           number_of_cores
                                , COALESCE(gradleattributes.buildoptions.maxNumberOfGradleWorkers,
                                           mavenattributes.buildoptions.maxNumberOfThreads)                             number_of_workers
                                , COALESCE(gradleattributes."values", mavenattributes."values")                         custom_values
                                , COALESCE(gradlenetworkactivity.networkrequestcount,
                                           mavendependencyresolution.networkrequestcount)                               network_request_count
                                , COALESCE(gradleNetworkActivity.serialnetworkrequesttime,
                                           mavendependencyresolution.serialnetworkrequesttime)                          serial_network_request_time_millis
                                , COALESCE(gradleNetworkActivity.wallclocknetworkrequesttime,
                                           mavendependencyresolution.wallclocknetworkrequesttime)                       wall_clock_network_request_time_millis
                                , COALESCE(gradleNetworkActivity.filedownloadsize,
                                           mavendependencyresolution.filedownloadsize)                                  file_download_size
                                , COALESCE(gradleNetworkActivity.filedownloadcount,
                                           mavendependencyresolution.filedownloadcount)                                 file_download_count
                                , gradledeprecations.deprecations                                                       gradle_deprecations
                                , modelversion.year                                                                     release_year
                                , modelversion.release                                                                  release_number
                           FROM "develocity-db"."build")
SELECT projectname
     , requested_goals_or_tasks
     , username
     , build_duration_millis
     , has_failed
     , has_non_verification_failure
     , has_verification_failure
     , hostname
     , operatingsystem
     , build_cache_enabled
     , local_build_cache_avoidance_millis
     , remote_build_cache_avoidance_millis
     , local_build_cache_enabled
     , local_build_cache_push_enabled
     , local_build_cache_disabled_due_to_error
     , remote_build_cache_enabled
     , remote_build_cache_push_enabled
     , remote_build_cache_disabled_due_to_error
     , parallel_enabled
     , config_cache_enabled
     , rerun_tasks_enabled
     , refresh_dependencies_enabled
     , background_upload_enabled
     , input_file_capturing_enabled
     , module_count
     , serialization_factor
     , build_id
     , build_tool
     , build_start_date
     , build_tool_version_full
     , REGEXP_REPLACE(build_tool_version_full, '^(\d+\.\d+).*', '$1.x')          build_tool_version_major_minor
     , REGEXP_REPLACE(build_tool_version_full, '^(\d+).*', '$1.x')               build_tool_version_major
     , jvm_version                                                               jvm_version_full_vendored
     , REGEXP_REPLACE(jvm_version, '^([A-Za-z\s]+)\s[\d\.]+.*$', '$1')           jvm_version_vendor
     , REGEXP_REPLACE(jvm_version, '^[A-Za-z\s]+\s([\d\.]+).*$', '$1')           jvm_version_full
     , REGEXP_REPLACE(jvm_version, '^[A-Za-z\s]+\s([\d]+)\.?[\d\.]?.*$', '$1.x') jvm_version_major
     , (CASE
            WHEN REGEXP_LIKE(REGEXP_REPLACE(jvm_version, '^[A-Za-z\s]+\s(\d+\.?\d+)\.?\d*.*', '$1.x'), '\d+\.\d+')
                THEN REGEXP_REPLACE(jvm_version, '^[A-Za-z\s]+\s(\d+\.?\d+)\.?\d*.*', '$1.x')
            ELSE CONCAT(REGEXP_REPLACE(jvm_version, '^[A-Za-z\s]+\s(\d+\.?\d+)\.?\d*.*', '$1'),
                        '.0.x') END)                                             jvm_version_major_minor
     , (CASE
            WHEN (CONTAINS(tags, 'CI') = true) THEN 'CI'
            WHEN (CONTAINS(tags, 'CI') = false) THEN 'Local' END)                environment
     , custom_values
     , network_request_count
     , serial_network_request_time_millis
     , wall_clock_network_request_time_millis
     , file_download_size
     , file_download_count
     , number_of_cores
     , number_of_workers
     , gradle_deprecations
     , release_year
     , release_number
FROM view_base
WHERE (projectname IS NOT NULL);


CREATE
OR REPLACE VIEW "task_mapping" AS
select *
from ((values
           --CODEGEN MAVEN
           ('org.jvnet.jaxb.maven%', null, 'codegen'),
           ('org.jvnet.jaxb2.maven2%', null, 'codegen'),
           (null, 'io.openapitools.swagger.GenerateMojo', 'codegen'),
           (null, 'com.github.kongchen.swagger.docgen.mavenplugin.ApiDocumentMojo', 'codegen'),
           (null, 'org.codehaus.mojo.aspectj.AjcCompileMojo', 'codegen'),
           ('org.apache.avro.mojo%', null, 'codegen'),
           ('org.springframework.cloud.contract.maven.verifier.GenerateStubsMojo', null, 'codegen'),
           ('org.springframework.cloud.contract.maven.verifier.RunMojo', null, 'codegen'),
           ('com.graphql_java_generator.mavenplugin%', null, 'codegen'),
           ('org.xolstice.maven.plugin.protobuf%', null, 'codegen'),
           (null, 'org.antlr.mojo.antlr4.Antlr4Mojo', 'codegen'),
           --LINT MAVEN
           (null, 'org.apache.maven.plugins.checkstyle.CheckstyleViolationCheckMojo', 'lint'),
           (null, 'org.codehaus.mojo.spotbugs.SpotBugsMojo', 'lint'),
           ('org.apache.maven.plugins.pmd%', null, 'lint'),
           ('com.diffplug.spotless.maven%', null, 'lint'),
           ('org.codehaus.mojo.animal_sniffer.maven%', null, 'lint'),
           --GRADLE CODEGEN
           (null, 'com.gradleup.jaxb.tasks.GenerateJaxb2Classes', 'codegen'),
           (null, 'com.ewerk.gradle.plugins.tasks.GenerateJaxb2Classes', 'codegen'),
           (null, 'com.intershop.gradle.jaxb.task.JavaToSchemaTask', 'codegen'),
           (null, 'com.intershop.gradle.jaxb.task.SchemaToJavaTask', 'codegen'),
           (null, 'org.openrepose.gradle.plugins.jaxb.task.JaxbXjc', 'codegen'),
           (null, 'io.swagger.v3.plugins.gradle.tasks.ResolveTask', 'codegen'),
           ('org.openapitools.generator.gradle.plugin.tasks%', null, 'codegen'),
           ('com.graphql_java_generator.gradleplugin%', null, 'codegen'),
           (null, 'com.google.protobuf.gradle.GenerateProtoTask', 'codegen'),
           (null, 'org.gradle.api.plugins.antlr.AntlrTask', 'codegen'),
           ('io.freefair.gradle.plugin%', null, 'codegen'),
           ('io.freefair.gradle.plugins%', null, 'codegen'),
           ('com.github.davidmc24.gradle.plugin.avro%', null, 'codegen'),
           ('org.springframework.cloud.contract.verifier.plugin%', null, 'codegen'),
           --GRADLE LINT
           (null, 'org.gradle.api.plugins.quality.Checkstyle', 'lint'),
           (null, 'com.github.spotbugs.snom.SpotBugsTask', 'lint'),
           (null, 'org.gradle.api.plugins.quality.Pmd', 'lint'),
           ('com.diffplug.gradle.spotless%', null, 'lint'),
           ('ru.vyarus.gradle.plugin.animalsniffer%', null, 'lint'),
           --MAVEN TEST
           (null, 'org.apache.maven.plugin.failsafe.IntegrationTestMojo', 'test'),
           (null, 'org.apache.maven.plugin.surefire.SurefirePlugin', 'test'),
           --GRADLE TEST
           (null, 'org.gradle.api.tasks.testing.Test', 'test'),
           --COMPILE
           ('%Compile%', null, 'compile'),
           --OTHER
           ('%JavaDoc%', null, 'other_cacheable'),
           ('%Javadoc%', null, 'other_cacheable')) as t(typematch, typename, category)
         );


CREATE
OR REPLACE VIEW "gradle_task_summary" AS
        WITH gradle_tasks AS (SELECT gradleattributes.rootprojectname                                    projectname
                                   , gradlebuildcacheperformance.buildcaches.remote.isenabled            remote_build_cache_enabled
                                   , gradlebuildcacheperformance.buildcaches.remote.ispushenabled        remote_build_cache_push_enabled
                                   , gradlebuildcacheperformance.buildcaches.remote.isdisabledduetoerror remote_build_cache_disabled_due_to_error
                                   , gradlebuildcacheperformance.buildcaches.local.isenabled             local_build_cache_enabled
                                   , gradlebuildcacheperformance.buildcaches.local.ispushenabled         local_build_cache_push_enabled
                                   , gradlebuildcacheperformance.buildcaches.local.isdisabledduetoerror  local_build_cache_disabled_due_to_error
                                   , gradleattributes.buildoptions.buildcacheenabled                     build_cache_enabled
                                   , COALESCE(gradlebuildcacheperformance.serializationfactor, 1)        serialization_factor
                                   , id                                                                  build_id
                                   , ARRAY_JOIN(gradleattributes.requestedtasks, ' ')                    requested_tasks
                                   , gradlebuildcacheperformance.taskexecution                           tasks
                                   , startdate                                                           build_start_date
                                   , gradleattributes.tags                                               tags
                                   , gradleattributes.hasfailed                                          has_failed
                                   , gradleattributes.buildduration                                      build_duration_millis
                                   , type                                                                build_tool
                                   , gradleattributes.buildstarttime                                     build_start_time
                              FROM "develocity-db"."build"
                              WHERE (type = 'gradle'))
SELECT build_id
     , build_tool
     , build_start_date
     , build_start_time
     , remote_build_cache_enabled
     , remote_build_cache_push_enabled
     , remote_build_cache_disabled_due_to_error
     , local_build_cache_enabled
     , local_build_cache_push_enabled
     , local_build_cache_disabled_due_to_error
     , build_cache_enabled
     , requested_tasks
     , projectname
     , has_failed
     , build_duration_millis
     , (CASE
            WHEN (contains(tags, 'CI') = true) THEN 'CI'
            WHEN (contains(tags, 'CI') = false) THEN 'Local' END)                              environment
     , taskexecution.tasktype                                                                  task_type
     , taskexecution.duration                                                                  task_duration_millis
     , taskexecution.avoidanceoutcome                                                          avoidance_outcome
     , taskexecution.avoidancesavings                                                          avoidance_savings_millis
     , taskexecution.cacheartifactsize                                                         cache_artifact_size
     , taskexecution.fingerprintingduration                                                    fingerprinting_duration_millis
     , serialization_factor
     , taskexecution.noncacheabilitycategory                                                   non_cacheability_category
     , taskexecution.cachekey                                                                  task_cachekey
     , taskexecution.taskpath                                                                  task_path
     , COALESCE(t.category, 'other')                                                           task_category
     , (CASE
            WHEN (taskexecution.noncacheabilitycategory = 'build_cache_not_enabled') THEN 'potentially_avoidable'
            WHEN (taskexecution.noncacheabilitycategory = 'build_cache_disabled_by_user') THEN 'potentially_avoidable'
            WHEN (taskexecution.noncacheabilitycategory = 'multiple_outputs_declared') THEN 'potentially_avoidable'
            WHEN (taskexecution.noncacheabilitycategory = 'no_outputs_declared') THEN 'potentially_avoidable'
            WHEN (taskexecution.noncacheabilitycategory = 'task_output_caching_not_enabled')
                THEN 'potentially_avoidable'
            WHEN (taskexecution.noncacheabilitycategory = 'overlapping_outputs') THEN 'potentially_avoidable'
            WHEN (taskexecution.noncacheabilitycategory = 'cache-if_condition_not_matched') THEN 'unavoidable'
            WHEN (taskexecution.noncacheabilitycategory = 'disabled_to_ensure_correctness') THEN 'unavoidable'
            WHEN (taskexecution.noncacheabilitycategory = 'do-not-cache-if_condition_matched') THEN 'unavoidable'
            WHEN (taskexecution.noncacheabilitycategory = 'non_cacheable_inputs') THEN 'unavoidable'
            WHEN (taskexecution.noncacheabilitycategory = 'non_cacheable_task_action') THEN 'unavoidable'
            WHEN (taskexecution.noncacheabilitycategory = 'non_cacheable_task_implementation') THEN 'unavoidable'
            WHEN (taskexecution.noncacheabilitycategory = 'non_cacheable_tree_output') THEN 'unavoidable'
            WHEN (taskexecution.noncacheabilitycategory = 'task_has_no_actions') THEN 'unavoidable'
            WHEN (taskexecution.noncacheabilitycategory = 'not_entitled') THEN 'unknown'
            WHEN (taskexecution.noncacheabilitycategory = 'unknown') THEN 'unknown'
            WHEN (taskexecution.noncacheabilitycategory = 'unknown_entitlements') THEN 'unknown'
            WHEN (taskexecution.noncacheabilitycategory = 'offline_build') THEN 'unknown' END) category
FROM ((gradle_tasks
    CROSS JOIN UNNEST(tasks) t (taskexecution))
    LEFT JOIN task_mapping t ON ((taskexecution.tasktype LIKE t.typematch) OR (taskexecution.tasktype = t.typename)))
WHERE ((projectname IS NOT NULL) AND (serialization_factor <> 0) AND (taskexecution.cachekey IS NOT NULL));

CREATE
OR REPLACE VIEW "maven_goal_summary" AS
        WITH maven_goals AS (SELECT mavenattributes.toplevelprojectname                                projectname
                                  , mavenbuildcacheperformance.buildcaches.remote.isenabled            remote_build_cache_enabled
                                  , mavenbuildcacheperformance.buildcaches.remote.ispushenabled        remote_build_cache_push_enabled
                                  , mavenbuildcacheperformance.buildcaches.remote.isdisabledduetoerror remote_build_cache_disabled_due_to_error
                                  , mavenbuildcacheperformance.buildcaches.local.isenabled             local_build_cache_enabled
                                  , mavenbuildcacheperformance.buildcaches.local.ispushenabled         local_build_cache_push_enabled
                                  , mavenbuildcacheperformance.buildcaches.local.isdisabledduetoerror  local_build_cache_disabled_due_to_error
                                  , (mavenbuildcacheperformance.buildcaches.local.isenabled OR
                                     mavenbuildcacheperformance.buildcaches.remote.isenabled)          build_cache_enabled
                                  , id                                                                 build_id
                                  , ARRAY_JOIN(mavenattributes.requestedgoals, ' ')                    requested_goals
                                  , mavenbuildcacheperformance.goalexecution                           goals
                                  , startdate                                                          build_start_date
                                  , mavenattributes.tags                                               tags
                                  , mavenattributes.hasfailed                                          has_failed
                                  , COALESCE(mavenbuildcacheperformance.serializationfactor, 1)        serialization_factor
                                  , mavenattributes.buildduration                                      build_duration_millis
                                  , type                                                               build_tool
                                  , mavenattributes.buildstarttime                                     build_start_time
                             FROM "develocity-db"."build"
                             WHERE (type = 'maven'))
SELECT build_id
     , build_tool
     , build_start_date
     , build_start_time
     , remote_build_cache_enabled
     , remote_build_cache_push_enabled
     , remote_build_cache_disabled_due_to_error
     , local_build_cache_enabled
     , local_build_cache_push_enabled
     , local_build_cache_disabled_due_to_error
     , build_cache_enabled
     , requested_goals
     , projectname
     , has_failed
     , build_duration_millis
     , (CASE
            WHEN (contains(tags, 'CI') = true) THEN 'CI'
            WHEN (contains(tags, 'CI') = false) THEN 'Local' END)                              environment
     , goalexecution.mojotype                                                                  goal_mojo_type
     , goalexecution.duration                                                                  goal_duration_millis
     , goalexecution.avoidanceoutcome                                                          avoidance_outcome
     , goalexecution.avoidancesavings                                                          avoidance_savings_millis
     , goalexecution.cacheartifactsize                                                         cache_artifact_size
     , goalexecution.fingerprintingduration                                                    fingerprinting_duration_millis
     , serialization_factor
     , goalexecution.noncacheabilitycategory                                                   non_cacheability_category
     , goalexecution.cachekey                                                                  goal_cachekey
     , goalexecution.goalname                                                                  goal_path
     , COALESCE(t.category, 'other')                                                           goal_category
     , (CASE
            WHEN (goalexecution.noncacheabilitycategory = 'build_cache_disabled_by_user') THEN 'potentially_avoidable'
            WHEN (goalexecution.noncacheabilitycategory = 'no_gradle_enterprise_server_configured')
                THEN 'potentially_avoidable'
            WHEN (goalexecution.noncacheabilitycategory = 'no_develocity_server_configured')
                THEN 'potentially_avoidable'
            WHEN (goalexecution.noncacheabilitycategory = 'non_clean_build') THEN 'potentially_avoidable'
            WHEN (goalexecution.noncacheabilitycategory = 'goal_execution_marked_non_cacheable') THEN 'unavoidable'
            WHEN (goalexecution.noncacheabilitycategory = 'goal_not_supported') THEN 'unavoidable'
            WHEN (goalexecution.noncacheabilitycategory = 'cache-if_condition_not_matched') THEN 'unavoidable'
            WHEN (goalexecution.noncacheabilitycategory = 'disabled_to_ensure_correctness') THEN 'unavoidable'
            WHEN (goalexecution.noncacheabilitycategory = 'not_entitled') THEN 'unknown'
            WHEN (goalexecution.noncacheabilitycategory = 'unknown') THEN 'unknown'
            WHEN (goalexecution.noncacheabilitycategory = 'unknown_entitlements') THEN 'unknown'
            WHEN (goalexecution.noncacheabilitycategory = 'offline_build') THEN 'unknown' END) category
FROM ((maven_goals
    CROSS JOIN UNNEST(goals) t (goalexecution))
    LEFT JOIN task_mapping t ON ((goalexecution.mojotype LIKE t.typematch) OR (goalexecution.mojotype = t.typename)))
WHERE ((projectname IS NOT NULL) AND (serialization_factor <> 0) AND (goalexecution.cachekey IS NOT NULL));

CREATE
OR REPLACE VIEW "unit_execution_summary" AS
SELECT build_id
     , build_tool
     , build_start_date
     , build_start_time
     , remote_build_cache_enabled
     , remote_build_cache_push_enabled
     , remote_build_cache_disabled_due_to_error
     , local_build_cache_enabled
     , local_build_cache_push_enabled
     , local_build_cache_disabled_due_to_error
     , build_cache_enabled
     , requested_goals      requested_goals_or_tasks
     , projectname
     , has_failed
     , build_duration_millis
     , environment
     , goal_mojo_type       goal_or_task_type
     , goal_duration_millis goal_or_task_duration_millis
     , avoidance_outcome
     , avoidance_savings_millis
     , cache_artifact_size
     , fingerprinting_duration_millis
     , serialization_factor
     , non_cacheability_category
     , goal_cachekey        goal_or_task_cache_key
     , goal_path            goal_or_task_path
     , goal_category        goal_or_task_category
     , category
FROM maven_goal_summary
UNION
SELECT build_id
     , build_tool
     , build_start_date
     , build_start_time
     , remote_build_cache_enabled
     , remote_build_cache_push_enabled
     , remote_build_cache_disabled_due_to_error
     , local_build_cache_enabled
     , local_build_cache_push_enabled
     , local_build_cache_disabled_due_to_error
     , build_cache_enabled
     , requested_tasks      requested_goals_or_tasks
     , projectname
     , has_failed
     , build_duration_millis
     , environment
     , task_type            goal_or_task_type
     , task_duration_millis goal_or_task_duration_millis
     , avoidance_outcome
     , avoidance_savings_millis
     , cache_artifact_size
     , fingerprinting_duration_millis
     , serialization_factor
     , non_cacheability_category
     , task_cachekey        goal_or_task_cache_key
     , task_path            goal_or_task_path
     , task_category        goal_or_task_category
     , category
FROM gradle_task_summary;
