CREATE EXTERNAL TABLE extensions_summary(
  `build_id` string,
  `type` string,
  `version` string,
  `group_id` string,
  `artifact_id` string,
  `name` string,
  `projectname` string,
  `build_tool` string,
  `build_duration_millis` bigint,
  `environment` string,
  `tags` array<string>,
  `build_start_timestamp` bigint,
  `drv_chunk_row_number` bigint)
PARTITIONED BY ( `build_start_date` date, `build_start_time` string, `drv_chunk_id` string)
ROW FORMAT SERDE 'org.apache.hadoop.hive.ql.io.orc.OrcSerde'
WITH
  serdeproperties ('orc.column.index.access'='false')
    STORED AS
       INPUTFORMAT 'org.apache.hadoop.hive.ql.io.orc.OrcInputFormat'
       OUTPUTFORMAT 'org.apache.hadoop.hive.ql.io.orc.OrcOutputFormat'
LOCATION '${s3.path}tables/extensions_summary/'
TBLPROPERTIES ('develocity.reporting.schemaversion'='${currentVersion}', 'develocity.reporting.partition.date.key'='build_start_date', 'develocity.reporting.population.order'='1', 'develocity.reporting.source'='internal_extensions_summary')
