CREATE EXTERNAL TABLE build_summary (
`projectname` string,
`requested_goals_or_tasks` string,
`username` string,
`build_duration_millis` bigint,
`has_failed` boolean,
`has_non_verification_failure` boolean,
`has_verification_failure` boolean,
`hostname` string,
`operatingsystem` string,
`build_cache_enabled` boolean,
`local_build_cache_avoidance_millis` bigint,
`remote_build_cache_avoidance_millis` bigint,
`local_build_cache_enabled` boolean,
`local_build_cache_push_enabled` boolean,
`local_build_cache_disabled_due_to_error` boolean,
`remote_build_cache_enabled` boolean,
`remote_build_cache_push_enabled` boolean,
`remote_build_cache_disabled_due_to_error` boolean,
`parallel_enabled` boolean,
`config_cache_enabled` boolean,
`config_cache_used` boolean,
`rerun_tasks_enabled` boolean,
`refresh_dependencies_enabled` boolean,
`background_upload_enabled` boolean,
`input_file_capturing_enabled` boolean,
`module_count` bigint,
`serialization_factor` double,
`build_id` string,
`build_tool` string,
`build_tool_version_full` string,
`build_tool_version_major_minor` string,
`build_tool_version_major` string,
`jvm_version_full_vendored` string,
`jvm_version_vendor` string,
`jvm_version_full` string,
`jvm_version_major` string,
`jvm_version_major_minor` string,
`environment` string,
`tags` array<string>,
`custom_values` array<struct<name:string,value:string>>,
`network_request_count` bigint,
`serial_network_request_time_millis` bigint,
`wall_clock_network_request_time_millis` bigint,
`file_download_size` bigint,
`file_download_count` bigint,
`number_of_cores` int,
`number_of_workers` int,
`resource_usage_total_system_memory` bigint,
`resource_usage_total_all_processes_cpu_median` bigint,
`resource_usage_total_build_process_cpu_median` bigint,
`resource_usage_total_build_child_processes_cpu_median` bigint,
`resource_usage_execution_all_processes_cpu_p75` bigint,
`resource_usage_total_all_processes_memory_max` bigint,
`resource_usage_total_build_process_memory_p95` bigint,
`resource_usage_total_build_child_processes_memory_p95` bigint,
`executing_goals_or_tasks_duration_millis` bigint,
`gradle_deprecations` array<struct<advice:string,documentationurl:string,removaldetails:string,summary:string,usages:array<struct<contextualadvice:string,owner:struct<location:string,type:string>>>>>,
`daemon_enabled` boolean,
`gradle_configuration_duration_millis` bigint,
`gradle_configuration_cache_outcome` string,
`gradle_configuration_cache_miss_reasons` array<string>,
`tests_test_classes_count` int,
`serial_test_work_units_execution_time` bigint,
`test_acceleration_pts_usage_status` string,
`test_acceleration_pts_usage_wall_clock_savings_millis` bigint,
`test_acceleration_pts_usage_serial_time_savings_millis` bigint,
`test_acceleration_pts_simulation_conservative_wall_clock_savings_potential` bigint,
`test_acceleration_pts_simulation_conservative_serial_time_savings_potential` bigint,
`test_acceleration_pts_simulation_conservative_work_unit_failures_predicted_count` bigint,
`test_acceleration_pts_simulation_conservative_work_unit_failures_missed_count` bigint,
`test_acceleration_pts_simulation_conservative_avoidable_test_classes_count` bigint,
`test_acceleration_pts_simulation_conservative_unavoidable_test_classes_count` bigint,
`test_acceleration_pts_simulation_conservative_test_classes_count_selected_due_to_insufficient_data` bigint,
`test_acceleration_pts_simulation_standard_wall_clock_savings_potential` bigint,
`test_acceleration_pts_simulation_standard_serial_time_savings_potential` bigint,
`test_acceleration_pts_simulation_standard_work_unit_failures_predicted_count` bigint,
`test_acceleration_pts_simulation_standard_work_unit_failures_missed_count` bigint,
`test_acceleration_pts_simulation_standard_avoidable_test_classes_count` bigint,
`test_acceleration_pts_simulation_standard_unavoidable_test_classes_count` bigint,
`test_acceleration_pts_simulation_standard_test_classes_count_selected_due_to_insufficient_data` bigint,
`test_acceleration_pts_simulation_fast_wall_clock_savings_potential` bigint,
`test_acceleration_pts_simulation_fast_serial_time_savings_potential` bigint,
`test_acceleration_pts_simulation_fast_work_unit_failures_predicted_count` bigint,
`test_acceleration_pts_simulation_fast_work_unit_failures_missed_count` bigint,
`test_acceleration_pts_simulation_fast_avoidable_test_classes_count` bigint,
`test_acceleration_pts_simulation_fast_unavoidable_test_classes_count` bigint,
`test_acceleration_pts_simulation_fast_test_classes_count_selected_due_to_insufficient_data` bigint,
`test_acceleration_td_usage_status` string,
`test_acceleration_td_wall_clock_savings_millis` bigint,
`test_acceleration_wall_clock_savings_combined_millis` bigint,
`release_year` int,
`release_number` int,
`maven_fail_never_enabled` boolean,
`maven_resume_enabled` boolean,
`build_start_timestamp` bigint,
`drv_chunk_row_number` bigint)
PARTITIONED BY ( `build_start_date` date, `build_start_time` string, `drv_chunk_id` string)
ROW FORMAT SERDE 'org.apache.hadoop.hive.ql.io.orc.OrcSerde'
WITH
  serdeproperties ('orc.column.index.access'='false')
    STORED AS
       INPUTFORMAT 'org.apache.hadoop.hive.ql.io.orc.OrcInputFormat'
       OUTPUTFORMAT 'org.apache.hadoop.hive.ql.io.orc.OrcOutputFormat'
LOCATION '${s3.path}tables/build_summary/'
TBLPROPERTIES ('develocity.reporting.schemaversion'='${currentVersion}', 'develocity.reporting.partition.date.key'='build_start_date', 'develocity.reporting.population.order'='1', 'develocity.reporting.source'='internal_build_summary')
