CREATE OR REPLACE VIEW internal_gradle_task_summary AS
WITH gradle_tasks AS (
    SELECT batchid                                                             batchid,
           gradleattributes.rootprojectname                                    projectname,
           gradlebuildcacheperformance.buildcaches.remote.isenabled            remote_build_cache_enabled,
           gradlebuildcacheperformance.buildcaches.remote.ispushenabled        remote_build_cache_push_enabled,
           gradlebuildcacheperformance.buildcaches.remote.isdisabledduetoerror remote_build_cache_disabled_due_to_error,
           gradlebuildcacheperformance.buildcaches.local.isenabled             local_build_cache_enabled,
           gradlebuildcacheperformance.buildcaches.local.ispushenabled         local_build_cache_push_enabled,
           gradlebuildcacheperformance.buildcaches.local.isdisabledduetoerror  local_build_cache_disabled_due_to_error,
           gradleattributes.buildoptions.buildcacheenabled                     build_cache_enabled,
           COALESCE(gradlebuildcacheperformance.serializationfactor, 1)        serialization_factor,
           id                                                                  build_id,
           ARRAY_JOIN(gradleattributes.requestedtasks, ' ')                    requested_tasks,
           gradlebuildcacheperformance.taskexecution                           tasks,
           startdate                                                           build_start_date,
           gradleattributes.tags                                               tags,
           gradleattributes.hasfailed                                          has_failed,
           gradleattributes.buildduration                                      build_duration_millis,
           type                                                                build_tool,
           gradleattributes.buildstarttime                                     build_start_timestamp
    FROM build
    WHERE (type = 'gradle')
)
SELECT build_id,
       batchid,
       build_tool,
       build_start_date,
       build_start_timestamp,
       remote_build_cache_enabled,
       remote_build_cache_push_enabled,
       remote_build_cache_disabled_due_to_error,
       local_build_cache_enabled,
       local_build_cache_push_enabled,
       local_build_cache_disabled_due_to_error,
       build_cache_enabled,
       requested_tasks,
       projectname,
       has_failed,
       build_duration_millis,
       tags,
       (CASE
            WHEN (contains(tags, 'CI') = true) THEN 'CI'
            WHEN (COALESCE(CONTAINS(tags, 'CI'), false) = false) THEN 'Local' END) environment,
       taskexecution.tasktype                                                                                   task_type,
       taskexecution.duration                                                                                   task_duration_millis,
       taskexecution.avoidanceoutcome                                                                           avoidance_outcome,
       taskexecution.avoidancesavings                                                                           avoidance_savings_millis,
       taskexecution.cacheartifactsize                                                                          cache_artifact_size,
       taskexecution.fingerprintingduration                                                                     fingerprinting_duration_millis,
       serialization_factor,
       taskexecution.noncacheabilitycategory                                                                    non_cacheability_category,
       taskexecution.cachekey                                                                                   task_cachekey,
       taskexecution.taskpath                                                                                   task_path,
       COALESCE(t.category, 'other')                                                                            task_category,
       (CASE
            WHEN (taskexecution.noncacheabilitycategory = 'build_cache_not_enabled') THEN 'potentially_avoidable'
            WHEN (taskexecution.noncacheabilitycategory = 'build_cache_disabled_by_user') THEN 'potentially_avoidable'
            WHEN (taskexecution.noncacheabilitycategory = 'multiple_outputs_declared') THEN 'potentially_avoidable'
            WHEN (taskexecution.noncacheabilitycategory = 'no_outputs_declared') THEN 'potentially_avoidable'
            WHEN (taskexecution.noncacheabilitycategory = 'task_output_caching_not_enabled') THEN 'potentially_avoidable'
            WHEN (taskexecution.noncacheabilitycategory = 'overlapping_outputs') THEN 'potentially_avoidable'
            WHEN (taskexecution.noncacheabilitycategory = 'cache-if_condition_not_matched') THEN 'unavoidable'
            WHEN (taskexecution.noncacheabilitycategory = 'disabled_to_ensure_correctness') THEN 'unavoidable'
            WHEN (taskexecution.noncacheabilitycategory = 'do-not-cache-if_condition_matched') THEN 'unavoidable'
            WHEN (taskexecution.noncacheabilitycategory = 'non_cacheable_inputs') THEN 'unavoidable'
            WHEN (taskexecution.noncacheabilitycategory = 'non_cacheable_task_action') THEN 'unavoidable'
            WHEN (taskexecution.noncacheabilitycategory = 'non_cacheable_task_implementation') THEN 'unavoidable'
            WHEN (taskexecution.noncacheabilitycategory = 'non_cacheable_tree_output') THEN 'unavoidable'
            WHEN (taskexecution.noncacheabilitycategory = 'task_has_no_actions') THEN 'unavoidable'
            WHEN (taskexecution.noncacheabilitycategory = 'not_entitled') THEN 'unknown'
            WHEN (taskexecution.noncacheabilitycategory = 'unknown') THEN 'unknown'
            WHEN (taskexecution.noncacheabilitycategory = 'unknown_entitlements') THEN 'unknown'
            WHEN (taskexecution.noncacheabilitycategory = 'offline_build') THEN 'unknown' END)                  category
FROM ((gradle_tasks CROSS JOIN UNNEST(tasks) t (taskexecution)) LEFT JOIN internal_task_mapping t
      ON ((taskexecution.tasktype LIKE t.typematch) OR (taskexecution.tasktype = t.typename)))
WHERE ((projectname IS NOT NULL) AND (serialization_factor <> 0) AND (taskexecution.cachekey IS NOT NULL))
