variable "grafana_url" {
  type        = string
  description = "The URL of the AWS Managed Grafana instance to use"
}

variable "grafana_token" {
  type = string

  description = "The API token of the AWS Managed Grafana instance to use"
}

variable "data_catalog_name" {
  type    = string
  default = "AwsDataCatalog"

  description = "The name of the AWS Glue Data Catalog to use"
}

variable "db_name" {
  type = string

  description = "The name of the AWS Glue Database to use"
}

variable "workgroup" {
  type        = string
  default     = "develocity-drv-grafana-athena-workgroup"
  description = "The name of the AWS Athena workgroup to use"
}

variable "aws_region" {
  type        = string
  description = "The AWS region to use"
}
