CREATE OR REPLACE VIEW internal_extensions_summary AS
SELECT build.id                                                                       build_id,
       extensions.type                                                                type,
       extensions.version                                                             version,
       extensions.groupid                                                             group_id,
       extensions.artifactid                                                          artifact_id,
       CONCAT(extensions.groupid, ':', extensions.artifactid) AS                      name,
       startdate                                                                      build_start_date,
       mavenattributes.toplevelprojectname                                            projectname,
       build.type                                                                           build_tool,
       mavenattributes.buildduration                                                  build_duration_millis,
       mavenattributes.tags                                                           tags,
       batchid                                                                    batchid,
       (CASE
          WHEN (contains(build.mavenattributes.tags, 'CI') = true) THEN 'CI'
          WHEN (contains(build.mavenattributes.tags, 'CI') = false) THEN 'Local' END) environment
FROM build,
     unnest(build.mavenextensions.extensions) t (extensions)
WHERE (mavenattributes.toplevelprojectname IS NOT NULL)
