CREATE EXTERNAL TABLE dependency_summary (
`build_id` string,
`dependency_unversioned_id` string,
`dependency_versioned_id` string,
`scheme` string,
`type` string,
`namespace` string,
`name` string,
`version` string,
`qualifiers` map<string,string>,
`qualifiers_json` string,
`subpath` string,
`purl` string,
`build_duration_millis` bigint,
`projectname` string,
`vcs_repo` string,
`build_tool` string,
`environment` string,
`tags` array<string>
)
PARTITIONED BY (`build_start_date` date, `batchid` bigint)
ROW FORMAT SERDE 'org.apache.hadoop.hive.ql.io.orc.OrcSerde'
WITH
  serdeproperties ('orc.column.index.access'='false')
    STORED AS
       INPUTFORMAT 'org.apache.hadoop.hive.ql.io.orc.OrcInputFormat'
       OUTPUTFORMAT 'org.apache.hadoop.hive.ql.io.orc.OrcOutputFormat'
LOCATION '${s3.path}/tables/dependency_summary/'
TBLPROPERTIES ('develocity.reporting.schemaversion'='2', 'develocity.reporting.partition.date.key'='build_start_date', 'develocity.reporting.population.order'='1', 'develocity.reporting.source'='internal_dependency_summary')
