CREATE OR REPLACE VIEW dependency_summary AS
  WITH
    view_base AS (SELECT COALESCE(mavenattributes.toplevelprojectname, gradleattributes.rootprojectname) projectname
                       , COALESCE(gradleattributes.tags, mavenattributes.tags)                           tags
                       , id                                                                              build_id
                       , type                                                                            build_tool
                       , startdate                                                                       build_start_date
                       , COALESCE(gradleattributes.buildduration, mavenattributes.buildduration)         build_duration_millis
                       , COALESCE(gradleattributes."values", mavenattributes."values")                   custom_values
                       , COALESCE(gradledependencies.dependencies, mavendependencies.dependencies)       dependencies
    FROM build)
  SELECT view_base.build_id                                                 build_id
       , concat(
    dependency.scheme, ':', dependency.type,
    if(dependency.namespace is null, '', concat('/', dependency.namespace)),
    '/', dependency.name)                                                   dependency_unversioned_id
       , concat(
    dependency.scheme, ':', dependency.type,
    if(dependency.namespace is null, '', concat('/', dependency.namespace)),
    '/', dependency.name,
    if(dependency.version is null, '', concat('@', dependency.version)))    dependency_versioned_id
       , dependency.scheme                                                  scheme
       , dependency.type                                                    type
       , dependency.namespace                                               namespace
       , dependency.name                                                    name
       , dependency.version                                                 version
       , dependency.qualifiers                                              qualifiers
       , json_format(CAST(dependency.qualifiers as json))                   qualifiers_json
       , dependency.subpath                                                 subpath
       , dependency.purl                                                    purl
       , view_base.build_start_date                                         build_start_date
       , view_base.build_duration_millis                                    build_duration_millis
       , view_base.projectname                                              projectname
       , element_at(
    filter(view_base.custom_values, entry -> entry.name = 'Git repository')
    , 1
         ).value                                                            vcs_repo
       , view_base.build_tool                                               build_tool
       , (CASE
            WHEN (contains(view_base.tags, 'CI') = true) THEN 'CI'
            WHEN (contains(view_base.tags, 'CI') = false) THEN 'Local' END) environment
       , view_base.tags                                                     tags
  FROM view_base,
       unnest(dependencies) as t(dependency)
  WHERE view_base.projectname IS NOT NULL
