CREATE
OR REPLACE VIEW "plugin_summary" AS
SELECT build.id                                                                          build_id,
       COALESCE(plugins.id, plugins.classname)                                           plugin_id,
       plugins.version                                                                   version,
       plugins.projects                                                                  modules,
       startdate                                                                         build_start_date,
       gradleattributes.rootprojectname                                                  projectname,
       type                                                                              build_tool,
       gradleattributes.buildduration                                                    build_duration_millis,
       gradleattributes.tags                                                             tags,
       (CASE
            WHEN (CONTAINS(build.gradleattributes.tags, 'CI') = true) THEN 'CI'
            WHEN (CONTAINS(build.gradleattributes.tags, 'CI') = false) THEN 'Local' END) environment
FROM "develocity-db"."build",
     unnest(build.gradleplugins.plugins) as t(plugins)
WHERE (gradleattributes.rootprojectname IS NOT NULL)

UNION ALL
SELECT build.id                                                                         build_id,
       plugins.name                                                                     plugin_id,
       plugins.version                                                                  version,
       plugins.modules                                                                  modules,
       startdate                                                                        build_start_date,
       mavenattributes.toplevelprojectname                                              projectname,
       type                                                                             build_tool,
       mavenattributes.buildduration                                                    build_duration_millis,
       mavenattributes.tags                                                             tags,
       (CASE
            WHEN (CONTAINS(build.mavenattributes.tags, 'CI') = true) THEN 'CI'
            WHEN (CONTAINS(build.mavenattributes.tags, 'CI') = false) THEN 'Local' END) environment
FROM "develocity-db"."build",
     unnest(build.mavenplugins.plugins) as t(plugins)
WHERE (mavenattributes.toplevelprojectname IS NOT NULL)